/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.MessageStatusCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiAuthenticationCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiConfidentialityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiIntegrityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class RmcpPlusOpenSessionResponse
extends AbstractSessionIpmiPayload {
    public MessageStatusCode messageStatusCode;
    public AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel;
    public IpmiAuthenticationCode authenticationCode;
    public IpmiConfidentialityCode confidentialityCode;
    public IpmiIntegrityCode integrityCode;
    public int consoleSessionId;
    public int systemSessionId;

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 0;
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        this.messageTag = buffer.get();
        this.messageStatusCode = IpmiCode.fromBuffer(MessageStatusCode.class, buffer);
        this.maximumPrivilegeLevel = IpmiCode.fromBufferWithMask(AbstractSessionIpmiPayload.MaximumPrivilegeLevel.class, buffer, 15);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 1);
        this.consoleSessionId = ByteOrderUtils.readLeInt(buffer);
        this.systemSessionId = ByteOrderUtils.readLeInt(buffer);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 4);
        this.authenticationCode = IpmiCode.fromBuffer(IpmiAuthenticationCode.class, buffer);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 3);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 4);
        this.integrityCode = IpmiCode.fromBuffer(IpmiIntegrityCode.class, buffer);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 3);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 4);
        this.confidentialityCode = IpmiCode.fromBuffer(IpmiConfidentialityCode.class, buffer);
        RmcpPlusOpenSessionResponse.ignoreBytes(buffer, 3);
    }

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.RMCPOpenSessionResponse;
    }
}

