/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.desc.StmtCacheInfo;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DBWarning;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCachePool;
import dm.jdbc.filter.Filterable;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbStatement
extends Filterable
implements Statement {
    public int handle;
    public boolean innerExec = false;
    public String cursorName;
    public boolean readBaseColName;
    public ExecuteRetInfo execInfo = new ExecuteRetInfo();
    public DmdbConnection connection;
    public int resultSetType;
    public int resultSetConcurrency;
    public int resultSetHoldability;
    public String nativeSql;
    public int maxFieldSize;
    public long maxRows;
    public boolean escapeProcessing;
    public int queryTimeout;
    public int fetchDirection = 1000;
    public int fetchSize;
    public long cursorUpdateRow;
    public boolean closeOnCompletion = false;
    public boolean closed = true;
    public SQLWarning warnings;
    public List batchSqls = null;
    public DmdbResultSet curResultSet;
    public List openedResultSets = new ArrayList(3);
    public boolean poolable = true;
    public Column[] columns = new Column[0];
    public int type = 1;
    public static final int STATEMENT = 1;
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 3;
    public boolean running = false;
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public boolean clearBatch = true;
    public Map tempMap = new HashMap();
    public int sqlType = -1;

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbStatement(DmdbConnection dmdbConnection, int n2, int n3, int n4, boolean bl) {
        super(dmdbConnection, null);
        if (n2 == 1005) {
            dmdbConnection.addSQLWarning(DBWarning.getSQLWarning(DBError.ECJDBC_WARNING_UNSUPPORT_RESULTSET_TYPE));
            n2 = 1004;
        }
        this.connection = dmdbConnection;
        this.resultSetType = n2;
        this.resultSetConcurrency = n3;
        this.resultSetHoldability = n4;
        this.escapeProcessing = dmdbConnection.escapeProcess;
        this.maxRows = dmdbConnection.maxRows;
        this.queryTimeout = dmdbConnection.sessionTimeout;
        this.allocateHandle(bl);
    }

    protected void allocateHandle(boolean bl) {
        StmtCacheInfo stmtCacheInfo;
        StmtCacheInfo stmtCacheInfo2 = stmtCacheInfo = this.connection.stmtPool != null && this.connection.stmtPool.size() > 0 ? (StmtCacheInfo)this.connection.stmtPool.get() : null;
        if (stmtCacheInfo != null && bl) {
            this.handle = stmtCacheInfo.handle;
            this.cursorName = stmtCacheInfo.cursorName;
            this.readBaseColName = stmtCacheInfo.readBaseColName;
        } else {
            this.connection.dbAccess.a(this);
            long l2 = this.handle;
            if (this.handle < 0) {
                l2 = 0xFFFFFFFFL & l2;
            }
            this.cursorName = "DM7CUR" + l2;
        }
        this.closed = false;
    }

    public boolean do_execute(String string) {
        return this.do_execute(string, 2);
    }

    public boolean do_execute(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)0, n2 == 1);
            boolean bl = this.curResultSet != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public boolean do_execute(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public boolean do_execute(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_execute(string, n2);
    }

    public DmdbResultSet do_executeQuery(String string) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)1, false);
            DmdbResultSet dmdbResultSet = this.curResultSet == null ? DmdbResultSet.newEmptyResultSet(this) : this.curResultSet;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string) {
        return this.do_executeUpdate(string, 2);
    }

    public int do_executeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            int n3 = this.do_getUpdateCount();
            return n3;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int do_executeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeUpdate(string, n2);
    }

    public int[] do_executeBatch() {
        try {
            this.beforeExecute();
            if (this.connection.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwz(new Object[0]);
            }
            if (this.batchSqls != null && this.batchSqls.size() > 0) {
                int n2 = this.batchSqls.size();
                int[] nArray = new int[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.batchSqls.get(n3), (short)2, false);
                        nArray[n3] = ConvertUtil.toInt(this.do_getLargeUpdateCount());
                        if (this.execInfo.hasResultSet) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        nArray[n3] = -3;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.connection.batchContinueOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            int[] nArray2 = new int[n3];
                            System.arraycopy(nArray, 0, nArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, nArray);
                }
                int[] nArray3 = nArray;
                return nArray3;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            if (this.clearBatch) {
                this.do_clearBatch();
            }
            this.afterExecute();
        }
    }

    public void do_addBatch(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
        }
        if (this.batchSqls == null) {
            this.batchSqls = new ArrayList(10);
        }
        this.batchSqls.add(string);
    }

    public void do_clearBatch() {
        if (this.batchSqls != null && this.batchSqls.size() > 0) {
            this.batchSqls.clear();
        }
    }

    public void do_setPoolable(boolean bl) {
        this.poolable = bl;
    }

    public boolean do_isPoolable() {
        return this.poolable;
    }

    public void reconnect(boolean bl) {
        this.free();
        this.allocateHandle(bl);
    }

    public void do_close() {
        this.do_clearBatch();
        this.do_clearWarnings();
        this.clearResultSets();
        try {
            if (!this.pool()) {
                this.free();
            }
        }
        finally {
            if (this.connection != null && this.connection.activeStmtList != null) {
                this.connection.activeStmtList.remove(this);
            }
            this.connection = null;
            this.closed = true;
        }
    }

    public boolean pool() {
        if (!this.closed && this.poolable && this.connection.stmtPoolSize > 0) {
            this.connection.stmtPool.put(new StmtCacheInfo(this.handle, this.cursorName, this.readBaseColName));
            return true;
        }
        return false;
    }

    public void free() {
        this.clearResultSets();
        try {
            if (!this.closed && this.connection != null && this.connection.dbAccess != null && !this.connection.closed) {
                this.connection.dbAccess.b(this.handle);
            }
        }
        catch (Throwable throwable) {}
        this.closed = true;
    }

    public void clearResultSets() {
        for (DmdbResultSet dmdbResultSet : this.openedResultSets) {
            if (dmdbResultSet == null) continue;
            dmdbResultSet.closed = true;
        }
        this.openedResultSets.clear();
        if (this.curResultSet != null) {
            this.curResultSet.closed = true;
            this.curResultSet = null;
        }
    }

    public void do_clearWarnings() {
        this.warnings = null;
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.warnings == sQLWarning) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    public void do_cancel() {
        this.checkClosed();
        if (this.running) {
            this.connection.do_reset();
        }
    }

    public void do_setCursorName(String string) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        this.checkClosed();
        this.connection.dbAccess.a(this, string);
    }

    public DmdbResultSet do_getResultSet() {
        return this.curResultSet;
    }

    public int do_getUpdateCount() {
        return this.execInfo.hasResultSet ? -1 : ConvertUtil.toInt(this.execInfo.updateCount);
    }

    public boolean do_getMoreResults() {
        return this.do_getMoreResults(1);
    }

    public void do_setFetchDirection(int n2) {
        if (n2 == 1000 || n2 == 1001) {
            this.fetchDirection = n2;
        } else if (n2 == 1002) {
            this.fetchDirection = 1000;
        } else {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
    }

    public void do_setFetchSize(int n2) {
        if (n2 < 0 && n2 != Integer.MIN_VALUE || this.maxRows != 0L && this.maxRows != -1L && (long)n2 > this.maxRows) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.fetchSize = n2;
    }

    public boolean do_getMoreResults(int n2) {
        this.checkClosed();
        this.execInfo.updateCount = -1L;
        if (!this.execInfo.hasResultSet) {
            return false;
        }
        DmdbResultSet dmdbResultSet = this.curResultSet;
        this.curResultSet = null;
        ExecuteRetInfo executeRetInfo = this.connection.dbAccess.a(this, (short)0);
        this.execInfo.hasResultSet = executeRetInfo.hasResultSet;
        if (executeRetInfo.hasResultSet) {
            short s2 = (short)(dmdbResultSet.id + 1);
            this.curResultSet = new DmdbResultSet(s2, this, executeRetInfo);
        }
        switch (n2) {
            case 1: {
                dmdbResultSet.do_close();
                break;
            }
            case 3: {
                DmdbResultSet[] dmdbResultSetArray;
                dmdbResultSet.do_close();
                DmdbResultSet[] dmdbResultSetArray2 = dmdbResultSetArray = this.openedResultSets.toArray(new DmdbResultSet[0]);
                int n3 = dmdbResultSetArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DmdbResultSet dmdbResultSet2 = dmdbResultSetArray2[n4];
                    dmdbResultSet2.do_close();
                    ++n4;
                }
                this.openedResultSets.clear();
                break;
            }
            case 2: {
                this.openedResultSets.add(dmdbResultSet);
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
            }
        }
        return executeRetInfo.hasResultSet;
    }

    public DmdbResultSet do_getGeneratedKeys() {
        Column[] columnArray = null;
        Object object = null;
        if (this.execInfo.gkColumns != null) {
            columnArray = this.execInfo.gkColumns;
            object = (byte[][][])this.execInfo.gkDatas.toArray((T[])new byte[0][][]);
            return DmdbResultSet.newLocalResultSet(this, columnArray, object);
        }
        columnArray = new Column[]{new Column()};
        columnArray[0].type = 8;
        columnArray[0].prec = 8;
        columnArray[0].scale = 0;
        columnArray[0].typeName = "BIGINT";
        columnArray[0].name = "AUTO_GEN_KEY";
        columnArray[0].nullable = false;
        object = new byte[0][][];
        return DmdbResultSet.newLocalResultSet(this, columnArray, object);
    }

    protected void beforeExecute() {
        this.checkClosed();
        this.do_clearWarnings();
        this.clearResultSets();
        this.running = true;
    }

    protected void afterExecute() {
        this.running = false;
    }

    private void executeInner(String string, short s2, boolean bl) {
        DmdbResultSetCache dmdbResultSetCache;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
        }
        this.nativeSql = string;
        if (this.escapeProcessing) {
            try {
                this.nativeSql = this.connection.do_nativeSQL(string);
            }
            catch (Exception exception) {}
        }
        LinkedList linkedList = null;
        if (this.connection.constParaOpt) {
            linkedList = new LinkedList();
            try {
                this.nativeSql = SQLProcessor.execOpt(this.nativeSql, linkedList, this.connection.getServerEncoding());
            }
            catch (Exception exception) {
                linkedList.clear();
            }
        }
        if (this.connection.enRsCache && (dmdbResultSetCache = DmdbResultSetCachePool.getResultSetCache(this.connection.guid, this.connection.schema, this.nativeSql, this)) != null) {
            this.curResultSet = dmdbResultSetCache.getResultSet(this);
            this.execInfo = dmdbResultSetCache.execInfo;
            return;
        }
        if (linkedList != null && linkedList.size() > 0) {
            try {
                this.execInfo = this.connection.dbAccess.a(this, bl, linkedList);
            }
            catch (SQLException sQLException) {
                if (DBError.ECJDBC_COMMUNITION_ERROR.errCode == sQLException.getErrorCode() || DBError.EC_RN_OPERATION_CANCELED.errCode == sQLException.getErrorCode() || DBError.EC_EXCEED_SESSION_REQUEST_LIMIT.errCode == sQLException.getErrorCode()) {
                    throw sQLException;
                }
                this.nativeSql = string;
                this.execInfo = this.connection.dbAccess.a(this, s2, bl);
            }
        } else {
            this.execInfo = this.connection.dbAccess.a(this, s2, bl);
        }
        if (this.execInfo.hasResultSet) {
            this.curResultSet = this.createAndCacheResultSet((short)1, this.execInfo);
        }
        if (s2 == 2 && !this.connection.compatibleOracle() && this.curResultSet != null) {
            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
        }
    }

    protected DmdbResultSet createAndCacheResultSet(short s2, ExecuteRetInfo executeRetInfo) {
        if (this.connection.enRsCache && executeRetInfo.rsCacheOffset > 0 && executeRetInfo.rsDatas != null && (long)executeRetInfo.rsDatas.length == executeRetInfo.updateCount) {
            DmdbResultSetCachePool.addResultSet(this, this.nativeSql, executeRetInfo);
        }
        return new DmdbResultSet(s2, this, executeRetInfo);
    }

    protected void checkClosed() {
        if (this.connection == null || this.do_isClosed()) {
            DBError.ECJDBC_STATEMENT_HANDLE_CLOSED.throwz(new Object[0]);
        }
        this.connection.checkClosed();
    }

    public int do_getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void do_setMaxFieldSize(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxFieldSize = n2;
    }

    public int do_getMaxRows() {
        return ConvertUtil.toInt(this.maxRows);
    }

    public void do_setMaxRows(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxRows = n2;
    }

    public void do_setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    public int do_getQueryTimeout() {
        return this.queryTimeout;
    }

    public void do_setQueryTimeout(int n2) {
        if (n2 < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.queryTimeout = n2;
    }

    public SQLWarning do_getWarnings() {
        return this.warnings;
    }

    public int do_getFetchDirection() {
        return this.fetchDirection;
    }

    public int do_getFetchSize() {
        return this.fetchSize;
    }

    public int do_getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int do_getResultSetType() {
        return this.resultSetType;
    }

    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    public int do_getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    public boolean do_isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    public long do_getLargeUpdateCount() {
        return this.execInfo.hasResultSet ? -1L : this.execInfo.updateCount;
    }

    public void do_setLargeMaxRows(long l2) {
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxRows = l2;
    }

    public long do_getLargeMaxRows() {
        return this.maxRows;
    }

    public long[] do_executeLargeBatch() {
        try {
            this.beforeExecute();
            if (this.connection.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwz(new Object[0]);
            }
            if (this.batchSqls != null && this.batchSqls.size() > 0) {
                int n2 = this.batchSqls.size();
                long[] lArray = new long[n2];
                ArrayList<String> arrayList = new ArrayList<String>();
                SQLException sQLException = null;
                int n3 = 0;
                while (n3 < n2) {
                    sQLException = null;
                    try {
                        this.executeInner((String)this.batchSqls.get(n3), (short)2, false);
                        lArray[n3] = this.do_getLargeUpdateCount();
                        if (this.execInfo.hasResultSet) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
                        }
                    }
                    catch (SQLException sQLException2) {
                        lArray[n3] = -3L;
                        sQLException = sQLException2;
                    }
                    if (sQLException != null) {
                        if (this.connection.batchContinueOnError) {
                            arrayList.add("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            SQLWarning sQLWarning = new SQLWarning("sql[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning(sQLWarning);
                        } else {
                            long[] lArray2 = new long[n3];
                            System.arraycopy(lArray, 0, lArray2, 0, n3);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray2);
                        }
                    }
                    ++n3;
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : arrayList) {
                        stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, lArray);
                }
                long[] lArray3 = lArray;
                return lArray3;
            }
            long[] lArray = new long[]{};
            return lArray;
        }
        finally {
            if (this.clearBatch) {
                this.do_clearBatch();
            }
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string) {
        return this.do_executeLargeUpdate(string, 2);
    }

    public long do_executeLargeUpdate(String string, int n2) {
        try {
            this.beforeExecute();
            this.executeInner(string, (short)2, n2 == 1);
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String string, int[] nArray) {
        int n2 = nArray != null && nArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    public long do_executeLargeUpdate(String string, String[] stringArray) {
        int n2 = stringArray != null && stringArray.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(string, n2);
    }

    protected void checkConnection() {
        if (this.connection == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeQuery(string);
            }
            return this.filterChain.reset().Statement_executeQuery(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Statement_close(this);
            }
        }
    }

    @Override
    public int getMaxFieldSize() {
        if (this.filterChain == null) {
            return this.do_getMaxFieldSize();
        }
        return this.filterChain.reset().Statement_getMaxFieldSize(this);
    }

    @Override
    public void setMaxFieldSize(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxFieldSize(n2);
        } else {
            this.filterChain.reset().Statement_setMaxFieldSize(this, n2);
        }
    }

    @Override
    public int getMaxRows() {
        if (this.filterChain == null) {
            return this.do_getMaxRows();
        }
        return this.filterChain.reset().Statement_getMaxRows(this);
    }

    @Override
    public void setMaxRows(int n2) {
        if (this.filterChain == null) {
            this.do_setMaxRows(n2);
        } else {
            this.filterChain.reset().Statement_setMaxRows(this, n2);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        if (this.filterChain == null) {
            this.do_setEscapeProcessing(bl);
        } else {
            this.filterChain.reset().Statement_setEscapeProcessing(this, bl);
        }
    }

    @Override
    public int getQueryTimeout() {
        if (this.filterChain == null) {
            return this.do_getQueryTimeout();
        }
        return this.filterChain.reset().Statement_getQueryTimeout(this);
    }

    @Override
    public void setQueryTimeout(int n2) {
        if (this.filterChain == null) {
            this.do_setQueryTimeout(n2);
        } else {
            this.filterChain.reset().Statement_setQueryTimeout(this, n2);
        }
    }

    @Override
    public void cancel() {
        if (this.filterChain == null) {
            this.do_cancel();
        } else {
            this.filterChain.reset().Statement_cancel(this);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        if (this.filterChain == null) {
            return this.do_getWarnings();
        }
        return this.filterChain.reset().Statement_getWarnings(this);
    }

    @Override
    public void clearWarnings() {
        if (this.filterChain == null) {
            this.do_clearWarnings();
        } else {
            this.filterChain.reset().Statement_clearWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCursorName(string);
            } else {
                this.filterChain.reset().Statement_setCursorName(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string);
            }
            return this.filterChain.reset().Statement_execute(this, string);
        }
    }

    @Override
    public ResultSet getResultSet() {
        if (this.filterChain == null) {
            return this.do_getResultSet();
        }
        return this.filterChain.reset().Statement_getResultSet(this);
    }

    @Override
    public int getUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getUpdateCount();
        }
        return this.filterChain.reset().Statement_getUpdateCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults();
            }
            return this.filterChain.reset().Statement_getMoreResults(this);
        }
    }

    @Override
    public void setFetchDirection(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchDirection(n2);
        } else {
            this.filterChain.reset().Statement_setFetchDirection(this, n2);
        }
    }

    @Override
    public int getFetchDirection() {
        if (this.filterChain == null) {
            return this.do_getFetchDirection();
        }
        return this.filterChain.reset().Statement_getFetchDirection(this);
    }

    @Override
    public void setFetchSize(int n2) {
        if (this.filterChain == null) {
            this.do_setFetchSize(n2);
        } else {
            this.filterChain.reset().Statement_setFetchSize(this, n2);
        }
    }

    @Override
    public int getFetchSize() {
        if (this.filterChain == null) {
            return this.do_getFetchSize();
        }
        return this.filterChain.reset().Statement_getFetchSize(this);
    }

    @Override
    public int getResultSetConcurrency() {
        if (this.filterChain == null) {
            return this.do_getResultSetConcurrency();
        }
        return this.filterChain.reset().Statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetType() {
        if (this.filterChain == null) {
            return this.do_getResultSetType();
        }
        return this.filterChain.reset().Statement_getResultSetType(this);
    }

    @Override
    public void addBatch(String string) {
        if (this.filterChain == null) {
            this.do_addBatch(string);
        } else {
            this.filterChain.reset().Statement_addBatch(this, string);
        }
    }

    @Override
    public void clearBatch() {
        if (this.filterChain == null) {
            this.do_clearBatch();
        } else {
            this.filterChain.reset().Statement_clearBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeBatch();
            }
            return this.filterChain.reset().Statement_executeBatch(this);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().Statement_getConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMoreResults(n2);
            }
            return this.filterChain.reset().Statement_getMoreResults(this, n2);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() {
        if (this.filterChain == null) {
            return this.do_getGeneratedKeys();
        }
        return this.filterChain.reset().Statement_getGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeUpdate(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, n2);
            }
            return this.filterChain.reset().Statement_execute(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, nArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute(string, stringArray);
            }
            return this.filterChain.reset().Statement_execute(this, string, stringArray);
        }
    }

    @Override
    public int getResultSetHoldability() {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().Statement_getResultSetHoldability(this);
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Statement_isClosed(this);
    }

    @Override
    public void setPoolable(boolean bl) {
        if (this.filterChain == null) {
            this.do_setPoolable(bl);
        } else {
            this.filterChain.reset().Statement_setPoolable(this, bl);
        }
    }

    @Override
    public boolean isPoolable() {
        if (this.filterChain == null) {
            return this.do_isPoolable();
        }
        return this.filterChain.reset().Statement_isPoolable(this);
    }

    @Override
    public void closeOnCompletion() {
        if (this.filterChain == null) {
            this.do_closeOnCompletion();
        } else {
            this.filterChain.reset().Statement_closeOnCompletion(this);
        }
    }

    @Override
    public boolean isCloseOnCompletion() {
        if (this.filterChain == null) {
            return this.do_isCloseOnCompletion();
        }
        return this.filterChain.reset().Statement_isCloseOnCompletion(this);
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.filterChain == null) {
            return this.do_getLargeUpdateCount();
        }
        return this.filterChain.reset().Statement_getLargeUpdateCount(this);
    }

    @Override
    public void setLargeMaxRows(long l2) {
        if (this.filterChain == null) {
            this.do_setLargeMaxRows(l2);
        } else {
            this.filterChain.reset().Statement_setLargeMaxRows(this, l2);
        }
    }

    @Override
    public long getLargeMaxRows() {
        if (this.filterChain == null) {
            return this.do_getLargeMaxRows();
        }
        return this.filterChain.reset().Statement_getLargeMaxRows(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterChain.reset().Statement_executeLargeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, n2);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, nArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate(string, stringArray);
            }
            return this.filterChain.reset().Statement_executeLargeUpdate(this, string, stringArray);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    public RowId getRowId() {
        if (this.filterChain == null) {
            return this.do_getRowId();
        }
        return this.filterChain.reset().Statement_getRowId(this);
    }

    public RowId do_getRowId() {
        return this.execInfo != null ? this.execInfo.rowid : null;
    }

    public ResultSet[] getResultSets() {
        if (this.filterChain == null) {
            return this.do_getResultSets();
        }
        return this.filterChain.reset().Statement_getResultSets(this);
    }

    public ResultSet[] do_getResultSets() {
        return this.openedResultSets != null ? this.openedResultSets.toArray(new ResultSet[0]) : new ResultSet[]{};
    }

    public String getPrintMsg() {
        if (this.filterChain == null) {
            return this.do_getPrintMsg();
        }
        return this.filterChain.reset().Statement_getPrintMsg(this);
    }

    public String do_getPrintMsg() {
        return this.execInfo != null ? this.execInfo.printMsg : "";
    }

    public String getExplain() {
        if (this.filterChain == null) {
            return this.do_getExplain();
        }
        return this.filterChain.reset().Statement_getExplain(this);
    }

    public String do_getExplain() {
        return this.execInfo != null ? this.execInfo.explain : "";
    }

    public long getExecuteId() {
        if (this.filterChain == null) {
            return this.do_getExecuteId();
        }
        return this.filterChain.reset().Statement_getExecuteId(this);
    }

    public long do_getExecuteId() {
        return this.execInfo != null ? this.execInfo.execId : -1L;
    }

    public int getSqlType() {
        if (this.filterChain == null) {
            return this.do_getSqlType();
        }
        return this.filterChain.reset().Statement_getSqlType(this);
    }

    public int do_getSqlType() {
        int n2;
        short s2 = this.execInfo.retSqlType;
        switch (s2) {
            case 162: 
            case 178: {
                n2 = 3;
                break;
            }
            case 160: {
                n2 = 1;
                break;
            }
            case 152: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public int getRetType() {
        return this.execInfo != null ? (int)this.execInfo.retSqlType : 0;
    }

    public void resetParams(DmdbStatement dmdbStatement) {
        if (dmdbStatement.batchSqls != null && dmdbStatement.batchSqls.size() > 0) {
            this.batchSqls = this.batchSqls == null ? new ArrayList() : this.batchSqls;
            this.batchSqls.clear();
            this.batchSqls.addAll(dmdbStatement.batchSqls);
        }
    }
}

