/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports.recursive;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.imports.ExcelImportService;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelDataModel;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportForkJoinWork
extends RecursiveTask<ExcelImportResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportForkJoinWork.class);
    private int startRow;
    private int endRow;
    private Sheet sheet;
    private ImportParams params;
    private Class<?> pojoClass;
    private ExcelImportService importService;
    private String targetId;
    private Map<Integer, String> titlemap;
    private Map<String, ExcelImportEntity> excelParams;

    public ExcelImportForkJoinWork(int startRow, int endRow, Sheet sheet, ImportParams params, Class<?> pojoClass, ExcelImportService importService, String targetId, Map<Integer, String> titlemap, Map<String, ExcelImportEntity> excelParams) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.sheet = sheet;
        this.params = params;
        this.pojoClass = pojoClass;
        this.importService = importService;
        this.targetId = targetId;
        this.titlemap = titlemap;
        this.excelParams = excelParams;
    }

    @Override
    protected ExcelImportResult compute() {
        long length = this.endRow - this.startRow;
        ExcelImportResult result = null;
        if (length <= (long)this.params.getCritical().intValue()) {
            LOGGER.debug("excel import concurrent task start {} , end {}", (Object)this.startRow, (Object)this.endRow);
            return this.readRow();
        }
        int middle = (this.startRow + this.endRow) / 2;
        ExcelImportForkJoinWork right = new ExcelImportForkJoinWork(this.startRow, middle, this.sheet, this.params, this.pojoClass, this.importService, this.targetId, this.titlemap, this.excelParams);
        right.fork();
        ExcelImportForkJoinWork left = new ExcelImportForkJoinWork(middle + 1, this.endRow, this.sheet, this.params, this.pojoClass, this.importService, this.targetId, this.titlemap, this.excelParams);
        left.fork();
        result = (ExcelImportResult)right.join();
        ExcelImportResult leftResult = (ExcelImportResult)left.join();
        result.getList().addAll(leftResult.getList());
        result.getFailList().addAll(leftResult.getFailList());
        return result;
    }

    private ExcelImportResult readRow() {
        ExcelImportResult result = new ExcelImportResult();
        result.setFailList(new ArrayList());
        result.setList(new ArrayList());
        boolean isMap = Map.class.equals(this.pojoClass);
        for (int i = this.startRow; i <= this.endRow; ++i) {
            Row row = this.sheet.getRow(i);
            StringBuilder errorMsg = new StringBuilder();
            if (this.params.getKeyIndex() != null && row.getCell(this.params.getKeyIndex().intValue()) == null) continue;
            Object object = PoiPublicUtil.createObject(this.pojoClass, this.targetId);
            try {
                Set<Integer> keys = this.titlemap.keySet();
                for (Integer cn : keys) {
                    Cell cell = row.getCell(cn.intValue());
                    String titleString = this.titlemap.get(cn);
                    if (!this.excelParams.containsKey(titleString) && !isMap) continue;
                    try {
                        this.importService.saveFieldValue(this.params, object, cell, this.excelParams, titleString, row);
                    }
                    catch (ExcelImportException e) {
                        if (!this.params.isNeedVerify() || !ExcelImportEnum.GET_VALUE_ERROR.equals((Object)e.getType())) continue;
                        errorMsg.append(" ").append(titleString).append(ExcelImportEnum.GET_VALUE_ERROR.getMsg());
                    }
                }
                if (object instanceof IExcelDataModel) {
                    ((IExcelDataModel)object).setRowNum(row.getRowNum());
                }
                if (this.importService.verifyingDataValidity(object, row, this.params, isMap, errorMsg)) {
                    result.getList().add(object);
                    continue;
                }
                result.getFailList().add(object);
                continue;
            }
            catch (ExcelImportException e) {
                LOGGER.error("excel import error , row num:{},obj:{}", (Object)i, (Object)ReflectionToStringBuilder.toString((Object)object));
                if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) continue;
                throw new ExcelImportException(e.getType(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("excel import error , row num:{},obj:{}", (Object)i, (Object)ReflectionToStringBuilder.toString((Object)object));
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

