/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.kafka.constants;

import java.util.HashSet;
import java.util.Set;

public enum InternalTopic {
    CONSUMER_OFFSET("__consumer_offsets");

    private static Set<String> INTERNAL_TOPIC;
    private final String key;

    private InternalTopic(String command) {
        this.key = command;
    }

    public String getCommand() {
        return this.key;
    }

    public static boolean isInternalTopic(String str) {
        return INTERNAL_TOPIC.contains(str);
    }

    public static InternalTopic fromCommand(String command) {
        for (InternalTopic supportedCommand : InternalTopic.values()) {
            if (!supportedCommand.getCommand().equals(command)) continue;
            return supportedCommand;
        }
        throw new IllegalArgumentException("No enum constant for command: " + command);
    }

    static {
        INTERNAL_TOPIC = new HashSet<String>();
        for (InternalTopic placeholder : InternalTopic.values()) {
            INTERNAL_TOPIC.add(placeholder.getCommand());
        }
    }
}

