/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hertzbeat.manager.service.impl.AbstractImExportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JsonImExportServiceImpl
extends AbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(JsonImExportServiceImpl.class);
    private final ObjectMapper objectMapper;

    @Override
    public List<AbstractImExportServiceImpl.ExportMonitorDTO> parseImport(InputStream is) {
        try {
            return (List)this.objectMapper.readValue(is, (TypeReference)new TypeReference<List<AbstractImExportServiceImpl.ExportMonitorDTO>>(){});
        }
        catch (IOException ex) {
            log.error("import monitor failed.", (Throwable)ex);
            throw new RuntimeException("import monitor failed");
        }
    }

    @Override
    public void writeOs(List<AbstractImExportServiceImpl.ExportMonitorDTO> monitorList, OutputStream os) {
        try {
            this.objectMapper.writeValue(os, monitorList);
        }
        catch (IOException ex) {
            log.error("export monitor failed.", (Throwable)ex);
            throw new RuntimeException("export monitor failed");
        }
    }

    @Override
    public String type() {
        return "JSON";
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + ".json";
    }

    public JsonImExportServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

