/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.ai.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.hertzbeat.common.constants.AiTypeEnum;
import org.apache.hertzbeat.manager.service.ai.AiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnProperty(prefix="ai", name={"type"})
public class AiServiceFactoryImpl {
    @Autowired(required=false)
    private List<AiService> aiService;
    private Map<AiTypeEnum, AiService> aiServiceFactoryMap = new HashMap<AiTypeEnum, AiService>();

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty(this.aiService)) {
            return;
        }
        this.aiServiceFactoryMap = this.aiService.stream().collect(Collectors.toMap(AiService::getType, Function.identity()));
    }

    public AiService getAiServiceImplBean(String type) {
        Assert.notNull((Object)type, (String)"type is null");
        AiTypeEnum typeByName = AiTypeEnum.getTypeByName(type);
        Assert.notNull((Object)((Object)typeByName), (String)"The current type is not supported,please check that your type value is consistent with the documentation on the website");
        AiService aiServiceImpl = this.aiServiceFactoryMap.get((Object)typeByName);
        Assert.notNull((Object)aiServiceImpl, (String)"No bean for current type found");
        return aiServiceImpl;
    }
}

