/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;

public interface BoundValue {
    public static BoundValue value(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        DefaultBoundValue boundValue = new DefaultBoundValue();
        boundValue.value = value;
        return boundValue;
    }

    public static BoundValue nullValue(Class<?> nullType) {
        Assert.requireNonNull(nullType, "nullType must not be null");
        DefaultBoundValue boundValue = new DefaultBoundValue();
        boundValue.nullType = nullType;
        return boundValue;
    }

    public boolean isNull();

    public Object getValue();

    public Class<?> getNullType();

    public static final class DefaultBoundValue
    implements BoundValue {
        private Object value;
        private Class<?> nullType;

        @Override
        public boolean isNull() {
            return this.nullType != null;
        }

        @Override
        public Class<?> getNullType() {
            return this.nullType;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

