/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.ArrayByteInput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitInput;

public class ReadBufferByteBased
implements ReadBuffer,
BufferCommons {
    private final MyDefaultBitInput bi;
    private ByteOrder byteOrder;
    private final int totalBytes;

    public ReadBufferByteBased(byte[] input) {
        this(input, ByteOrder.BIG_ENDIAN);
    }

    public ReadBufferByteBased(byte[] input, ByteOrder byteOrder) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(byteOrder);
        ArrayByteInput abi = new ArrayByteInput(input);
        this.bi = new MyDefaultBitInput(abi);
        this.byteOrder = byteOrder;
        this.totalBytes = input.length;
    }

    @Override
    public int getPos() {
        return (int)this.bi.getPos();
    }

    @Override
    public void reset(int pos) {
        this.bi.reset(pos);
    }

    public byte[] getBytes(int startPos, int endPos) {
        int numBytes = endPos - startPos;
        byte[] data = new byte[numBytes];
        System.arraycopy(((ArrayByteInput)this.bi.getDelegate()).getSource(), startPos, data, 0, numBytes);
        return data;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public boolean hasMore(int numBits) {
        return numBits / 8 <= this.totalBytes - this.getPos();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte peekByte(int offset) throws ParseException {
        int oldIndex = ((ArrayByteInput)this.bi.getDelegate()).getIndex();
        try {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex + offset);
            byte by = this.bi.readByte(false, 8);
            return by;
        }
        catch (IOException e) {
            throw new ParseException("Error peeking byte", e);
        }
        finally {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex);
        }
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
    }

    @Override
    public boolean readBit(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        try {
            return this.bi.readBoolean();
        }
        catch (IOException e) {
            throw new ParseException("Error reading bit", e);
        }
    }

    @Override
    public byte readByte(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        return this.readSignedByte(logicalName, 8, readerArgs);
    }

    @Override
    public byte[] readByteArray(String logicalName, int numberOfBytes, WithReaderArgs ... readerArgs) throws ParseException {
        byte[] bytes = new byte[numberOfBytes];
        int i = 0;
        while (i < numberOfBytes) {
            bytes[i] = this.readByte(new WithReaderArgs[0]);
            ++i;
        }
        return bytes;
    }

    @Override
    public byte readUnsignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 7) {
            throw new ParseException("unsigned byte can only contain max 4 bits");
        }
        try {
            String encoding;
            switch (encoding = this.extractEncoding(readerArgs).orElse("default")) {
                case "default": {
                    return this.bi.readByte(true, bitLength);
                }
                case "BCD": {
                    if (bitLength % 4 != 0) {
                        throw new ParseException("'BCD' encoded fields must have a length that is a multiple of 4 bits long");
                    }
                    byte digit = this.bi.readByte(true, 4);
                    if (digit < 0 || digit > 9) {
                        throw new ParseException("'BCD' encoded value is not a correctly encoded BCD value");
                    }
                    return digit;
                }
            }
            throw new ParseException("unsupported encoding '" + encoding + "'");
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned byte", e);
        }
    }

    @Override
    public short readUnsignedShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 15) {
            throw new ParseException("unsigned short can only contain max 8 bits");
        }
        try {
            String encoding;
            switch (encoding = this.extractEncoding(readerArgs).orElse("default")) {
                case "ASCII": {
                    if (bitLength % 8 != 0) {
                        throw new ParseException("'ASCII' encoded fields must have a length that is a multiple of 8 bits long");
                    }
                    int charLen = bitLength / 8;
                    byte[] stringBytes = new byte[charLen];
                    int i = 0;
                    while (i < charLen) {
                        stringBytes[i] = this.bi.readByte(false, 8);
                        ++i;
                    }
                    String stringValue = new String(stringBytes, StandardCharsets.US_ASCII);
                    stringValue = stringValue.trim();
                    return Short.parseShort(stringValue);
                }
                case "BCD": {
                    if (bitLength % 4 != 0) {
                        throw new ParseException("'BCD' encoded fields must have a length that is a multiple of 4 bits long");
                    }
                    int numDigits = bitLength / 4;
                    short value = 0;
                    int i = numDigits - 1;
                    while (i >= 0) {
                        byte digit = this.bi.readByte(true, 4);
                        if (digit < 0 || digit > 9) {
                            throw new ParseException("'BCD' encoded value is not a correctly encoded BCD value");
                        }
                        value = (short)(value + (short)((double)digit * Math.pow(10.0, i)));
                        --i;
                    }
                    return value;
                }
                case "default": {
                    return this.bi.readShort(true, bitLength);
                }
            }
            throw new ParseException("unsupported encoding '" + encoding + "'");
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned short", e);
        }
    }

    @Override
    public int readUnsignedInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 31) {
            throw new ParseException("unsigned int can only contain max 16 bits");
        }
        try {
            String encoding;
            switch (encoding = this.extractEncoding(readerArgs).orElse("default")) {
                case "ASCII": {
                    if (bitLength % 8 != 0) {
                        throw new ParseException("'ASCII' encoded fields must have a length that is a multiple of 8 bits long");
                    }
                    int charLen = bitLength / 8;
                    byte[] stringBytes = new byte[charLen];
                    int i = 0;
                    while (i < charLen) {
                        stringBytes[i] = this.bi.readByte(false, 8);
                        ++i;
                    }
                    String stringValue = new String(stringBytes, StandardCharsets.US_ASCII);
                    stringValue = stringValue.trim();
                    return Integer.parseInt(stringValue);
                }
                case "BCD": {
                    if (bitLength % 4 != 0) {
                        throw new ParseException("'BCD' encoded fields must have a length that is a multiple of 4 bits long");
                    }
                    int numDigits = bitLength / 4;
                    int value = 0;
                    int i = numDigits - 1;
                    while (i >= 0) {
                        byte digit = this.bi.readByte(true, 4);
                        if (digit < 0 || digit > 9) {
                            throw new ParseException("'BCD' encoded value is not a correctly encoded BCD value");
                        }
                        value += (int)((double)digit * Math.pow(10.0, i));
                        --i;
                    }
                    return value;
                }
                case "default": {
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        int longValue = this.bi.readInt(true, bitLength);
                        return Integer.reverseBytes(longValue) >>> 32 - bitLength;
                    }
                    return this.bi.readInt(true, bitLength);
                }
            }
            throw new ParseException("unsupported encoding '" + encoding + "'");
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned int", e);
        }
    }

    @Override
    public long readUnsignedLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 63) {
            throw new ParseException("unsigned long can only contain max 32 bits");
        }
        try {
            String encoding;
            switch (encoding = this.extractEncoding(readerArgs).orElse("default")) {
                case "ASCII": {
                    if (bitLength % 8 != 0) {
                        throw new ParseException("'ASCII' encoded fields must have a length that is a multiple of 8 bits long");
                    }
                    int charLen = bitLength / 8;
                    byte[] stringBytes = new byte[charLen];
                    int i = 0;
                    while (i < charLen) {
                        stringBytes[i] = this.bi.readByte(false, 8);
                        ++i;
                    }
                    String stringValue = new String(stringBytes, StandardCharsets.US_ASCII);
                    stringValue = stringValue.trim();
                    return Long.parseLong(stringValue);
                }
                case "BCD": {
                    if (bitLength % 4 != 0) {
                        throw new ParseException("'BCD' encoded fields must have a length that is a multiple of 4 bits long");
                    }
                    int numDigits = bitLength / 4;
                    long value = 0L;
                    int i = numDigits - 1;
                    while (i >= 0) {
                        byte digit = this.bi.readByte(true, 4);
                        if (digit < 0 || digit > 9) {
                            throw new ParseException("'BCD' encoded value is not a correctly encoded BCD value");
                        }
                        value += (long)((double)digit * Math.pow(10.0, i));
                        --i;
                    }
                    return value;
                }
                case "default": {
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        long longValue = this.bi.readLong(true, bitLength);
                        return Long.reverseBytes(longValue) >>> 32;
                    }
                    return this.bi.readLong(true, bitLength);
                }
            }
            throw new ParseException("unsupported encoding '" + encoding + "'");
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned long", e);
        }
    }

    @Override
    public BigInteger readUnsignedBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("unsigned long can only contain max 64 bits");
        }
        try {
            String encoding;
            switch (encoding = this.extractEncoding(readerArgs).orElse("default")) {
                case "ASCII": {
                    if (bitLength % 8 != 0) {
                        throw new ParseException("'ASCII' encoded fields must have a length that is a multiple of 8 bits long");
                    }
                    int charLen = bitLength / 8;
                    byte[] stringBytes = new byte[charLen];
                    int i = 0;
                    while (i < charLen) {
                        stringBytes[i] = this.bi.readByte(false, 8);
                        ++i;
                    }
                    String stringValue = new String(stringBytes, StandardCharsets.US_ASCII);
                    stringValue = stringValue.trim();
                    return new BigInteger(stringValue);
                }
                case "BCD": {
                    if (bitLength % 4 != 0) {
                        throw new ParseException("'BCD' encoded fields must have a length that is a multiple of 4 bits long");
                    }
                    int numDigits = bitLength / 4;
                    BigInteger value = BigInteger.ZERO;
                    int i = numDigits - 1;
                    while (i >= 0) {
                        byte digit = this.bi.readByte(true, 4);
                        if (digit < 0 || digit > 9) {
                            throw new ParseException("'BCD' encoded value is not a correctly encoded BCD value");
                        }
                        value = value.add(BigInteger.valueOf(digit).multiply(BigInteger.valueOf(10L).pow(i)));
                        --i;
                    }
                    return value;
                }
                case "default": {
                    long val = this.bi.readLong(false, bitLength);
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        val = Long.reverseBytes(val);
                    }
                    if (val >= 0L) {
                        return BigInteger.valueOf(val);
                    }
                    BigInteger constant = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(2L));
                    return BigInteger.valueOf(val).add(constant);
                }
            }
            throw new ParseException("unsupported encoding '" + encoding + "'");
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned big integer", e);
        }
    }

    @Override
    public byte readSignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("byte can only contain max 8 bits");
        }
        try {
            return this.bi.readByte(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed byte", e);
        }
    }

    @Override
    public short readShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("short can only contain max 16 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return Short.reverseBytes(this.bi.readShort(false, bitLength));
            }
            return this.bi.readShort(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed short", e);
        }
    }

    @Override
    public int readInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("int can only contain max 32 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return Integer.reverseBytes(this.bi.readInt(false, bitLength));
            }
            return this.bi.readInt(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed int", e);
        }
    }

    @Override
    public long readLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("long can only contain max 64 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return Long.reverseBytes(this.bi.readLong(false, bitLength));
            }
            return this.bi.readLong(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed long", e);
        }
    }

    @Override
    public BigInteger readBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public float readFloat(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        String encoding = this.extractEncoding(readerArgs).orElse("UTF-8");
        try {
            if (bitLength == 16) {
                if ("KNXFloat".equals(encoding)) {
                    return this.readKnxFloat16();
                }
                return this.readFloat16();
            }
            if (bitLength == 32) {
                return this.readFloat32(logicalName);
            }
            throw new UnsupportedOperationException("unsupported bit length (only 16 and 32 supported)");
        }
        catch (IOException e) {
            throw new ParseException("Error reading float", e);
        }
    }

    private float readKnxFloat16() throws IOException {
        boolean sign = this.bi.readBoolean();
        byte exponent = this.bi.readByte(true, 4);
        short fraction = this.bi.readShort(true, 11);
        if (sign) {
            fraction = (short)(fraction | 0xF800);
        }
        return (float)(0.01 * (double)fraction * Math.pow(2.0, exponent));
    }

    private float readFloat16() throws IOException {
        int signMultiplication;
        boolean sign = this.bi.readBoolean();
        byte exponent = this.bi.readByte(true, 5);
        short fraction = this.bi.readShort(true, 10);
        int n = signMultiplication = sign ? 1 : -1;
        if (exponent >= 1 && exponent <= 30) {
            return (float)(signMultiplication * (2 ^ exponent - 15)) * (1.0f + (float)fraction / 10.0f);
        }
        if (exponent == 0) {
            if (fraction == 0) {
                return 0.0f;
            }
            return (float)(signMultiplication * -16) * ((float)fraction / 10.0f);
        }
        if (exponent == 31) {
            if (fraction == 0) {
                return sign ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            return Float.NaN;
        }
        throw new NumberFormatException();
    }

    private float readFloat32(String logicalName) throws ParseException {
        int intValue = this.readInt(logicalName, 32, new WithReaderArgs[0]);
        return Float.intBitsToFloat(intValue);
    }

    @Override
    public double readDouble(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength == 64) {
            long longValue = this.readLong(logicalName, 64, new WithReaderArgs[0]);
            return Double.longBitsToDouble(longValue);
        }
        throw new UnsupportedOperationException("Error reading double: unsupported bit length (only 64 supported)");
    }

    @Override
    public BigDecimal readBigDecimal(String logicalName, int bitLength, WithReaderArgs ... readerArgs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public String readString(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        String encoding = this.extractEncoding(readerArgs).orElse("UTF-8");
        encoding = encoding.replaceAll("[^a-zA-Z0-9]", "");
        switch (encoding = encoding.toUpperCase()) {
            case "WINDOWS1252": 
            case "UTF8": 
            case "ASCII": {
                Charset charset;
                byte[] strBytes = new byte[bitLength / 8];
                int realLength = 0;
                boolean finishedReading = false;
                int i = 0;
                while (i < bitLength / 8 && this.hasMore(8)) {
                    try {
                        byte b = this.readByte(logicalName, new WithReaderArgs[0]);
                        if (!this.disable0Termination() && b == 0) {
                            finishedReading = true;
                        } else if (!finishedReading) {
                            strBytes[i] = b;
                            ++realLength;
                        }
                    }
                    catch (Exception e) {
                        throw new PlcRuntimeException((Throwable)e);
                    }
                    ++i;
                }
                switch (encoding) {
                    case "UTF8": {
                        charset = StandardCharsets.UTF_8;
                        break;
                    }
                    case "WINDOWS1252": {
                        charset = Charset.forName("windows-1252");
                        break;
                    }
                    default: {
                        charset = StandardCharsets.US_ASCII;
                    }
                }
                return new String(strBytes, 0, realLength, charset);
            }
            case "UTF16": 
            case "UTF16BE": 
            case "UTF16LE": {
                Charset charset;
                byte[] strBytes = new byte[bitLength / 8];
                int realLength = 0;
                boolean finishedReading = false;
                int i = 0;
                while (i < bitLength / 16 && this.hasMore(16)) {
                    try {
                        byte b1 = this.readByte(logicalName, new WithReaderArgs[0]);
                        byte b2 = this.readByte(logicalName, new WithReaderArgs[0]);
                        if (!this.disable0Termination() && b1 == 0 && b2 == 0) {
                            finishedReading = true;
                        } else if (!finishedReading) {
                            strBytes[i * 2] = b1;
                            strBytes[i * 2 + 1] = b2;
                            realLength += 2;
                        }
                    }
                    catch (Exception e) {
                        throw new PlcRuntimeException((Throwable)e);
                    }
                    ++i;
                }
                switch (encoding) {
                    case "UTF16LE": {
                        charset = StandardCharsets.UTF_16LE;
                        break;
                    }
                    case "UTF16BE": {
                        charset = StandardCharsets.UTF_16BE;
                        break;
                    }
                    default: {
                        charset = StandardCharsets.UTF_16;
                    }
                }
                return new String(strBytes, 0, realLength, charset);
            }
        }
        throw new ParseException("Unsupported encoding: " + encoding);
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
    }

    private boolean disable0Termination() {
        return Boolean.parseBoolean(System.getProperty("disable-string-0-termination", "false"));
    }
}

