/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.manager.scheduler.AssignJobs;
import org.apache.hertzbeat.manager.scheduler.ConcurrentTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHash {
    private static final Logger log = LoggerFactory.getLogger(ConsistentHash.class);
    private final ConcurrentTreeMap<Integer, Node> hashCircle = new ConcurrentTreeMap();
    private final Map<String, Node> existNodeMap = new ConcurrentHashMap<String, Node>(16);
    private final List<DispatchJob> dispatchJobCache = Collections.synchronizedList(new LinkedList());
    private static final byte VIRTUAL_NODE_DEFAULT_SIZE = 10;

    public synchronized void addVirtualNode(Node newNode, String identity) {
        int virtualHashKey = this.hash(identity);
        this.hashCircle.put(virtualHashKey, newNode);
        newNode.addVirtualNodeJobs(virtualHashKey, ConcurrentHashMap.newKeySet(16));
        Map.Entry<Integer, Node> higherVirtualNode = this.hashCircle.higherOrFirstEntry(virtualHashKey);
        Integer higherVirtualNodeKey = higherVirtualNode.getKey();
        Node higherNode = higherVirtualNode.getValue();
        Set<Long[]> dispatchJobs = higherNode.clearVirtualNodeJobs(higherVirtualNodeKey);
        if (dispatchJobs != null && !dispatchJobs.isEmpty()) {
            ConcurrentHashMap.KeySetView reDispatchJobs = ConcurrentHashMap.newKeySet(dispatchJobs.size());
            Iterator<Long[]> iterator = dispatchJobs.iterator();
            while (iterator.hasNext()) {
                Long[] jobHash = iterator.next();
                int dispatchHash = jobHash[1].intValue();
                if (dispatchHash > virtualHashKey) continue;
                reDispatchJobs.add(jobHash);
                iterator.remove();
            }
            higherNode.virtualNodeMap.put(higherVirtualNodeKey, dispatchJobs);
            Set<Long> jobIds = reDispatchJobs.stream().map(item -> item[0]).collect(Collectors.toSet());
            newNode.addVirtualNodeJobs(virtualHashKey, reDispatchJobs);
            if (higherNode != newNode) {
                higherNode.assignJobs.removeAssignJobs(jobIds);
                higherNode.assignJobs.addRemovingJobs(jobIds);
                newNode.assignJobs.addAddingJobs(jobIds);
            }
        }
    }

    public void addNode(Node newNode) {
        if (!"private".equals(newNode.mode)) {
            byte virtualNodeNum = newNode.quality == null ? (byte)10 : (byte)newNode.quality;
            for (byte i = 0; i < virtualNodeNum; i = (byte)(i + 1)) {
                this.addVirtualNode(newNode, newNode.identity + i);
            }
        }
        this.existNodeMap.put(newNode.identity, newNode);
        this.dispatchJobInCache();
    }

    public synchronized void removeVirtualNode(Node deletedNode, Integer virtualNodeHash) {
        Set<Long[]> removeJobHashSet = deletedNode.virtualNodeMap.get(virtualNodeHash);
        this.hashCircle.remove(virtualNodeHash);
        if (removeJobHashSet == null || removeJobHashSet.isEmpty()) {
            return;
        }
        Map.Entry<Integer, Node> higherVirtualEntry = this.hashCircle.higherOrFirstEntry(virtualNodeHash);
        if (higherVirtualEntry == null || higherVirtualEntry.getValue() == deletedNode) {
            higherVirtualEntry = null;
        }
        Set<Long> removeJobIds = removeJobHashSet.stream().map(item -> item[0]).collect(Collectors.toSet());
        deletedNode.assignJobs.removeAssignJobs(removeJobIds);
        deletedNode.assignJobs.addRemovingJobs(removeJobIds);
        if (higherVirtualEntry == null) {
            removeJobHashSet.forEach(value -> {
                Long jobId = value[0];
                Integer dispatchHash = value[1].intValue();
                if (removeJobIds.contains(jobId)) {
                    this.dispatchJobCache.add(new DispatchJob(dispatchHash, jobId));
                } else {
                    log.error("Get job {} from removeJobMap null.", (Object)jobId);
                }
            });
        } else {
            Node higherVirtualNode = higherVirtualEntry.getValue();
            higherVirtualNode.addVirtualNodeJobs(higherVirtualEntry.getKey(), removeJobHashSet);
            higherVirtualNode.assignJobs.addAddingJobs(removeJobIds);
        }
    }

    public Node removeNode(String name) {
        Node deletedNode = this.existNodeMap.remove(name);
        if (deletedNode == null) {
            return null;
        }
        for (Integer virtualNodeHash : deletedNode.virtualNodeMap.keySet()) {
            this.removeVirtualNode(deletedNode, virtualNodeHash);
        }
        deletedNode.destroy();
        this.dispatchJobInCache();
        return deletedNode;
    }

    public synchronized void dispatchJobInCache() {
        if (!this.dispatchJobCache.isEmpty()) {
            int size = this.dispatchJobCache.size();
            for (int index = 0; index < size; ++index) {
                DispatchJob dispatchJob = this.dispatchJobCache.remove(0);
                this.dispatchJob(dispatchJob.dispatchHash, dispatchJob.jobId, false);
            }
        }
    }

    public Map<String, Node> getAllNodes() {
        return this.existNodeMap;
    }

    public Node getNode(String collectorName) {
        return this.existNodeMap.get(collectorName);
    }

    public List<DispatchJob> getDispatchJobCache() {
        return this.dispatchJobCache;
    }

    public Node dispatchJob(String dispatchKey, Long jobId) {
        if (dispatchKey == null || StringUtils.isBlank(dispatchKey)) {
            log.error("The dispatch key can not null.");
            return null;
        }
        int dispatchHash = this.hash(dispatchKey);
        return this.dispatchJob(dispatchHash, jobId, true);
    }

    public Node preDispatchJob(String dispatchKey) {
        if (dispatchKey == null || StringUtils.isBlank(dispatchKey)) {
            log.error("The dispatch key can not null.");
            return null;
        }
        int dispatchHash = this.hash(dispatchKey);
        return this.preDispatchJob(dispatchHash);
    }

    public Node dispatchJob(Integer dispatchHash, Long jobId, boolean isFlushed) {
        if (dispatchHash == null || this.hashCircle == null || this.hashCircle.isEmpty()) {
            log.warn("There is no available collector registered. Cache the job {}.", (Object)jobId);
            this.dispatchJobCache.add(new DispatchJob(dispatchHash, jobId));
            return null;
        }
        Map.Entry<Integer, Node> ceilEntry = this.hashCircle.ceilingOrFirstEntry(dispatchHash);
        int virtualKey = ceilEntry.getKey();
        Node curNode = ceilEntry.getValue();
        curNode.addJob(virtualKey, dispatchHash, jobId, isFlushed);
        return curNode;
    }

    public Node preDispatchJob(Integer dispatchHash) {
        if (dispatchHash == null || this.hashCircle == null || this.hashCircle.isEmpty()) {
            log.warn("There is no available collector registered.");
            return null;
        }
        Map.Entry<Integer, Node> ceilEntry = this.hashCircle.ceilingOrFirstEntry(dispatchHash);
        return ceilEntry.getValue();
    }

    private int hash(long key) {
        String keyStr = String.valueOf(key);
        return this.hash(keyStr);
    }

    private int hash(String key) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < key.length(); ++i) {
            hash = (hash ^ key.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public static class Node {
        private final String identity;
        private final String mode;
        private final String ip;
        private final long uptime;
        private final Byte quality;
        private AssignJobs assignJobs;
        private Map<Integer, Set<Long[]>> virtualNodeMap;

        public Node(String identity, String mode, String ip, long uptime, Byte quality) {
            this.identity = identity;
            this.mode = mode;
            this.ip = ip;
            this.uptime = uptime;
            this.quality = quality;
            this.assignJobs = new AssignJobs();
            this.virtualNodeMap = new ConcurrentHashMap<Integer, Set<Long[]>>(10);
        }

        private synchronized void addJob(Integer virtualNodeKey, Integer dispatchHash, Long jobId, boolean isFlushed) {
            if (this.virtualNodeMap == null) {
                this.virtualNodeMap = new ConcurrentHashMap<Integer, Set<Long[]>>(10);
            }
            if (this.assignJobs == null) {
                this.assignJobs = new AssignJobs();
            }
            Set virtualNodeJob = this.virtualNodeMap.computeIfAbsent(virtualNodeKey, k -> ConcurrentHashMap.newKeySet(16));
            virtualNodeJob.add(new Long[]{jobId, dispatchHash.longValue()});
            if (isFlushed) {
                this.assignJobs.addAssignJob(jobId);
            } else {
                this.assignJobs.addAddingJob(jobId);
            }
        }

        private Set<Long[]> clearVirtualNodeJobs(Integer virtualNodeKey) {
            if (this.virtualNodeMap == null || this.virtualNodeMap.isEmpty()) {
                return null;
            }
            Set<Long[]> virtualNodeJobs = this.virtualNodeMap.remove(virtualNodeKey);
            this.virtualNodeMap.put(virtualNodeKey, ConcurrentHashMap.newKeySet(16));
            return virtualNodeJobs;
        }

        private void addVirtualNodeJobs(Integer virtualHashKey, Set<Long[]> reDispatchJobs) {
            if (reDispatchJobs == null) {
                return;
            }
            if (this.virtualNodeMap == null) {
                this.virtualNodeMap = new ConcurrentHashMap<Integer, Set<Long[]>>(16);
            }
            this.virtualNodeMap.computeIfPresent(virtualHashKey, (k, v) -> {
                reDispatchJobs.addAll((Collection<Long[]>)v);
                return v;
            });
            this.virtualNodeMap.put(virtualHashKey, reDispatchJobs);
        }

        public void removeVirtualNodeJob(Long jobId) {
            if (jobId == null || this.virtualNodeMap == null) {
                return;
            }
            for (Set<Long[]> jobSet : this.virtualNodeMap.values()) {
                Optional<Long[]> optional = jobSet.stream().filter(item -> Objects.equals(item[0], jobId)).findFirst();
                if (!optional.isPresent()) continue;
                jobSet.remove(optional.get());
                break;
            }
        }

        public AssignJobs getAssignJobs() {
            return this.assignJobs;
        }

        public void destroy() {
            if (this.assignJobs != null) {
                this.assignJobs.clear();
            }
            if (this.virtualNodeMap != null) {
                this.virtualNodeMap.clear();
            }
        }

        public String getIdentity() {
            return this.identity;
        }
    }

    public static class DispatchJob {
        private Integer dispatchHash;
        private Long jobId;

        public DispatchJob(Integer dispatchHash, Long jobId) {
            this.dispatchHash = dispatchHash;
            this.jobId = jobId;
        }

        public Long getJobId() {
            return this.jobId;
        }
    }
}

