/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.cloud.topology.FifoVirtualGroupAssignmentAlgorithm;
import org.apache.helix.cloud.topology.VirtualGroupAssignmentAlgorithm;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterTopologyConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.service.ClusterService;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTopologyGroupService {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopologyGroupService.class);
    private final HelixAdmin _helixAdmin;
    private final ClusterService _clusterService;
    private final ConfigAccessor _configAccessor;
    private final HelixDataAccessor _dataAccessor;
    private final VirtualGroupAssignmentAlgorithm _assignmentAlgorithm;

    public VirtualTopologyGroupService(HelixAdmin helixAdmin, ClusterService clusterService, ConfigAccessor configAccessor, HelixDataAccessor dataAccessor) {
        this._helixAdmin = helixAdmin;
        this._clusterService = clusterService;
        this._configAccessor = configAccessor;
        this._dataAccessor = dataAccessor;
        this._assignmentAlgorithm = FifoVirtualGroupAssignmentAlgorithm.getInstance();
    }

    public void addVirtualTopologyGroup(String clusterName, Map<String, String> customFields) {
        ClusterConfig clusterConfig = this._configAccessor.getClusterConfig(clusterName);
        Preconditions.checkState((boolean)clusterConfig.isTopologyAwareEnabled(), (Object)("Topology-aware rebalance is not enabled in cluster " + clusterName));
        String groupName = customFields.get("virtualTopologyGroupName");
        String groupNumberStr = customFields.get("virtualTopologyGroupNumber");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)groupName) ? 1 : 0) != 0, (Object)"virtualTopologyGroupName cannot be empty!");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)groupNumberStr) ? 1 : 0) != 0, (Object)"virtualTopologyGroupNumber cannot be empty!");
        int numGroups = 0;
        try {
            numGroups = Integer.parseInt(groupNumberStr);
            Preconditions.checkArgument((numGroups > 0 ? 1 : 0) != 0, (Object)"Number of virtual groups should be positive.");
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("virtualTopologyGroupNumber " + groupNumberStr + " is not an integer.", ex);
        }
        LOG.info("Computing virtual topology group for cluster {} with param {}", (Object)clusterName, customFields);
        ClusterTopology clusterTopology = this._clusterService.getClusterTopology(clusterName);
        Preconditions.checkArgument((numGroups <= clusterTopology.getAllInstances().size() ? 1 : 0) != 0, (Object)"Number of virtual groups cannot be greater than the number of instances.");
        Map assignment = this._assignmentAlgorithm.computeAssignment(numGroups, groupName, clusterTopology.toZoneMapping());
        boolean autoMaintenanceModeDisabled = Boolean.parseBoolean(customFields.getOrDefault("autoMaintenanceModeDisabled", "false"));
        if (!autoMaintenanceModeDisabled) {
            Preconditions.checkState((!this._helixAdmin.isInMaintenanceMode(clusterName) ? 1 : 0) != 0, (Object)"This operation is not allowed if cluster is already in maintenance mode before the API call. Please set autoMaintenanceModeDisabled=true if this is intended.");
            this._helixAdmin.manuallyEnableMaintenanceMode(clusterName, true, "Enable maintenanceMode for virtual topology group change.", customFields);
        }
        Preconditions.checkState((boolean)this._helixAdmin.isInMaintenanceMode(clusterName), (Object)"Cluster is not in maintenance mode. This is required for virtual topology group setting. Please set autoMaintenanceModeDisabled=false (default) to let the cluster enter maintenance mode automatically, or use autoMaintenanceModeDisabled=true and control cluster maintenance mode in client side.");
        this.updateConfigs(clusterName, clusterConfig, assignment);
        if (!autoMaintenanceModeDisabled) {
            this._helixAdmin.manuallyEnableMaintenanceMode(clusterName, false, "Disable maintenanceMode after virtual topology group change.", customFields);
        }
    }

    private void updateConfigs(String clusterName, ClusterConfig clusterConfig, Map<String, Set<String>> assignment) {
        ArrayList zkPaths = new ArrayList();
        ArrayList updaters = new ArrayList();
        VirtualTopologyGroupService.createInstanceConfigUpdater(clusterName, assignment).forEach((zkPath, updater) -> {
            zkPaths.add(zkPath);
            updaters.add(updater);
        });
        boolean[] results = this._dataAccessor.updateChildren(zkPaths, updaters, AccessOption.EPHEMERAL);
        for (int i = 0; i < results.length; ++i) {
            if (results[i]) continue;
            throw new HelixException("Failed to update instance config for path " + (String)zkPaths.get(i));
        }
        String virtualTopologyString = VirtualTopologyGroupService.computeVirtualTopologyString(clusterConfig);
        clusterConfig.setTopology(virtualTopologyString);
        clusterConfig.setFaultZoneType("virtualZone");
        this._configAccessor.updateClusterConfig(clusterName, clusterConfig);
        LOG.info("Successfully update instance and cluster config for {}", (Object)clusterName);
    }

    @VisibleForTesting
    static String computeVirtualTopologyString(ClusterConfig clusterConfig) {
        ClusterTopologyConfig clusterTopologyConfig = ClusterTopologyConfig.createFromClusterConfig((ClusterConfig)clusterConfig);
        String endNodeType = clusterTopologyConfig.getEndNodeType();
        CharSequence[] splits = new String[]{"", "virtualZone", endNodeType};
        return String.join((CharSequence)"/", splits);
    }

    @VisibleForTesting
    static Map<String, DataUpdater<ZNRecord>> createInstanceConfigUpdater(String clusterName, Map<String, Set<String>> assignment) {
        HashMap<String, DataUpdater<ZNRecord>> updaters = new HashMap<String, DataUpdater<ZNRecord>>();
        for (Map.Entry<String, Set<String>> entry : assignment.entrySet()) {
            String virtualGroup = entry.getKey();
            for (String instanceName : entry.getValue()) {
                String path = PropertyPathBuilder.instanceConfig((String)clusterName, (String)instanceName);
                updaters.put(path, (DataUpdater<ZNRecord>)((DataUpdater)currentData -> {
                    InstanceConfig instanceConfig = new InstanceConfig(currentData);
                    Map domainMap = instanceConfig.getDomainAsMap();
                    domainMap.put("virtualZone", virtualGroup);
                    instanceConfig.setDomain(domainMap);
                    return instanceConfig.getRecord();
                }));
            }
        }
        return updaters;
    }
}

