/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.helix.zookeeper.zkclient.RecursivePersistListener;

public class ZkPathRecursiveWatcherTrie {
    private final TrieNode _rootNode = new TrieNode("/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecursiveListener(String path, RecursivePersistListener listener) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path: " + path);
        }
        List<String> pathComponents = ZkPathRecursiveWatcherTrie.split(path);
        ZkPathRecursiveWatcherTrie zkPathRecursiveWatcherTrie = this;
        synchronized (zkPathRecursiveWatcherTrie) {
            TrieNode parent = this._rootNode;
            for (String part : pathComponents) {
                parent = parent.getChildren().computeIfAbsent(part, x$0 -> new TrieNode((String)x$0));
            }
            parent._recursiveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RecursivePersistListener> getAllRecursiveListeners(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        List<String> pathComponents = ZkPathRecursiveWatcherTrie.split(path);
        HashSet<RecursivePersistListener> result = new HashSet<RecursivePersistListener>();
        ZkPathRecursiveWatcherTrie zkPathRecursiveWatcherTrie = this;
        synchronized (zkPathRecursiveWatcherTrie) {
            String element;
            TrieNode cur = this._rootNode;
            Iterator<String> iterator = pathComponents.iterator();
            while (iterator.hasNext() && (cur = cur.getChild(element = iterator.next())) != null) {
                result.addAll(cur.getRecursiveListeners());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecursiveListener(String path, RecursivePersistListener listener) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        List<String> pathComponents = ZkPathRecursiveWatcherTrie.split(path);
        ZkPathRecursiveWatcherTrie zkPathRecursiveWatcherTrie = this;
        synchronized (zkPathRecursiveWatcherTrie) {
            TrieNode cur = this._rootNode;
            TrieNode highestNodeForDelete = null;
            TrieNode prevDeletable = this._rootNode;
            for (String part : pathComponents) {
                boolean candidateToDelete;
                if ((cur = cur.getChild(part)) == null) {
                    return;
                }
                boolean bl = candidateToDelete = cur.getChildren().size() == 1 && cur.getRecursiveListeners().isEmpty() || cur.getChildren().isEmpty() && cur.getRecursiveListeners().size() == 1 && cur.getRecursiveListeners().contains(listener);
                if (candidateToDelete) {
                    if (highestNodeForDelete != null) continue;
                    highestNodeForDelete = cur;
                    continue;
                }
                prevDeletable = cur;
                highestNodeForDelete = null;
            }
            if (!cur.getRecursiveListeners().contains(listener)) {
                return;
            }
            cur.getRecursiveListeners().remove(listener);
            if (highestNodeForDelete != null) {
                prevDeletable.getChildren().remove(highestNodeForDelete.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListenerOnPath(String path) {
        TrieNode cur;
        Objects.requireNonNull(path, "Path cannot be null");
        List<String> pathComponents = ZkPathRecursiveWatcherTrie.split(path);
        ZkPathRecursiveWatcherTrie zkPathRecursiveWatcherTrie = this;
        synchronized (zkPathRecursiveWatcherTrie) {
            String element;
            cur = this._rootNode;
            Iterator<String> iterator = pathComponents.iterator();
            while (iterator.hasNext() && (cur = cur.getChild(element = iterator.next())) != null) {
            }
        }
        return cur != null && !cur.getRecursiveListeners().isEmpty();
    }

    public synchronized void clear() {
        this._rootNode.getChildren().clear();
    }

    private static List<String> split(String path) {
        return Stream.of(path.split("/")).filter(t -> !t.trim().isEmpty()).collect(Collectors.toList());
    }

    @VisibleForTesting
    TrieNode getRootNode() {
        return this._rootNode;
    }

    static class TrieNode {
        final String _value;
        final Map<String, TrieNode> _children = new HashMap<String, TrieNode>(4);
        Set<RecursivePersistListener> _recursiveListeners = new HashSet<RecursivePersistListener>(4);

        private TrieNode(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }

        void addChild(String childName, TrieNode node) {
            this._children.putIfAbsent(childName, node);
        }

        @VisibleForTesting
        TrieNode getChild(String childName) {
            return this._children.get(childName);
        }

        @VisibleForTesting
        Map<String, TrieNode> getChildren() {
            return this._children;
        }

        @VisibleForTesting
        Set<RecursivePersistListener> getRecursiveListeners() {
            return this._recursiveListeners;
        }

        public String toString() {
            return "TrieNode [name=" + this._value + ", children=" + this._children.keySet() + "]";
        }
    }
}

