/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.healthcheck.ParticipantHealthReportCollectorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantHealthReportTask
extends HelixTimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(ParticipantHealthReportTask.class);
    public static final int DEFAULT_REPORT_LATENCY = 60000;
    private final int _reportLatency;
    final ParticipantHealthReportCollectorImpl _healthReportCollector;

    public ParticipantHealthReportTask(ParticipantHealthReportCollectorImpl healthReportCollector) {
        this(healthReportCollector, 60000);
    }

    public ParticipantHealthReportTask(ParticipantHealthReportCollectorImpl healthReportCollector, int reportLatency) {
        this._healthReportCollector = healthReportCollector;
        this._reportLatency = reportLatency;
    }

    @Override
    public synchronized void start() {
        if (this._timer == null) {
            LOG.info("Start HealthCheckInfoReportingTask");
            this._timer = new Timer("ParticipantHealthReportTimerTask", true);
            this._timer.scheduleAtFixedRate((TimerTask)new ParticipantHealthReportTimerTask(), new Random().nextInt(this._reportLatency), (long)this._reportLatency);
        } else {
            LOG.warn("ParticipantHealthReportTimerTask already started");
        }
    }

    @Override
    public synchronized void stop() {
        if (this._timer != null) {
            LOG.info("Stop ParticipantHealthReportTimerTask");
            this._timer.cancel();
            this._timer = null;
        } else {
            LOG.warn("ParticipantHealthReportTimerTask already stopped");
        }
    }

    class ParticipantHealthReportTimerTask
    extends TimerTask {
        ParticipantHealthReportTimerTask() {
        }

        @Override
        public void run() {
            ParticipantHealthReportTask.this._healthReportCollector.transmitHealthReports();
        }
    }
}

