/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.FixedTargetTaskRebalancer;
import org.apache.helix.task.GenericTaskRebalancer;
import org.apache.helix.task.JobRebalancer;
import org.apache.helix.task.WorkflowRebalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdealState
extends HelixProperty {
    public static final String QUERY_LIST = "PREFERENCE_LIST_QUERYS";
    private static final Logger logger = LoggerFactory.getLogger((String)IdealState.class.getName());

    public IdealState(String resourceName) {
        super(resourceName);
    }

    public IdealState(ZNRecord record) {
        super(record);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    @Deprecated
    public void setIdealStateMode(String mode) {
        this._record.setSimpleField(IdealStateProperty.IDEAL_STATE_MODE.toString(), mode);
        RebalanceMode rebalanceMode = this.normalizeRebalanceMode(IdealStateModeProperty.valueOf(mode));
        this._record.setEnumField(IdealStateProperty.REBALANCE_MODE.toString(), rebalanceMode);
    }

    public void setRebalanceMode(RebalanceMode rebalancerType) {
        this._record.setEnumField(IdealStateProperty.REBALANCE_MODE.toString(), rebalancerType);
        IdealStateModeProperty idealStateMode = this.denormalizeRebalanceMode(rebalancerType);
        this._record.setEnumField(IdealStateProperty.IDEAL_STATE_MODE.toString(), idealStateMode);
    }

    public int getMaxPartitionsPerInstance() {
        return this._record.getIntField(IdealStateProperty.MAX_PARTITIONS_PER_INSTANCE.toString(), Integer.MAX_VALUE);
    }

    public void setRebalancerClassName(String rebalancerClassName) {
        this._record.setSimpleField(IdealStateProperty.REBALANCER_CLASS_NAME.toString(), rebalancerClassName);
    }

    public String getRebalancerClassName() {
        return this._record.getSimpleField(IdealStateProperty.REBALANCER_CLASS_NAME.toString());
    }

    public void setRebalanceStrategy(String rebalanceStrategy) {
        this._record.setSimpleField(IdealStateProperty.REBALANCE_STRATEGY.name(), rebalanceStrategy);
    }

    public String getRebalanceStrategy() {
        return this._record.getSimpleField(IdealStateProperty.REBALANCE_STRATEGY.name());
    }

    public void setResourceGroupName(String resourceGroupName) {
        this._record.setSimpleField(IdealStateProperty.RESOURCE_GROUP_NAME.toString(), resourceGroupName);
    }

    public void setResourceType(String resourceType) {
        this._record.setSimpleField(IdealStateProperty.RESOURCE_TYPE.toString(), resourceType);
    }

    public String getResourceType() {
        return this._record.getSimpleField(IdealStateProperty.RESOURCE_TYPE.toString());
    }

    public void setRebalanceDelay(long delayInMilliseconds) {
        this._record.setLongField(IdealStateProperty.REBALANCE_DELAY.name(), delayInMilliseconds);
    }

    public long getRebalanceDelay() {
        return this._record.getLongField(IdealStateProperty.REBALANCE_DELAY.name(), -1L);
    }

    public void setDelayRebalanceEnabled(boolean enabled) {
        this._record.setBooleanField(ResourceConfig.ResourceConfigProperty.DELAY_REBALANCE_ENABLED.name(), enabled);
    }

    public boolean isDelayRebalanceEnabled() {
        boolean disabled = this._record.getBooleanField(IdealStateProperty.DELAY_REBALANCE_DISABLED.name(), false);
        boolean enabled = this._record.getBooleanField(ResourceConfig.ResourceConfigProperty.DELAY_REBALANCE_ENABLED.name(), true);
        if (disabled) {
            return false;
        }
        return enabled;
    }

    public String getResourceGroupName() {
        return this._record.getSimpleField(IdealStateProperty.RESOURCE_GROUP_NAME.toString());
    }

    public boolean isResourceGroupEnabled() {
        return this._record.getBooleanField(IdealStateProperty.GROUP_ROUTING_ENABLED.name(), false);
    }

    public void enableGroupRouting(boolean enabled) {
        this._record.setSimpleField(IdealStateProperty.GROUP_ROUTING_ENABLED.name(), Boolean.toString(enabled));
    }

    public boolean isExternalViewDisabled() {
        return this._record.getBooleanField(IdealStateProperty.EXTERNAL_VIEW_DISABLED.name(), false);
    }

    public void setDisableExternalView(boolean disableExternalView) {
        this._record.setSimpleField(IdealStateProperty.EXTERNAL_VIEW_DISABLED.name(), Boolean.toString(disableExternalView));
    }

    public void setMaxPartitionsPerInstance(int max) {
        this._record.setIntField(IdealStateProperty.MAX_PARTITIONS_PER_INSTANCE.toString(), max);
    }

    @Deprecated
    public IdealStateModeProperty getIdealStateMode() {
        return this._record.getEnumField(IdealStateProperty.IDEAL_STATE_MODE.toString(), IdealStateModeProperty.class, IdealStateModeProperty.AUTO);
    }

    public RebalanceMode getRebalanceMode() {
        RebalanceMode property = this._record.getEnumField(IdealStateProperty.REBALANCE_MODE.toString(), RebalanceMode.class, RebalanceMode.NONE);
        if (property == RebalanceMode.NONE) {
            property = this.normalizeRebalanceMode(this.getIdealStateMode());
            this.setRebalanceMode(property);
        }
        return property;
    }

    public void setPartitionState(String partitionName, String instanceName, String state) {
        Map<String, String> mapField = this._record.getMapField(partitionName);
        if (mapField == null) {
            this._record.setMapField(partitionName, new TreeMap<String, String>());
        }
        this._record.getMapField(partitionName).put(instanceName, state);
    }

    public Set<String> getPartitionSet() {
        if (this.getRebalanceMode() == RebalanceMode.SEMI_AUTO || this.getRebalanceMode() == RebalanceMode.FULL_AUTO || this.getRebalanceMode() == RebalanceMode.USER_DEFINED || this.getRebalanceMode() == RebalanceMode.TASK) {
            return this._record.getListFields().keySet();
        }
        if (this.getRebalanceMode() == RebalanceMode.CUSTOMIZED) {
            return this._record.getMapFields().keySet();
        }
        logger.error("Invalid ideal state mode:" + this.getResourceName());
        return Collections.emptySet();
    }

    public Map<String, String> getInstanceStateMap(String partitionName) {
        return this._record.getMapField(partitionName);
    }

    public void setInstanceStateMap(String partitionName, Map<String, String> instanceStateMap) {
        this._record.setMapField(partitionName, instanceStateMap);
    }

    public Set<String> getInstanceSet(String partitionName) {
        switch (this.getRebalanceMode()) {
            case FULL_AUTO: 
            case SEMI_AUTO: 
            case USER_DEFINED: 
            case TASK: {
                List<String> prefList = this._record.getListField(partitionName);
                if (prefList != null && !prefList.isEmpty()) {
                    return new TreeSet<String>(prefList);
                }
                Map<String, String> stateMap = this._record.getMapField(partitionName);
                if (stateMap != null && !stateMap.isEmpty()) {
                    return new TreeSet<String>(stateMap.keySet());
                }
                logger.warn(partitionName + " does NOT exist");
                break;
            }
            case CUSTOMIZED: {
                Map<String, String> stateMap = this._record.getMapField(partitionName);
                if (stateMap != null) {
                    return new TreeSet<String>(stateMap.keySet());
                }
                logger.warn(partitionName + " does NOT exist");
                break;
            }
            default: {
                logger.warn("Invalid ideal state mode: " + this.getResourceName());
            }
        }
        return Collections.emptySet();
    }

    public List<String> getPreferenceList(String partitionName) {
        List<String> instanceStateList = this._record.getListField(partitionName);
        if (instanceStateList != null) {
            return instanceStateList;
        }
        return null;
    }

    public void setPreferenceList(String partitionName, List<String> instanceList) {
        this._record.setListField(partitionName, instanceList);
    }

    public void setPreferenceLists(Map<String, List<String>> instanceLists) {
        this._record.setListFields(instanceLists);
    }

    public Map<String, List<String>> getPreferenceLists() {
        return this._record.getListFields();
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(IdealStateProperty.STATE_MODEL_DEF_REF.toString());
    }

    public void setStateModelDefRef(String stateModel) {
        this._record.setSimpleField(IdealStateProperty.STATE_MODEL_DEF_REF.toString(), stateModel);
    }

    public void setNumPartitions(int numPartitions) {
        this._record.setIntField(IdealStateProperty.NUM_PARTITIONS.toString(), numPartitions);
    }

    public int getNumPartitions() {
        return this._record.getIntField(IdealStateProperty.NUM_PARTITIONS.toString(), -1);
    }

    public void setMinActiveReplicas(int minActiveReplicas) {
        this._record.setIntField(IdealStateProperty.MIN_ACTIVE_REPLICAS.toString(), minActiveReplicas);
    }

    public int getMinActiveReplicas() {
        return this._record.getIntField(IdealStateProperty.MIN_ACTIVE_REPLICAS.toString(), -1);
    }

    public void setReplicas(String replicas) {
        this._record.setSimpleField(IdealStateProperty.REPLICAS.toString(), replicas);
    }

    public String getReplicas() {
        String replica = this._record.getSimpleField(IdealStateProperty.REPLICAS.toString());
        if (replica == null) {
            String firstPartition = null;
            switch (this.getRebalanceMode()) {
                case SEMI_AUTO: {
                    replica = this._record.getListFields().size() == 0 ? "0" : Integer.toString((firstPartition = new ArrayList<String>(this._record.getListFields().keySet()).get(0)) == null ? 0 : this._record.getListField(firstPartition).size());
                    logger.warn("could NOT find number of replicas in idealState. Use size of the first list instead. replica: " + replica + ", 1st partition: " + firstPartition);
                    break;
                }
                case CUSTOMIZED: {
                    replica = this._record.getMapFields().size() == 0 ? "0" : Integer.toString((firstPartition = new ArrayList<String>(this._record.getMapFields().keySet()).get(0)) == null ? 0 : this._record.getMapField(firstPartition).size());
                    logger.warn("could NOT find replicas in idealState. Use size of the first map instead. replica: " + replica + ", 1st partition: " + firstPartition);
                    break;
                }
                default: {
                    replica = "0";
                    logger.error("could NOT determine replicas. set to 0");
                }
            }
        }
        return replica;
    }

    public int getReplicaCount(int eligibleInstancesCount) {
        String replicaStr = this.getReplicas();
        int replica = 0;
        try {
            replica = Integer.parseInt(replicaStr);
        }
        catch (NumberFormatException ex) {
            if (replicaStr.equalsIgnoreCase(ResourceConfig.ResourceConfigConstants.ANY_LIVEINSTANCE.name())) {
                replica = eligibleInstancesCount;
            }
            logger.error("Can not determine the replica count for resource " + this.getResourceName() + ", set to 0.");
        }
        return replica;
    }

    public void setStateModelFactoryName(String name) {
        this._record.setSimpleField(IdealStateProperty.STATE_MODEL_FACTORY_NAME.toString(), name);
    }

    public String getStateModelFactoryName() {
        return this._record.getStringField(IdealStateProperty.STATE_MODEL_FACTORY_NAME.toString(), "DEFAULT");
    }

    public long getRebalanceTimerPeriod() {
        return this._record.getLongField(IdealStateProperty.REBALANCE_TIMER_PERIOD.toString(), -1L);
    }

    @Override
    public boolean isValid() {
        if (this.getNumPartitions() < 0) {
            logger.error("idealState:" + this._record.getId() + " does not have number of partitions (was " + this.getNumPartitions() + ").");
            return false;
        }
        if (this.getStateModelDefRef() == null) {
            logger.error("idealStates:" + this._record.getId() + " does not have state model definition.");
            return false;
        }
        if (this.getRebalanceMode() == RebalanceMode.SEMI_AUTO) {
            String replicaStr = this.getReplicas();
            if (replicaStr == null) {
                logger.error("invalid ideal-state. missing replicas in auto mode. record was: " + this._record.getId());
                return false;
            }
            if (!replicaStr.equals(IdealStateConstants.ANY_LIVEINSTANCE.toString())) {
                int replica = Integer.parseInt(replicaStr);
                Set<String> partitionSet = this.getPartitionSet();
                for (String partition : partitionSet) {
                    List<String> preferenceList = this.getPreferenceList(partition);
                    if (preferenceList != null && preferenceList.size() == replica) continue;
                    logger.error("invalid ideal-state. preference-list size not equals to replicas in auto mode. replica: " + replica + ", preference-list size: " + preferenceList.size() + ", record was: " + this._record.getId());
                    return false;
                }
            }
        }
        return true;
    }

    public void setInstanceGroupTag(String groupTag) {
        this._record.setSimpleField(IdealStateProperty.INSTANCE_GROUP_TAG.toString(), groupTag);
    }

    public String getInstanceGroupTag() {
        return this._record.getSimpleField(IdealStateProperty.INSTANCE_GROUP_TAG.toString());
    }

    private RebalanceMode normalizeRebalanceMode(IdealStateModeProperty mode) {
        RebalanceMode property;
        switch (mode) {
            case AUTO_REBALANCE: {
                property = RebalanceMode.FULL_AUTO;
                break;
            }
            case AUTO: {
                property = RebalanceMode.SEMI_AUTO;
                break;
            }
            case CUSTOMIZED: {
                property = RebalanceMode.CUSTOMIZED;
                break;
            }
            default: {
                String rebalancerName = this.getRebalancerClassName();
                if (rebalancerName != null) {
                    if (rebalancerName.equals(JobRebalancer.class.getName()) || rebalancerName.equals(WorkflowRebalancer.class.getName()) || rebalancerName.equals(GenericTaskRebalancer.class.getName()) || rebalancerName.equals(FixedTargetTaskRebalancer.class.getName())) {
                        property = RebalanceMode.TASK;
                        break;
                    }
                    property = RebalanceMode.USER_DEFINED;
                    break;
                }
                property = RebalanceMode.SEMI_AUTO;
            }
        }
        return property;
    }

    private IdealStateModeProperty denormalizeRebalanceMode(RebalanceMode rebalancerType) {
        IdealStateModeProperty property;
        switch (rebalancerType) {
            case FULL_AUTO: {
                property = IdealStateModeProperty.AUTO_REBALANCE;
                break;
            }
            case SEMI_AUTO: {
                property = IdealStateModeProperty.AUTO;
                break;
            }
            case CUSTOMIZED: {
                property = IdealStateModeProperty.CUSTOMIZED;
                break;
            }
            default: {
                property = IdealStateModeProperty.AUTO;
            }
        }
        return property;
    }

    public RebalanceMode rebalanceModeFromString(String mode, RebalanceMode defaultMode) {
        RebalanceMode rebalanceMode = defaultMode;
        try {
            rebalanceMode = RebalanceMode.valueOf(mode);
        }
        catch (Exception rebalanceModeException) {
            try {
                IdealStateModeProperty oldMode = IdealStateModeProperty.valueOf(mode);
                rebalanceMode = this.normalizeRebalanceMode(oldMode);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
        return rebalanceMode;
    }

    public boolean isEnabled() {
        return this._record.getBooleanField(IdealStateProperty.HELIX_ENABLED.name(), true);
    }

    public void enable(boolean enabled) {
        this._record.setSimpleField(IdealStateProperty.HELIX_ENABLED.name(), Boolean.toString(enabled));
    }

    public static enum RebalanceMode {
        FULL_AUTO,
        SEMI_AUTO,
        CUSTOMIZED,
        USER_DEFINED,
        TASK,
        NONE;

    }

    @Deprecated
    public static enum IdealStateModeProperty {
        AUTO,
        CUSTOMIZED,
        AUTO_REBALANCE;

    }

    @Deprecated
    public static enum IdealStateConstants {
        ANY_LIVEINSTANCE;

    }

    @Deprecated
    public static enum IdealStateProperty {
        NUM_PARTITIONS,
        STATE_MODEL_DEF_REF,
        STATE_MODEL_FACTORY_NAME,
        REPLICAS,
        MIN_ACTIVE_REPLICAS,
        REBALANCE_DELAY,
        DELAY_REBALANCE_DISABLED,
        IDEAL_STATE_MODE,
        REBALANCE_MODE,
        REBALANCER_CLASS_NAME,
        REBALANCE_TIMER_PERIOD,
        REBALANCE_STRATEGY,
        MAX_PARTITIONS_PER_INSTANCE,
        INSTANCE_GROUP_TAG,
        HELIX_ENABLED,
        RESOURCE_GROUP_NAME,
        RESOURCE_TYPE,
        GROUP_ROUTING_ENABLED,
        EXTERNAL_VIEW_DISABLED;

    }
}

