/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.client;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.manager.zk.BasicZkSerializer;
import org.apache.helix.manager.zk.PathBasedZkSerializer;
import org.apache.helix.manager.zk.ZkAsyncCallbacks;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public interface HelixZkClient {
    public static final int DEFAULT_OPERATION_TIMEOUT = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT = 30000;

    public List<String> subscribeChildChanges(String var1, IZkChildListener var2);

    public void unsubscribeChildChanges(String var1, IZkChildListener var2);

    public void subscribeDataChanges(String var1, IZkDataListener var2);

    public void unsubscribeDataChanges(String var1, IZkDataListener var2);

    public void subscribeStateChanges(IZkStateListener var1);

    public void unsubscribeStateChanges(IZkStateListener var1);

    public void unsubscribeAll();

    public void createPersistent(String var1);

    public void createPersistent(String var1, boolean var2);

    public void createPersistent(String var1, boolean var2, List<ACL> var3);

    public void createPersistent(String var1, Object var2);

    public void createPersistent(String var1, Object var2, List<ACL> var3);

    public String createPersistentSequential(String var1, Object var2);

    public String createPersistentSequential(String var1, Object var2, List<ACL> var3);

    public void createEphemeral(String var1);

    public void createEphemeral(String var1, List<ACL> var2);

    public String create(String var1, Object var2, CreateMode var3);

    public String create(String var1, Object var2, List<ACL> var3, CreateMode var4);

    public void createEphemeral(String var1, Object var2);

    public void createEphemeral(String var1, Object var2, List<ACL> var3);

    public String createEphemeralSequential(String var1, Object var2);

    public String createEphemeralSequential(String var1, Object var2, List<ACL> var3);

    public List<String> getChildren(String var1);

    public int countChildren(String var1);

    public boolean exists(String var1);

    public Stat getStat(String var1);

    public boolean waitUntilExists(String var1, TimeUnit var2, long var3);

    public void deleteRecursively(String var1);

    public boolean delete(String var1);

    public <T> T readData(String var1);

    public <T> T readData(String var1, boolean var2);

    public <T> T readData(String var1, Stat var2);

    public <T> T readData(String var1, Stat var2, boolean var3);

    public <T> T readDataAndStat(String var1, Stat var2, boolean var3);

    public void writeData(String var1, Object var2);

    public <T> void updateDataSerialized(String var1, DataUpdater<T> var2);

    public void writeData(String var1, Object var2, int var3);

    public Stat writeDataReturnStat(String var1, Object var2, int var3);

    public Stat writeDataGetStat(String var1, Object var2, int var3);

    public void asyncCreate(String var1, Object var2, CreateMode var3, ZkAsyncCallbacks.CreateCallbackHandler var4);

    public void asyncSetData(String var1, Object var2, int var3, ZkAsyncCallbacks.SetDataCallbackHandler var4);

    public void asyncGetData(String var1, ZkAsyncCallbacks.GetDataCallbackHandler var2);

    public void asyncExists(String var1, ZkAsyncCallbacks.ExistsCallbackHandler var2);

    public void asyncDelete(String var1, ZkAsyncCallbacks.DeleteCallbackHandler var2);

    public void watchForData(String var1);

    public List<String> watchForChilds(String var1);

    public long getCreationTime(String var1);

    public List<OpResult> multi(Iterable<Op> var1);

    public boolean waitUntilConnected(long var1, TimeUnit var3);

    public String getServers();

    public long getSessionId();

    public void close();

    public boolean isClosed();

    public byte[] serialize(Object var1, String var2);

    public <T> T deserialize(byte[] var1, String var2);

    public void setZkSerializer(ZkSerializer var1);

    public void setZkSerializer(PathBasedZkSerializer var1);

    public PathBasedZkSerializer getZkSerializer();

    public static class ZkClientConfig {
        private long _connectInitTimeout = 60000L;
        private long _operationRetryTimeout = Integer.MAX_VALUE;
        private PathBasedZkSerializer _zkSerializer;
        private String _monitorType;
        private String _monitorKey;
        private String _monitorInstanceName = null;
        private boolean _monitorRootPathOnly = true;

        public ZkClientConfig setZkSerializer(PathBasedZkSerializer zkSerializer) {
            this._zkSerializer = zkSerializer;
            return this;
        }

        public ZkClientConfig setZkSerializer(ZkSerializer zkSerializer) {
            this._zkSerializer = new BasicZkSerializer(zkSerializer);
            return this;
        }

        public ZkClientConfig setMonitorType(String monitorType) {
            this._monitorType = monitorType;
            return this;
        }

        public ZkClientConfig setMonitorKey(String monitorKey) {
            this._monitorKey = monitorKey;
            return this;
        }

        public ZkClientConfig setMonitorInstanceName(String instanceName) {
            this._monitorInstanceName = instanceName;
            return this;
        }

        public ZkClientConfig setMonitorRootPathOnly(Boolean monitorRootPathOnly) {
            this._monitorRootPathOnly = monitorRootPathOnly;
            return this;
        }

        public ZkClientConfig setOperationRetryTimeout(Long operationRetryTimeout) {
            this._operationRetryTimeout = operationRetryTimeout;
            return this;
        }

        public ZkClientConfig setConnectInitTimeout(long _connectInitTimeout) {
            this._connectInitTimeout = _connectInitTimeout;
            return this;
        }

        public PathBasedZkSerializer getZkSerializer() {
            if (this._zkSerializer == null) {
                this._zkSerializer = new BasicZkSerializer((ZkSerializer)new SerializableSerializer());
            }
            return this._zkSerializer;
        }

        public long getOperationRetryTimeout() {
            return this._operationRetryTimeout;
        }

        public String getMonitorType() {
            return this._monitorType;
        }

        public String getMonitorKey() {
            return this._monitorKey;
        }

        public String getMonitorInstanceName() {
            return this._monitorInstanceName;
        }

        public boolean isMonitorRootPathOnly() {
            return this._monitorRootPathOnly;
        }

        public long getConnectInitTimeout() {
            return this._connectInitTimeout;
        }
    }

    public static class ZkConnectionConfig {
        private final String _zkServers;
        private int _sessionTimeout = 30000;

        public ZkConnectionConfig(String zkServers) {
            this._zkServers = zkServers;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ZkConnectionConfig)) {
                return false;
            }
            ZkConnectionConfig configObj = (ZkConnectionConfig)obj;
            return (this._zkServers == null && configObj._zkServers == null || this._zkServers != null && this._zkServers.equals(configObj._zkServers)) && this._sessionTimeout == configObj._sessionTimeout;
        }

        public int hashCode() {
            return this._sessionTimeout * 31 + this._zkServers.hashCode();
        }

        public String toString() {
            return (this._zkServers + "_" + this._sessionTimeout).replaceAll("[\\W]", "_");
        }

        public ZkConnectionConfig setSessionTimeout(Integer sessionTimeout) {
            this._sessionTimeout = sessionTimeout;
            return this;
        }

        public String getZkServers() {
            return this._zkServers;
        }

        public int getSessionTimeout() {
            return this._sessionTimeout;
        }
    }
}

