/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceInfoProvider;
import org.apache.helix.PreConnectCallback;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordBucketizer;
import org.apache.helix.manager.zk.CurStateCarryOverUpdater;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.ScheduledTaskStateModelFactory;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantManager {
    private static Logger LOG = LoggerFactory.getLogger(ParticipantManager.class);
    final HelixZkClient _zkclient;
    final HelixManager _manager;
    final PropertyKey.Builder _keyBuilder;
    final String _clusterName;
    final String _instanceName;
    final String _sessionId;
    final int _sessionTimeout;
    final ConfigAccessor _configAccessor;
    final InstanceType _instanceType;
    final HelixAdmin _helixAdmin;
    final ZKHelixDataAccessor _dataAccessor;
    final DefaultMessagingService _messagingService;
    final StateMachineEngine _stateMachineEngine;
    final LiveInstanceInfoProvider _liveInstanceInfoProvider;
    final List<PreConnectCallback> _preConnectCallbacks;

    public ParticipantManager(HelixManager manager, HelixZkClient zkclient, int sessionTimeout, LiveInstanceInfoProvider liveInstanceInfoProvider, List<PreConnectCallback> preConnectCallbacks) {
        this._zkclient = zkclient;
        this._manager = manager;
        this._clusterName = manager.getClusterName();
        this._instanceName = manager.getInstanceName();
        this._keyBuilder = new PropertyKey.Builder(this._clusterName);
        this._sessionId = manager.getSessionId();
        this._sessionTimeout = sessionTimeout;
        this._configAccessor = manager.getConfigAccessor();
        this._instanceType = manager.getInstanceType();
        this._helixAdmin = manager.getClusterManagmentTool();
        this._dataAccessor = (ZKHelixDataAccessor)manager.getHelixDataAccessor();
        this._messagingService = (DefaultMessagingService)manager.getMessagingService();
        this._stateMachineEngine = manager.getStateMachineEngine();
        this._liveInstanceInfoProvider = liveInstanceInfoProvider;
        this._preConnectCallbacks = preConnectCallbacks;
    }

    public void handleNewSession() throws Exception {
        this.joinCluster();
        for (PreConnectCallback callback : this._preConnectCallbacks) {
            callback.onPreConnect();
        }
        this.createLiveInstance();
        this.carryOverPreviousCurrentState();
        this.setupMsgHandler();
    }

    private void joinCluster() {
        boolean autoJoin = false;
        try {
            HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this._manager.getClusterName()).build();
            autoJoin = Boolean.parseBoolean(this._configAccessor.get(scope, "allowParticipantAutoJoin"));
            LOG.info("instance: " + this._instanceName + " auto-joining " + this._clusterName + " is " + autoJoin);
        }
        catch (Exception scope) {
            // empty catch block
        }
        if (!ZKUtil.isInstanceSetup(this._zkclient, this._clusterName, this._instanceName, this._instanceType)) {
            if (!autoJoin) {
                throw new HelixException("Initial cluster structure is not set up for instance: " + this._instanceName + ", instanceType: " + (Object)((Object)this._instanceType));
            }
            LOG.info(this._instanceName + " is auto-joining cluster: " + this._clusterName);
            InstanceConfig instanceConfig = new InstanceConfig(this._instanceName);
            String hostName = this._instanceName;
            String port = "";
            int lastPos = this._instanceName.lastIndexOf("_");
            if (lastPos > 0) {
                hostName = this._instanceName.substring(0, lastPos);
                port = this._instanceName.substring(lastPos + 1);
            }
            instanceConfig.setHostName(hostName);
            instanceConfig.setPort(port);
            instanceConfig.setInstanceEnabled(true);
            this._helixAdmin.addInstance(this._clusterName, instanceConfig);
        }
    }

    private void createLiveInstance() {
        boolean retry;
        String liveInstancePath = this._keyBuilder.liveInstance(this._instanceName).getPath();
        LiveInstance liveInstance = new LiveInstance(this._instanceName);
        liveInstance.setSessionId(this._sessionId);
        liveInstance.setHelixVersion(this._manager.getVersion());
        liveInstance.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
        if (this._liveInstanceInfoProvider != null) {
            LOG.info("invoke liveInstanceInfoProvider");
            ZNRecord additionalLiveInstanceInfo = this._liveInstanceInfoProvider.getAdditionalLiveInstanceInfo();
            if (additionalLiveInstanceInfo != null) {
                additionalLiveInstanceInfo.merge(liveInstance.getRecord());
                ZNRecord mergedLiveInstance = new ZNRecord(additionalLiveInstanceInfo, this._instanceName);
                liveInstance = new LiveInstance(mergedLiveInstance);
                LOG.info("instanceName: " + this._instanceName + ", mergedLiveInstance: " + liveInstance);
            }
        }
        do {
            retry = false;
            try {
                this._zkclient.createEphemeral(liveInstancePath, liveInstance.getRecord());
                LOG.info("LiveInstance created, path: " + liveInstancePath + ", sessionId: " + liveInstance.getEphemeralOwner());
            }
            catch (ZkNodeExistsException e) {
                LOG.warn("found another instance with same instanceName: " + this._instanceName + " in cluster " + this._clusterName);
                Stat stat = new Stat();
                ZNRecord record = (ZNRecord)this._zkclient.readData(liveInstancePath, stat, true);
                if (record == null) {
                    retry = true;
                    continue;
                }
                String ephemeralOwner = Long.toHexString(stat.getEphemeralOwner());
                if (ephemeralOwner.equals(this._sessionId)) {
                    LiveInstance curLiveInstance = new LiveInstance(record);
                    if (curLiveInstance.getEphemeralOwner().equals(this._sessionId)) continue;
                    LOG.info("overwriting session-id by ephemeralOwner: " + ephemeralOwner + ", old-sessionId: " + curLiveInstance.getEphemeralOwner() + ", new-sessionId: " + this._sessionId);
                    curLiveInstance.setSessionId(this._sessionId);
                    this._zkclient.writeData(liveInstancePath, curLiveInstance.getRecord());
                    continue;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this._sessionTimeout + 5000);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Sleep interrupted while waiting for previous live-instance to go away.", (Throwable)ex);
                }
                retry = true;
                break;
            }
        } while (retry);
        if (retry) {
            try {
                this._zkclient.createEphemeral(liveInstancePath, liveInstance.getRecord());
                LOG.info("LiveInstance created, path: " + liveInstancePath + ", sessionId: " + liveInstance.getEphemeralOwner());
            }
            catch (Exception e) {
                String errorMessage = "instance: " + this._instanceName + " already has a live-instance in cluster " + this._clusterName;
                LOG.error(errorMessage);
                throw new HelixException(errorMessage);
            }
        }
        ParticipantHistory history = this.getHistory();
        history.reportOnline(this._sessionId, this._manager.getVersion());
        this.persistHistory(history);
        if (!liveInstance.getEphemeralOwner().equals(liveInstance.getSessionId())) {
            LOG.warn("Session ID {} (Deprecated) in the znode does not match the Ephemeral Owner session ID {}. Will use the Ephemeral Owner session ID.", (Object)liveInstance.getSessionId(), (Object)liveInstance.getEphemeralOwner());
        }
    }

    private void carryOverPreviousCurrentState() {
        List<String> sessions = this._dataAccessor.getChildNames(this._keyBuilder.sessions(this._instanceName));
        for (String session : sessions) {
            if (session.equals(this._sessionId)) continue;
            List lastCurStates = this._dataAccessor.getChildValues(this._keyBuilder.currentStates(this._instanceName, session), false);
            for (CurrentState lastCurState : lastCurStates) {
                LOG.info("Carrying over old session: " + session + ", resource: " + lastCurState.getId() + " to current session: " + this._sessionId);
                String stateModelDefRef = lastCurState.getStateModelDefRef();
                if (stateModelDefRef == null) {
                    LOG.error("skip carry-over because previous current state doesn't have a state model definition. previous current-state: " + lastCurState);
                    continue;
                }
                StateModelDefinition stateModel = (StateModelDefinition)this._dataAccessor.getProperty(this._keyBuilder.stateModelDef(stateModelDefRef));
                BaseDataAccessor<ZNRecord> baseAccessor = this._dataAccessor.getBaseDataAccessor();
                String curStatePath = this._keyBuilder.currentState(this._instanceName, this._sessionId, lastCurState.getResourceName()).getPath();
                String initState = stateModel.getInitialState();
                if (lastCurState.getBucketSize() > 0) {
                    ZNRecord metaRecord = new ZNRecord(lastCurState.getId());
                    metaRecord.setSimpleFields(lastCurState.getRecord().getSimpleFields());
                    CurStateCarryOverUpdater metaRecordUpdater = new CurStateCarryOverUpdater(this._sessionId, initState, new CurrentState(metaRecord));
                    boolean success = baseAccessor.update(curStatePath, metaRecordUpdater, AccessOption.PERSISTENT);
                    if (!success) continue;
                    ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(lastCurState.getBucketSize());
                    Map<String, ZNRecord> map = bucketizer.bucketize(lastCurState.getRecord());
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList updaters = new ArrayList();
                    for (String bucketName : map.keySet()) {
                        paths.add(curStatePath + "/" + bucketName);
                        updaters.add(new CurStateCarryOverUpdater(this._sessionId, initState, new CurrentState(map.get(bucketName))));
                    }
                    baseAccessor.updateChildren(paths, updaters, AccessOption.PERSISTENT);
                    continue;
                }
                this._dataAccessor.getBaseDataAccessor().update(curStatePath, new CurStateCarryOverUpdater(this._sessionId, initState, lastCurState), AccessOption.PERSISTENT);
            }
        }
        for (String session : sessions) {
            if (session.equals(this._sessionId)) continue;
            String path = this._keyBuilder.currentStates(this._instanceName, session).getPath();
            LOG.info("Removing current states from previous sessions. path: " + path);
            this._zkclient.deleteRecursively(path);
        }
    }

    private void setupMsgHandler() throws Exception {
        this._messagingService.registerMessageHandlerFactory(this._stateMachineEngine.getMessageTypes(), (MessageHandlerFactory)this._stateMachineEngine);
        this._manager.addMessageListener(this._messagingService.getExecutor(), this._instanceName);
        ScheduledTaskStateModelFactory stStateModelFactory = new ScheduledTaskStateModelFactory(this._messagingService.getExecutor());
        this._stateMachineEngine.registerStateModelFactory("SchedulerTaskQueue", stStateModelFactory);
        this._messagingService.onConnected();
    }

    private ParticipantHistory getHistory() {
        PropertyKey propertyKey = this._keyBuilder.participantHistory(this._instanceName);
        ParticipantHistory history = (ParticipantHistory)this._dataAccessor.getProperty(propertyKey);
        if (history == null) {
            history = new ParticipantHistory(this._instanceName);
        }
        return history;
    }

    private void persistHistory(ParticipantHistory history) {
        PropertyKey propertyKey = this._keyBuilder.participantHistory(this._instanceName);
        if (!this._dataAccessor.setProperty(propertyKey, history)) {
            LOG.error("Failed to persist participant history to zk!");
        }
    }

    public void reset() {
    }

    public void disconnect() {
        try {
            ParticipantHistory history = this.getHistory();
            history.reportOffline();
            this.persistHistory(history);
        }
        catch (Exception e) {
            LOG.error("Failed to report participant offline.", (Throwable)e);
        }
        this.reset();
    }
}

