/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.LinkedList;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.helix.healthcheck.ParticipantHealthReportCollector;
import org.apache.helix.model.HealthStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantHealthReportCollectorImpl
implements ParticipantHealthReportCollector {
    private final LinkedList<HealthReportProvider> _healthReportProviderList = new LinkedList();
    private static final Logger LOG = LoggerFactory.getLogger(ParticipantHealthReportCollectorImpl.class);
    private final HelixManager _helixManager;
    String _instanceName;

    public ParticipantHealthReportCollectorImpl(HelixManager helixManager, String instanceName) {
        this._helixManager = helixManager;
        this._instanceName = instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHealthReportProvider(HealthReportProvider provider) {
        try {
            LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
            synchronized (linkedList) {
                if (!this._healthReportProviderList.contains(provider)) {
                    this._healthReportProviderList.add(provider);
                } else {
                    LOG.warn("Skipping a duplicated HealthCheckInfoProvider");
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHealthReportProvider(HealthReportProvider provider) {
        LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
        synchronized (linkedList) {
            if (this._healthReportProviderList.contains(provider)) {
                this._healthReportProviderList.remove(provider);
            } else {
                LOG.warn("Skip removing a non-exist HealthCheckInfoProvider");
            }
        }
    }

    @Override
    public void reportHealthReportMessage(ZNRecord healthCheckInfoUpdate) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        if (!accessor.setProperty((keyBuilder = accessor.keyBuilder()).healthReport(this._instanceName, healthCheckInfoUpdate.getId()), new HealthStat(healthCheckInfoUpdate))) {
            LOG.error("Failed to persist health report to zk!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void transmitHealthReports() {
        LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
        synchronized (linkedList) {
            for (HealthReportProvider provider : this._healthReportProviderList) {
                try {
                    Map<String, String> report = provider.getRecentHealthReport();
                    Map<String, Map<String, String>> partitionReport = provider.getRecentPartitionHealthReport();
                    ZNRecord record = new ZNRecord(provider.getReportName());
                    if (report != null) {
                        record.setSimpleFields(report);
                    }
                    if (partitionReport != null) {
                        record.setMapFields(partitionReport);
                    }
                    record.setSimpleField("TimeStamp", "" + System.currentTimeMillis());
                    HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
                    PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                    if (!accessor.setProperty(keyBuilder.healthReport(this._instanceName, record.getId()), new HealthStat(record))) {
                        LOG.error("Failed to persist health report to zk!");
                    }
                    provider.resetStats();
                }
                catch (Exception e) {
                    LOG.error("fail to transmit health report", (Throwable)e);
                }
            }
        }
    }
}

