/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.dataproviders;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.common.caches.PropertyCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.stages.MissingTopStateRecord;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.ResourceAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceControllerDataProvider
extends BaseControllerDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceControllerDataProvider.class);
    private static final String PIPELINE_NAME = Pipeline.Type.DEFAULT.name();
    private final PropertyCache<ExternalView> _externalViewCache = new PropertyCache<ExternalView>(this, "ExternalView", new PropertyCache.PropertyCacheKeyFuncs<ExternalView>(){

        @Override
        public PropertyKey getRootKey(HelixDataAccessor accessor) {
            return accessor.keyBuilder().externalViews();
        }

        @Override
        public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
            return accessor.keyBuilder().externalView(objName);
        }

        @Override
        public String getObjName(ExternalView obj) {
            return obj.getResourceName();
        }
    }, true);
    private final PropertyCache<ExternalView> _targetExternalViewCache = new PropertyCache<ExternalView>(this, "TargetExternalView", new PropertyCache.PropertyCacheKeyFuncs<ExternalView>(){

        @Override
        public PropertyKey getRootKey(HelixDataAccessor accessor) {
            return accessor.keyBuilder().targetExternalViews();
        }

        @Override
        public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
            return accessor.keyBuilder().targetExternalView(objName);
        }

        @Override
        public String getObjName(ExternalView obj) {
            return obj.getResourceName();
        }
    }, true);
    private Map<String, ResourceAssignment> _resourceAssignmentCache = new HashMap<String, ResourceAssignment>();
    private Map<String, ZNRecord> _idealMappingCache = new HashMap<String, ZNRecord>();
    private Map<String, Map<String, MissingTopStateRecord>> _missingTopStateMap = new HashMap<String, Map<String, MissingTopStateRecord>>();
    private Map<String, Map<String, String>> _lastTopStateLocationMap = new HashMap<String, Map<String, String>>();

    public ResourceControllerDataProvider() {
        this("UNKNOWN_CLUSTER");
    }

    public ResourceControllerDataProvider(String clusterName) {
        super(clusterName, PIPELINE_NAME);
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        Set<HelixConstants.ChangeType> propertyRefreshed = super.doRefresh(accessor);
        if (propertyRefreshed.contains((Object)HelixConstants.ChangeType.IDEAL_STATE) || propertyRefreshed.contains((Object)HelixConstants.ChangeType.LIVE_INSTANCE) || propertyRefreshed.contains((Object)HelixConstants.ChangeType.INSTANCE_CONFIG) || propertyRefreshed.contains((Object)HelixConstants.ChangeType.RESOURCE_CONFIG)) {
            this.clearCachedResourceAssignments();
        }
        this.refreshExternalViews(accessor);
        this.refreshTargetExternalViews(accessor);
        LogUtil.logInfo(logger, this.getClusterEventId(), String.format("END: ResourceControllerDataProvider.refresh() for cluster %s, started at %d took %d for %s pipeline", this.getClusterName(), startTime, System.currentTimeMillis() - startTime, this.getPipelineName()));
        this.dumpDebugInfo();
    }

    @Override
    protected void dumpDebugInfo() {
        super.dumpDebugInfo();
        if (logger.isTraceEnabled()) {
            logger.trace("Cache content: " + this.toString());
        }
    }

    private void refreshExternalViews(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.EXTERNAL_VIEW)).getAndSet(false)) {
            this._externalViewCache.refresh(accessor);
        }
    }

    private void refreshTargetExternalViews(HelixDataAccessor accessor) {
        if (((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW)).getAndSet(false) && this.getClusterConfig() != null && this.getClusterConfig().isTargetExternalViewEnabled()) {
            this._targetExternalViewCache.refresh(accessor);
        }
    }

    public ExternalView getTargetExternalView(String resourceName) {
        return this._targetExternalViewCache.getPropertyByName(resourceName);
    }

    public void updateTargetExternalView(String resourceName, ExternalView targetExternalView) {
        this._targetExternalViewCache.setProperty(targetExternalView);
    }

    public Map<String, ExternalView> getExternalViews() {
        return this._externalViewCache.getPropertyMap();
    }

    public void updateExternalViews(List<ExternalView> externalViews) {
        for (ExternalView ev : externalViews) {
            this._externalViewCache.setProperty(ev);
        }
    }

    public void removeExternalViews(List<String> resourceNames) {
        for (String resourceName : resourceNames) {
            this._externalViewCache.deletePropertyByName(resourceName);
        }
    }

    public Map<String, Map<String, MissingTopStateRecord>> getMissingTopStateMap() {
        return this._missingTopStateMap;
    }

    public Map<String, Map<String, String>> getLastTopStateLocationMap() {
        return this._lastTopStateLocationMap;
    }

    public ResourceAssignment getCachedResourceAssignment(String resource) {
        return this._resourceAssignmentCache.get(resource);
    }

    public Map<String, ResourceAssignment> getCachedResourceAssignments() {
        return Collections.unmodifiableMap(this._resourceAssignmentCache);
    }

    public void setCachedResourceAssignment(String resource, ResourceAssignment resourceAssignment) {
        this._resourceAssignmentCache.put(resource, resourceAssignment);
    }

    public ZNRecord getCachedIdealMapping(String resource) {
        return this._idealMappingCache.get(resource);
    }

    public void invalidateCachedIdealStateMapping(String resource) {
        this._idealMappingCache.remove(resource);
    }

    public Map<String, ZNRecord> getCachedIdealMapping() {
        return Collections.unmodifiableMap(this._idealMappingCache);
    }

    public void setCachedIdealMapping(String resource, ZNRecord mapping) {
        this._idealMappingCache.put(resource, mapping);
    }

    public void clearCachedResourceAssignments() {
        this._resourceAssignmentCache.clear();
        this._idealMappingCache.clear();
    }

    public void clearMonitoringRecords() {
        this._missingTopStateMap.clear();
        this._lastTopStateLocationMap.clear();
    }
}

