/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestVerifyBucketCacheFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyBucketCacheFile.class);
    @Parameterized.Parameter(value=0)
    public int constructedBlockSize;
    @Parameterized.Parameter(value=1)
    public int[] constructedBlockSizes;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;

    @Parameterized.Parameters(name="{index}: blockSize={0}, bucketSizes={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({8192, null}, {16384, new int[]{3072, 5120, 9216, 17408, 29696, 33792, 66560, 99328, 132096}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetrieveFromFile() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", Long.MAX_VALUE);
        BucketCache bucketCache = null;
        BucketCache recoveredBucketCache = null;
        try {
            CacheTestUtils.HFileBlockPair[] blocks;
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            long usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertEquals((long)0L, (long)usedSize);
            for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
                this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
            }
            usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertNotEquals((long)0L, (long)usedSize);
            bucketCache.shutdown();
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            this.waitPersistentCacheValidation(conf, bucketCache);
            Assert.assertEquals((long)usedSize, (long)bucketCache.getAllocator().getUsedSize());
            bucketCache.shutdown();
            java.nio.file.Path cacheFile = FileSystems.getDefault().getPath(testDir.toString(), "bucket.cache");
            Assert.assertTrue((boolean)Files.deleteIfExists(cacheFile));
            recoveredBucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            this.waitPersistentCacheValidation(conf, recoveredBucketCache);
            Assert.assertEquals((long)0L, (long)recoveredBucketCache.getAllocator().getUsedSize());
            Assert.assertEquals((long)0L, (long)recoveredBucketCache.backingMap.size());
            for (CacheTestUtils.HFileBlockPair block : blocks) {
                this.cacheAndWaitUntilFlushedToBucket(recoveredBucketCache, block.getBlockName(), (Cacheable)block.getBlock());
            }
            usedSize = recoveredBucketCache.getAllocator().getUsedSize();
            Assert.assertNotEquals((long)0L, (long)usedSize);
            recoveredBucketCache.shutdown();
            java.nio.file.Path mapFile = FileSystems.getDefault().getPath(testDir.toString(), "bucket.persistence");
            Assert.assertTrue((boolean)Files.deleteIfExists(mapFile));
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            this.waitPersistentCacheValidation(conf, bucketCache);
            Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
            Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
            if (recoveredBucketCache != null) {
                recoveredBucketCache.shutdown();
            }
        }
        TEST_UTIL.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetrieveFromFileAfterDelete() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", 300L);
        String mapFileName = testDir + "/bucket.persistence" + EnvironmentEdgeManager.currentTime();
        BucketCache bucketCache = null;
        try {
            CacheTestUtils.HFileBlockPair[] blocks;
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            long usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertEquals((long)0L, (long)usedSize);
            for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
                this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
            }
            usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertNotEquals((long)0L, (long)usedSize);
            bucketCache.shutdown();
            File mapFile = new File(mapFileName);
            Assert.assertTrue((boolean)mapFile.delete());
            Thread.sleep(350L);
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            this.waitPersistentCacheValidation(conf, bucketCache);
            Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
            Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifiedBucketCacheFileData() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", Long.MAX_VALUE);
        BucketCache bucketCache = null;
        try {
            CacheTestUtils.HFileBlockPair[] blocks;
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            long usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertEquals((long)0L, (long)usedSize);
            for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
                this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
            }
            usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertNotEquals((long)0L, (long)usedSize);
            bucketCache.shutdown();
            String file = testDir + "/bucket.cache";
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, false)));){
                out.write("test bucket cache");
            }
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            this.waitPersistentCacheValidation(conf, bucketCache);
            Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
            Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
        }
        TEST_UTIL.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifiedBucketCacheFileTime() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", Long.MAX_VALUE);
        BucketCache bucketCache = null;
        try {
            CacheTestUtils.HFileBlockPair[] blocks;
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            long usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertEquals((long)0L, (long)usedSize);
            Pair myPair = new Pair();
            for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
                this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
            }
            usedSize = bucketCache.getAllocator().getUsedSize();
            Assert.assertNotEquals((long)0L, (long)usedSize);
            long blockCount = bucketCache.backingMap.size();
            Assert.assertNotEquals((long)0L, (long)blockCount);
            bucketCache.shutdown();
            java.nio.file.Path file = FileSystems.getDefault().getPath(testDir.toString(), "bucket.cache");
            Files.setLastModifiedTime(file, FileTime.from(Instant.now().plusMillis(1000L)));
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
            this.waitPersistentCacheValidation(conf, bucketCache);
            Assert.assertEquals((long)usedSize, (long)bucketCache.getAllocator().getUsedSize());
            Assert.assertEquals((long)blockCount, (long)bucketCache.backingMap.size());
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
        }
        TEST_UTIL.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketCacheRecovery() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", Long.MAX_VALUE);
        String mapFileName = testDir + "/bucket.persistence" + EnvironmentEdgeManager.currentTime();
        BucketCache bucketCache = null;
        BucketCache newBucketCache = null;
        try {
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 4);
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[0].getBlockName(), (Cacheable)blocks[0].getBlock());
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[1].getBlockName(), (Cacheable)blocks[1].getBlock());
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[2].getBlockName(), (Cacheable)blocks[2].getBlock());
            bucketCache.persistToFile();
            bucketCache.evictBlock(blocks[0].getBlockName());
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[3].getBlockName(), (Cacheable)blocks[3].getBlock());
            newBucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            this.waitPersistentCacheValidation(conf, newBucketCache);
            Assert.assertNull((Object)newBucketCache.getBlock(blocks[0].getBlockName(), false, false, false));
            Assert.assertEquals((Object)blocks[1].getBlock(), (Object)newBucketCache.getBlock(blocks[1].getBlockName(), false, false, false));
            Assert.assertEquals((Object)blocks[2].getBlock(), (Object)newBucketCache.getBlock(blocks[2].getBlockName(), false, false, false));
            Assert.assertNull((Object)newBucketCache.getBlock(blocks[3].getBlockName(), false, false, false));
            Assert.assertEquals((long)2L, (long)newBucketCache.backingMap.size());
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
            if (newBucketCache != null) {
                newBucketCache.shutdown();
            }
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testSingleChunk() throws Exception {
        this.testChunkedBackingMapRecovery(5, 5);
    }

    @Test
    public void testMultipleChunks() throws Exception {
        this.testChunkedBackingMapRecovery(5, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChunkedBackingMapRecovery(int chunkSize, int numBlocks) throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persistence.chunksize", (long)chunkSize);
        String mapFileName = testDir + "/bucket.persistence" + EnvironmentEdgeManager.currentTime();
        BucketCache bucketCache = null;
        BucketCache newBucketCache = null;
        try {
            int i;
            bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, numBlocks);
            for (i = 0; i < numBlocks; ++i) {
                this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[i].getBlockName(), (Cacheable)blocks[i].getBlock());
            }
            bucketCache.persistToFile();
            newBucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, mapFileName, 60000, conf);
            this.waitPersistentCacheValidation(conf, newBucketCache);
            Assert.assertEquals((long)numBlocks, (long)newBucketCache.backingMap.size());
            for (i = 0; i < numBlocks; ++i) {
                Assert.assertEquals((Object)blocks[i].getBlock(), (Object)newBucketCache.getBlock(blocks[i].getBlockName(), false, false, false));
            }
        }
        finally {
            if (bucketCache != null) {
                bucketCache.shutdown();
            }
            if (newBucketCache != null) {
                newBucketCache.shutdown();
            }
        }
        TEST_UTIL.cleanupTestDir();
    }

    private void waitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey) throws InterruptedException {
        while (!cache.backingMap.containsKey(cacheKey) || cache.ramCache.containsKey(cacheKey)) {
            Thread.sleep(100L);
        }
    }

    private void cacheAndWaitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey, Cacheable block) throws InterruptedException {
        cache.cacheBlock(cacheKey, block);
        this.waitUntilFlushedToBucket(cache, cacheKey);
    }

    private void waitPersistentCacheValidation(Configuration config, BucketCache bucketCache) {
        Waiter.waitFor((Configuration)config, (long)5000L, () -> bucketCache.getBackingMapValidated().get());
    }
}

