/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Cancellable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultBoundedCompletionService;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ScannerCallableWithReplicas
implements RetryingCallable<Result[]> {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerCallableWithReplicas.class);
    volatile ScannerCallable currentScannerCallable;
    AtomicBoolean replicaSwitched = new AtomicBoolean(false);
    private final ClusterConnection cConnection;
    protected final ExecutorService pool;
    private final boolean useScannerTimeoutForNextCalls;
    protected final int timeBeforeReplicas;
    private final Scan scan;
    private final int retries;
    private Result lastResult;
    private final RpcRetryingCaller<Result[]> caller;
    private final TableName tableName;
    private Configuration conf;
    private final int scannerTimeout;
    private final int readRpcTimeout;
    private Set<ScannerCallable> outstandingCallables = new HashSet<ScannerCallable>();
    private boolean someRPCcancelled = false;
    private int regionReplication = 0;

    public ScannerCallableWithReplicas(TableName tableName, ClusterConnection cConnection, ScannerCallable baseCallable, ExecutorService pool, int timeBeforeReplicas, Scan scan, int retries, int readRpcTimeout, int scannerTimeout, boolean useScannerTimeoutForNextCalls, int caching, Configuration conf, RpcRetryingCaller<Result[]> caller) {
        this.currentScannerCallable = baseCallable;
        this.cConnection = cConnection;
        this.pool = pool;
        this.useScannerTimeoutForNextCalls = useScannerTimeoutForNextCalls;
        if (timeBeforeReplicas < 0) {
            throw new IllegalArgumentException("Invalid value of operation timeout on the primary");
        }
        this.timeBeforeReplicas = timeBeforeReplicas;
        this.scan = scan;
        this.retries = retries;
        this.tableName = tableName;
        this.conf = conf;
        this.readRpcTimeout = readRpcTimeout;
        this.scannerTimeout = scannerTimeout;
        this.caller = caller;
    }

    public void setClose() {
        if (this.currentScannerCallable != null) {
            this.currentScannerCallable.setClose();
        } else {
            LOG.warn("Calling close on ScannerCallable reference that is already null, which shouldn't happen.");
        }
    }

    public void setRenew(boolean val) {
        this.currentScannerCallable.setRenew(val);
    }

    public void setCaching(int caching) {
        this.currentScannerCallable.setCaching(caching);
    }

    public int getCaching() {
        return this.currentScannerCallable.getCaching();
    }

    public HRegionInfo getHRegionInfo() {
        return this.currentScannerCallable.getHRegionInfo();
    }

    public ScannerCallable.MoreResults moreResultsInRegion() {
        return this.currentScannerCallable.moreResultsInRegion();
    }

    public ScannerCallable.MoreResults moreResultsForScan() {
        return this.currentScannerCallable.moreResultsForScan();
    }

    @Override
    public Result[] call(int timeout) throws IOException {
        if (this.currentScannerCallable != null && this.currentScannerCallable.closed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Closing scanner id=" + this.currentScannerCallable.scannerId);
            }
            Result[] r = (Result[])this.currentScannerCallable.call(timeout);
            this.currentScannerCallable = null;
            return r;
        }
        if (this.currentScannerCallable == null) {
            LOG.warn("Another call received, but our ScannerCallable is already null. This shouldn't happen, but there's not much to do, so logging and returning null.");
            return null;
        }
        if (this.regionReplication <= 0) {
            RegionLocations rl = null;
            try {
                rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(true, 0, this.cConnection, this.tableName, this.currentScannerCallable.getRow());
            }
            catch (DoNotRetryIOException | RetriesExhaustedException e) {
                if (this.cConnection instanceof ConnectionImplementation) {
                    rl = ((ConnectionImplementation)this.cConnection).getCachedLocation(this.tableName, this.currentScannerCallable.getRow());
                    if (rl == null) {
                        throw e;
                    }
                }
                throw e;
            }
            this.regionReplication = rl.size();
        }
        ConnectionConfiguration connectionConfig = this.cConnection != null ? this.cConnection.getConnectionConfiguration() : new ConnectionConfiguration(this.conf);
        ResultBoundedCompletionService<Pair<Result[], ScannerCallable>> cs = new ResultBoundedCompletionService<Pair<Result[], ScannerCallable>>(RpcRetryingCallerFactory.instantiate(this.conf, connectionConfig, this.cConnection == null ? null : this.cConnection.getConnectionMetrics()), this.pool, this.regionReplication * 5);
        AtomicBoolean done = new AtomicBoolean(false);
        int rpcTimeoutForCall = this.getRpcTimeout();
        this.replicaSwitched.set(false);
        this.addCallsForCurrentReplica(cs, rpcTimeoutForCall);
        int startIndex = 0;
        try {
            ResultBoundedCompletionService.QueueingFuture<Pair<Result[], ScannerCallable>> f = cs.poll(this.timeBeforeReplicas, TimeUnit.MICROSECONDS);
            if (f != null) {
                Pair r = (Pair)f.get();
                if (r != null && r.getSecond() != null) {
                    this.updateCurrentlyServingReplica((ScannerCallable)r.getSecond(), (Result[])r.getFirst(), done, this.pool);
                }
                return r == null ? null : (Result[])r.getFirst();
            }
        }
        catch (ExecutionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scan with primary region returns " + e.getCause());
            }
            if (this.regionReplication == 1 || this.scan.getConsistency() == Consistency.STRONG || this.scan.getReplicaId() >= 0) {
                RpcRetryingCallerWithReadReplicas.throwEnrichedException(e, this.retries);
            }
            startIndex = 1;
        }
        catch (CancellationException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        int endIndex = this.regionReplication;
        if (this.scan.getConsistency() == Consistency.STRONG || this.scan.getReplicaId() >= 0) {
            endIndex = 1;
        } else {
            this.addCallsForOtherReplicas(cs, 0, this.regionReplication - 1, rpcTimeoutForCall);
        }
        try {
            ResultBoundedCompletionService.QueueingFuture<Pair<Result[], ScannerCallable>> f = cs.pollForFirstSuccessfullyCompletedTask(timeout, TimeUnit.MILLISECONDS, startIndex, endIndex);
            if (f == null) {
                throw new IOException("Failed to get result within timeout, timeout=" + timeout + "ms");
            }
            Pair r = (Pair)f.get();
            if (r != null && r.getSecond() != null) {
                this.updateCurrentlyServingReplica((ScannerCallable)r.getSecond(), (Result[])r.getFirst(), done, this.pool);
            }
            Result[] resultArray = r == null ? null : (Result[])r.getFirst();
            return resultArray;
        }
        catch (ExecutionException e) {
            RpcRetryingCallerWithReadReplicas.throwEnrichedException(e, this.retries);
        }
        catch (CancellationException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        finally {
            cs.cancelAll();
        }
        LOG.error("Imposible? Arrive at an unreachable line...");
        throw new IOException("Imposible? Arrive at an unreachable line...");
    }

    private void updateCurrentlyServingReplica(ScannerCallable scanner, Result[] result, AtomicBoolean done, ExecutorService pool) {
        if (done.compareAndSet(false, true)) {
            if (this.currentScannerCallable != scanner) {
                this.replicaSwitched.set(true);
            }
            this.currentScannerCallable = scanner;
            if (result != null && result.length != 0) {
                this.lastResult = result[result.length - 1];
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Setting current scanner as id=" + this.currentScannerCallable.scannerId + " associated with replica=" + this.currentScannerCallable.getHRegionInfo().getReplicaId());
            }
            this.outstandingCallables.remove(scanner);
            for (ScannerCallable s : this.outstandingCallables) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing scanner id=" + s.scannerId + ", replica=" + s.getHRegionInfo().getRegionId() + " because slow and replica=" + this.currentScannerCallable.getHRegionInfo().getReplicaId() + " succeeded");
                }
                s.setClose();
                final RetryingRPC r = new RetryingRPC(s);
                pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        r.call(ScannerCallableWithReplicas.this.scannerTimeout);
                        return null;
                    }
                });
            }
            this.outstandingCallables.clear();
        }
    }

    public boolean switchedToADifferentReplica() {
        return this.replicaSwitched.get();
    }

    public boolean isHeartbeatMessage() {
        return this.currentScannerCallable != null && this.currentScannerCallable.isHeartbeatMessage();
    }

    public Cursor getCursor() {
        return this.currentScannerCallable != null ? this.currentScannerCallable.getCursor() : null;
    }

    private void addCallsForCurrentReplica(ResultBoundedCompletionService<Pair<Result[], ScannerCallable>> cs, int rpcTimeout) {
        RetryingRPC retryingOnReplica = new RetryingRPC(this.currentScannerCallable);
        this.outstandingCallables.add(this.currentScannerCallable);
        cs.submit(retryingOnReplica, rpcTimeout, this.scannerTimeout, this.currentScannerCallable.id);
    }

    private int getRpcTimeout() {
        if (this.useScannerTimeoutForNextCalls) {
            return this.isNextCall() ? this.scannerTimeout : this.readRpcTimeout;
        }
        return this.readRpcTimeout;
    }

    private boolean isNextCall() {
        return this.currentScannerCallable != null && this.currentScannerCallable.scannerId != -1L && !this.currentScannerCallable.renew && !this.currentScannerCallable.closed;
    }

    private void addCallsForOtherReplicas(ResultBoundedCompletionService<Pair<Result[], ScannerCallable>> cs, int min, int max, int rpcTimeout) {
        for (int id = min; id <= max; ++id) {
            if (this.currentScannerCallable.id == id) continue;
            ScannerCallable s = this.currentScannerCallable.getScannerCallableForReplica(id);
            this.setStartRowForReplicaCallable(s);
            this.outstandingCallables.add(s);
            RetryingRPC retryingOnReplica = new RetryingRPC(s);
            cs.submit(retryingOnReplica, rpcTimeout, this.scannerTimeout, id);
        }
    }

    private void setStartRowForReplicaCallable(ScannerCallable callable) {
        if (this.lastResult == null || callable == null) {
            return;
        }
        callable.getScan().withStartRow(this.lastResult.getRow(), this.lastResult.mayHaveMoreCellsInRow());
    }

    boolean isAnyRPCcancelled() {
        return this.someRPCcancelled;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        this.currentScannerCallable.throwable(t, retrying);
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return this.currentScannerCallable.getExceptionMessageAdditionalDetail();
    }

    @Override
    public long sleep(long pause, int tries) {
        return this.currentScannerCallable.sleep(pause, tries);
    }

    public HRegionLocation getLocation() {
        return this.currentScannerCallable.getLocation();
    }

    class RetryingRPC
    implements RetryingCallable<Pair<Result[], ScannerCallable>>,
    Cancellable {
        final ScannerCallable callable;
        RpcRetryingCaller<Result[]> caller;
        private volatile boolean cancelled = false;

        RetryingRPC(ScannerCallable callable) {
            this.callable = callable;
            this.caller = ScannerCallableWithReplicas.this.caller;
            if (ScannerCallableWithReplicas.this.scan.getConsistency() == Consistency.TIMELINE) {
                ConnectionConfiguration connectionConfig = ScannerCallableWithReplicas.this.cConnection != null ? ScannerCallableWithReplicas.this.cConnection.getConnectionConfiguration() : new ConnectionConfiguration(ScannerCallableWithReplicas.this.conf);
                this.caller = RpcRetryingCallerFactory.instantiate(ScannerCallableWithReplicas.this.conf, connectionConfig, ScannerCallableWithReplicas.this.cConnection == null ? null : ScannerCallableWithReplicas.this.cConnection.getConnectionMetrics()).newCaller();
            }
        }

        @Override
        public Pair<Result[], ScannerCallable> call(int callTimeout) throws IOException {
            if (this.cancelled) {
                return null;
            }
            Result[] res = this.caller.callWithoutRetries(this.callable, callTimeout);
            return new Pair<Result[], ScannerCallable>(res, this.callable);
        }

        @Override
        public void prepare(boolean reload) throws IOException {
            if (this.cancelled) {
                return;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            this.callable.prepare(reload);
        }

        @Override
        public void throwable(Throwable t, boolean retrying) {
            this.callable.throwable(t, retrying);
        }

        @Override
        public String getExceptionMessageAdditionalDetail() {
            return this.callable.getExceptionMessageAdditionalDetail();
        }

        @Override
        public long sleep(long pause, int tries) {
            return this.callable.sleep(pause, tries);
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.caller.cancel();
            if (this.callable.getRpcController() != null) {
                this.callable.getRpcController().startCancel();
            }
            ScannerCallableWithReplicas.this.someRPCcancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

