/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.bulkdatagenerator;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;

public final class Utility {
    public static final String COLUMN_FAMILY = "cf";
    public static final int SPLIT_PREFIX_LENGTH = 6;
    public static final int MAX_SPLIT_COUNT = (int)Math.pow(10.0, 6.0);

    private Utility() {
    }

    public static void deleteTable(Admin admin, String tableName) throws IOException {
        admin.disableTable(TableName.valueOf((String)tableName));
        admin.deleteTable(TableName.valueOf((String)tableName));
    }

    public static void createTable(Admin admin, String tableName, int splitCount, Map<String, String> tableOptions) throws IOException {
        Preconditions.checkArgument((splitCount > 0 ? 1 : 0) != 0, (Object)"Split count must be greater than 0");
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName));
        tableOptions.forEach((arg_0, arg_1) -> ((TableDescriptorBuilder)tableDescriptorBuilder).setValue(arg_0, arg_1));
        TableDescriptor tableDescriptor = tableDescriptorBuilder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)COLUMN_FAMILY)).build();
        byte[][] splitKeys = new byte[splitCount][];
        for (int i = 0; i < splitCount; ++i) {
            splitKeys[i] = String.format("%06d", i + 1).getBytes();
        }
        admin.createTable(tableDescriptor, (byte[][])splitKeys);
    }

    public static enum TableColumnNames {
        ORG_ID("orgId".getBytes()),
        TOOL_EVENT_ID("toolEventId".getBytes()),
        EVENT_ID("eventId".getBytes()),
        VEHICLE_ID("vehicleId".getBytes()),
        SPEED("speed".getBytes()),
        LATITUDE("latitude".getBytes()),
        LONGITUDE("longitude".getBytes()),
        LOCATION("location".getBytes()),
        TIMESTAMP("timestamp".getBytes());

        private final byte[] columnName;

        private TableColumnNames(byte[] column) {
            this.columnName = column;
        }

        public byte[] getColumnName() {
            return this.columnName;
        }
    }
}

