/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.quotas.AverageIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.FixedIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimeBasedLimiter
implements QuotaLimiter {
    private RateLimiter reqsLimiter = null;
    private RateLimiter reqSizeLimiter = null;
    private RateLimiter writeReqsLimiter = null;
    private RateLimiter writeSizeLimiter = null;
    private RateLimiter readReqsLimiter = null;
    private RateLimiter readSizeLimiter = null;
    private RateLimiter reqCapacityUnitLimiter = null;
    private RateLimiter writeCapacityUnitLimiter = null;
    private RateLimiter readCapacityUnitLimiter = null;
    private RateLimiter atomicReqLimiter = null;
    private RateLimiter atomicReadSizeLimiter = null;
    private RateLimiter atomicWriteSizeLimiter = null;
    private RateLimiter reqHandlerUsageTimeLimiter = null;

    private TimeBasedLimiter(Configuration conf) {
        if (FixedIntervalRateLimiter.class.getName().equals(conf.getClass("hbase.quota.rate.limiter", AverageIntervalRateLimiter.class).getName())) {
            long refillInterval = conf.getLong("hbase.quota.rate.limiter.refill.interval.ms", 1000L);
            this.reqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.reqSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeReqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readReqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.reqCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.atomicReqLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.atomicReadSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.atomicWriteSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.reqHandlerUsageTimeLimiter = new FixedIntervalRateLimiter(refillInterval);
        } else {
            this.reqsLimiter = new AverageIntervalRateLimiter();
            this.reqSizeLimiter = new AverageIntervalRateLimiter();
            this.writeReqsLimiter = new AverageIntervalRateLimiter();
            this.writeSizeLimiter = new AverageIntervalRateLimiter();
            this.readReqsLimiter = new AverageIntervalRateLimiter();
            this.readSizeLimiter = new AverageIntervalRateLimiter();
            this.reqCapacityUnitLimiter = new AverageIntervalRateLimiter();
            this.writeCapacityUnitLimiter = new AverageIntervalRateLimiter();
            this.readCapacityUnitLimiter = new AverageIntervalRateLimiter();
            this.atomicReqLimiter = new AverageIntervalRateLimiter();
            this.atomicReadSizeLimiter = new AverageIntervalRateLimiter();
            this.atomicWriteSizeLimiter = new AverageIntervalRateLimiter();
            this.reqHandlerUsageTimeLimiter = new AverageIntervalRateLimiter();
        }
    }

    static QuotaLimiter fromThrottle(Configuration conf, QuotaProtos.Throttle throttle) {
        TimeBasedLimiter limiter = new TimeBasedLimiter(conf);
        boolean isBypass = true;
        if (throttle.hasReqNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqsLimiter, throttle.getReqNum());
            isBypass = false;
        }
        if (throttle.hasReqSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqSizeLimiter, throttle.getReqSize());
            isBypass = false;
        }
        if (throttle.hasWriteNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeReqsLimiter, throttle.getWriteNum());
            isBypass = false;
        }
        if (throttle.hasWriteSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeSizeLimiter, throttle.getWriteSize());
            isBypass = false;
        }
        if (throttle.hasReadNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readReqsLimiter, throttle.getReadNum());
            isBypass = false;
        }
        if (throttle.hasReadSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readSizeLimiter, throttle.getReadSize());
            isBypass = false;
        }
        if (throttle.hasReqCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqCapacityUnitLimiter, throttle.getReqCapacityUnit());
            isBypass = false;
        }
        if (throttle.hasWriteCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeCapacityUnitLimiter, throttle.getWriteCapacityUnit());
            isBypass = false;
        }
        if (throttle.hasReadCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readCapacityUnitLimiter, throttle.getReadCapacityUnit());
            isBypass = false;
        }
        if (throttle.hasAtomicReqNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.atomicReqLimiter, throttle.getAtomicReqNum());
            isBypass = false;
        }
        if (throttle.hasAtomicReadSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.atomicReadSizeLimiter, throttle.getAtomicReadSize());
            isBypass = false;
        }
        if (throttle.hasAtomicWriteSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.atomicWriteSizeLimiter, throttle.getAtomicWriteSize());
            isBypass = false;
        }
        if (throttle.hasReqHandlerUsageMs()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqHandlerUsageTimeLimiter, throttle.getReqHandlerUsageMs());
            isBypass = false;
        }
        return isBypass ? NoopQuotaLimiter.get() : limiter;
    }

    public void update(TimeBasedLimiter other) {
        this.reqsLimiter.update(other.reqsLimiter);
        this.reqSizeLimiter.update(other.reqSizeLimiter);
        this.writeReqsLimiter.update(other.writeReqsLimiter);
        this.writeSizeLimiter.update(other.writeSizeLimiter);
        this.readReqsLimiter.update(other.readReqsLimiter);
        this.readSizeLimiter.update(other.readSizeLimiter);
        this.reqCapacityUnitLimiter.update(other.reqCapacityUnitLimiter);
        this.writeCapacityUnitLimiter.update(other.writeCapacityUnitLimiter);
        this.readCapacityUnitLimiter.update(other.readCapacityUnitLimiter);
        this.atomicReqLimiter.update(other.atomicReqLimiter);
        this.atomicReadSizeLimiter.update(other.atomicReadSizeLimiter);
        this.atomicWriteSizeLimiter.update(other.atomicWriteSizeLimiter);
        this.reqHandlerUsageTimeLimiter.update(other.reqHandlerUsageTimeLimiter);
    }

    private static void setFromTimedQuota(RateLimiter limiter, QuotaProtos.TimedQuota timedQuota) {
        limiter.set(timedQuota.getSoftLimit(), ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit()));
    }

    @Override
    public void checkQuota(long writeReqs, long estimateWriteSize, long readReqs, long estimateReadSize, long estimateWriteCapacityUnit, long estimateReadCapacityUnit, boolean isAtomic, long estimatedReqHandlerUsageTimeMs) throws RpcThrottlingException {
        long waitInterval = this.reqsLimiter.getWaitIntervalMs(writeReqs + readReqs);
        if (waitInterval > 0L) {
            RpcThrottlingException.throwNumRequestsExceeded(waitInterval);
        }
        if ((waitInterval = this.reqSizeLimiter.getWaitIntervalMs(estimateWriteSize + estimateReadSize)) > 0L) {
            RpcThrottlingException.throwRequestSizeExceeded(waitInterval);
        }
        if ((waitInterval = this.reqCapacityUnitLimiter.getWaitIntervalMs(estimateWriteCapacityUnit + estimateReadCapacityUnit)) > 0L) {
            RpcThrottlingException.throwRequestCapacityUnitExceeded(waitInterval);
        }
        if (isAtomic && (waitInterval = this.atomicReqLimiter.getWaitIntervalMs(writeReqs + readReqs)) > 0L) {
            RpcThrottlingException.throwAtomicRequestNumberExceeded(waitInterval);
        }
        if (estimateWriteSize > 0L) {
            waitInterval = this.writeReqsLimiter.getWaitIntervalMs(writeReqs);
            if (waitInterval > 0L) {
                RpcThrottlingException.throwNumWriteRequestsExceeded(waitInterval);
            }
            if ((waitInterval = this.writeSizeLimiter.getWaitIntervalMs(estimateWriteSize)) > 0L) {
                RpcThrottlingException.throwWriteSizeExceeded(waitInterval);
            }
            if ((waitInterval = this.writeCapacityUnitLimiter.getWaitIntervalMs(estimateWriteCapacityUnit)) > 0L) {
                RpcThrottlingException.throwWriteCapacityUnitExceeded(waitInterval);
            }
            if (isAtomic && (waitInterval = this.atomicWriteSizeLimiter.getWaitIntervalMs(writeReqs)) > 0L) {
                RpcThrottlingException.throwAtomicWriteSizeExceeded(waitInterval);
            }
        }
        if (estimateReadSize > 0L) {
            waitInterval = this.readReqsLimiter.getWaitIntervalMs(readReqs);
            if (waitInterval > 0L) {
                RpcThrottlingException.throwNumReadRequestsExceeded(waitInterval);
            }
            if ((waitInterval = this.readSizeLimiter.getWaitIntervalMs(estimateReadSize)) > 0L) {
                RpcThrottlingException.throwReadSizeExceeded(waitInterval);
            }
            if ((waitInterval = this.readCapacityUnitLimiter.getWaitIntervalMs(estimateReadCapacityUnit)) > 0L) {
                RpcThrottlingException.throwReadCapacityUnitExceeded(waitInterval);
            }
            if (isAtomic && (waitInterval = this.atomicReadSizeLimiter.getWaitIntervalMs(writeReqs + readReqs)) > 0L) {
                RpcThrottlingException.throwAtomicReadSizeExceeded(waitInterval);
            }
        }
        if ((waitInterval = this.reqHandlerUsageTimeLimiter.getWaitIntervalMs(estimatedReqHandlerUsageTimeMs)) > 0L) {
            RpcThrottlingException.throwRequestHandlerUsageTimeExceeded(waitInterval);
        }
    }

    @Override
    public void grabQuota(long writeReqs, long writeSize, long readReqs, long readSize, long writeCapacityUnit, long readCapacityUnit, boolean isAtomic, long estimateHandlerThreadUsageMs) {
        assert (writeSize != 0L || readSize != 0L);
        this.reqsLimiter.consume(writeReqs + readReqs);
        this.reqSizeLimiter.consume(writeSize + readSize);
        if (writeSize > 0L) {
            this.writeReqsLimiter.consume(writeReqs);
            this.writeSizeLimiter.consume(writeSize);
        }
        if (readSize > 0L) {
            this.readReqsLimiter.consume(readReqs);
            this.readSizeLimiter.consume(readSize);
        }
        if (writeCapacityUnit > 0L) {
            this.reqCapacityUnitLimiter.consume(writeCapacityUnit);
            this.writeCapacityUnitLimiter.consume(writeCapacityUnit);
        }
        if (readCapacityUnit > 0L) {
            this.reqCapacityUnitLimiter.consume(readCapacityUnit);
            this.readCapacityUnitLimiter.consume(readCapacityUnit);
        }
        if (isAtomic) {
            this.atomicReqLimiter.consume(writeReqs + readReqs);
            if (readSize > 0L) {
                this.atomicReadSizeLimiter.consume(readSize);
            }
            if (writeSize > 0L) {
                this.atomicWriteSizeLimiter.consume(writeSize);
            }
        }
        this.reqHandlerUsageTimeLimiter.consume(estimateHandlerThreadUsageMs);
    }

    @Override
    public void consumeWrite(long size, long capacityUnit, boolean isAtomic) {
        this.reqSizeLimiter.consume(size);
        this.writeSizeLimiter.consume(size);
        this.reqCapacityUnitLimiter.consume(capacityUnit);
        this.writeCapacityUnitLimiter.consume(capacityUnit);
        if (isAtomic) {
            this.atomicWriteSizeLimiter.consume(size);
        }
    }

    @Override
    public void consumeRead(long size, long capacityUnit, boolean isAtomic) {
        this.reqSizeLimiter.consume(size);
        this.readSizeLimiter.consume(size);
        this.reqCapacityUnitLimiter.consume(capacityUnit);
        this.readCapacityUnitLimiter.consume(capacityUnit);
        if (isAtomic) {
            this.atomicReadSizeLimiter.consume(size);
        }
    }

    @Override
    public void consumeTime(long handlerMillisUsed) {
        this.reqHandlerUsageTimeLimiter.consume(handlerMillisUsed);
    }

    @Override
    public boolean isBypass() {
        return false;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeSizeLimiter.getAvailable();
    }

    @Override
    public long getRequestNumLimit() {
        long readAndWriteLimit = this.readReqsLimiter.getLimit() + this.writeReqsLimiter.getLimit();
        if (readAndWriteLimit < 0L) {
            readAndWriteLimit = Long.MAX_VALUE;
        }
        return Math.min(this.reqsLimiter.getLimit(), readAndWriteLimit);
    }

    @Override
    public long getReadNumLimit() {
        return this.readReqsLimiter.getLimit();
    }

    @Override
    public long getWriteNumLimit() {
        return this.writeReqsLimiter.getLimit();
    }

    @Override
    public long getReadAvailable() {
        return this.readSizeLimiter.getAvailable();
    }

    @Override
    public long getReadLimit() {
        return Math.min(this.readSizeLimiter.getLimit(), this.reqSizeLimiter.getLimit());
    }

    @Override
    public long getWriteLimit() {
        return Math.min(this.writeSizeLimiter.getLimit(), this.reqSizeLimiter.getLimit());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeBasedLimiter(");
        if (!this.reqsLimiter.isBypass()) {
            builder.append("reqs=" + this.reqsLimiter);
        }
        if (!this.reqSizeLimiter.isBypass()) {
            builder.append(" resSize=" + this.reqSizeLimiter);
        }
        if (!this.writeReqsLimiter.isBypass()) {
            builder.append(" writeReqs=" + this.writeReqsLimiter);
        }
        if (!this.writeSizeLimiter.isBypass()) {
            builder.append(" writeSize=" + this.writeSizeLimiter);
        }
        if (!this.readReqsLimiter.isBypass()) {
            builder.append(" readReqs=" + this.readReqsLimiter);
        }
        if (!this.readSizeLimiter.isBypass()) {
            builder.append(" readSize=" + this.readSizeLimiter);
        }
        if (!this.reqCapacityUnitLimiter.isBypass()) {
            builder.append(" reqCapacityUnit=" + this.reqCapacityUnitLimiter);
        }
        if (!this.writeCapacityUnitLimiter.isBypass()) {
            builder.append(" writeCapacityUnit=" + this.writeCapacityUnitLimiter);
        }
        if (!this.readCapacityUnitLimiter.isBypass()) {
            builder.append(" readCapacityUnit=" + this.readCapacityUnitLimiter);
        }
        if (!this.atomicReqLimiter.isBypass()) {
            builder.append(" atomicReqLimiter=" + this.atomicReqLimiter);
        }
        if (!this.atomicReadSizeLimiter.isBypass()) {
            builder.append(" atomicReadSizeLimiter=" + this.atomicReadSizeLimiter);
        }
        if (!this.atomicWriteSizeLimiter.isBypass()) {
            builder.append(" atomicWriteSizeLimiter=" + this.atomicWriteSizeLimiter);
        }
        if (!this.reqHandlerUsageTimeLimiter.isBypass()) {
            builder.append(" reqHandlerUsageTimeLimiter=" + this.reqHandlerUsageTimeLimiter);
        }
        builder.append(')');
        return builder.toString();
    }
}

