/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs.monitor;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StreamSlowMonitor
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(StreamSlowMonitor.class);
    private static final String WAL_SLOW_DETECT_MIN_COUNT_KEY = "hbase.regionserver.async.wal.min.slow.detect.count";
    private static final int DEFAULT_WAL_SLOW_DETECT_MIN_COUNT = 3;
    private static final String WAL_SLOW_DETECT_DATA_TTL_KEY = "hbase.regionserver.async.wal.slow.detect.data.ttl.ms";
    private static final long DEFAULT_WAL_SLOW_DETECT_DATA_TTL = 600000L;
    private static final String DATANODE_PACKET_FLUSH_CHECK_SPEED_MIN_DATA_LENGTH_KEY = "hbase.regionserver.async.wal.datanode.slow.check.speed.packet.data.length.min";
    private static final long DEFAULT_DATANODE_PACKET_FLUSH_CHECK_SPEED_MIN_DATA_LENGTH = 65536L;
    public static final String DATANODE_SLOW_PACKET_PROCESS_TIME_KEY = "hbase.regionserver.async.wal.datanode.slow.packet.process.time.millis";
    private static final long DEFAULT_DATANODE_SLOW_PACKET_PROCESS_TIME = 6000L;
    private static final String DATANODE_SLOW_PACKET_FLUSH_MIN_SPEED_KEY = "hbase.regionserver.async.wal.datanode.slow.packet.speed.min.kbs";
    private static final double DEFAULT_DATANODE_SLOW_PACKET_FLUSH_MIN_SPEED = 20.0;
    private final String name;
    private final LoadingCache<DatanodeInfo, Deque<PacketAckData>> datanodeSlowDataQueue;
    private final ExcludeDatanodeManager excludeDatanodeManager;
    private int minSlowDetectCount;
    private long slowDataTtl;
    private long slowPacketAckMs;
    private double minPacketFlushSpeedKBs;
    private long minLengthForSpeedCheck;

    public StreamSlowMonitor(Configuration conf, String name, ExcludeDatanodeManager excludeDatanodeManager) {
        this.setConf(conf);
        this.name = name;
        this.excludeDatanodeManager = excludeDatanodeManager;
        this.datanodeSlowDataQueue = CacheBuilder.newBuilder().maximumSize(conf.getInt("hbase.regionserver.async.wal.max.exclude.datanode.count", 3)).expireAfterWrite(conf.getLong("hbase.regionserver.async.wal.exclude.datanode.info.ttl.hour", 6L), TimeUnit.HOURS).build(new CacheLoader<DatanodeInfo, Deque<PacketAckData>>(){

            @Override
            public Deque<PacketAckData> load(DatanodeInfo key) throws Exception {
                return new ConcurrentLinkedDeque<PacketAckData>();
            }
        });
        LOG.info("New stream slow monitor {}", (Object)this.name);
    }

    public static StreamSlowMonitor create(Configuration conf, String name) {
        return new StreamSlowMonitor(conf, name, new ExcludeDatanodeManager(conf));
    }

    public void checkProcessTimeAndSpeed(DatanodeInfo datanodeInfo, long packetDataLen, long processTimeMs, long lastAckTimestamp, int unfinished) {
        boolean slow;
        long current = EnvironmentEdgeManager.currentTime();
        boolean bl = slow = packetDataLen <= this.minLengthForSpeedCheck && processTimeMs > this.slowPacketAckMs || packetDataLen > this.minLengthForSpeedCheck && (double)packetDataLen / (double)processTimeMs < this.minPacketFlushSpeedKBs;
        if (slow && (lastAckTimestamp > 0L && current - lastAckTimestamp > this.slowPacketAckMs / 2L || lastAckTimestamp <= 0L && unfinished == 0)) {
            LOG.info("Slow datanode: {}, data length={}, duration={}ms, unfinishedReplicas={}, lastAckTimestamp={}, monitor name: {}", new Object[]{datanodeInfo, packetDataLen, processTimeMs, unfinished, lastAckTimestamp, this.name});
            if (this.addSlowAckData(datanodeInfo, packetDataLen, processTimeMs)) {
                this.excludeDatanodeManager.tryAddExcludeDN(datanodeInfo, ExcludeDatanodeManager.ExcludeCause.SLOW_PACKET_ACK.getCause());
            }
        }
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.setConf(conf);
    }

    private boolean addSlowAckData(DatanodeInfo datanodeInfo, long dataLength, long processTime) {
        Deque<PacketAckData> slowDNQueue = this.datanodeSlowDataQueue.getUnchecked(datanodeInfo);
        long current = EnvironmentEdgeManager.currentTime();
        while (!(slowDNQueue.isEmpty() || current - slowDNQueue.getFirst().getTimestamp() <= this.slowDataTtl && slowDNQueue.size() < this.minSlowDetectCount)) {
            slowDNQueue.removeFirst();
        }
        slowDNQueue.addLast(new PacketAckData(dataLength, processTime));
        return slowDNQueue.size() >= this.minSlowDetectCount;
    }

    private void setConf(Configuration conf) {
        this.minSlowDetectCount = conf.getInt(WAL_SLOW_DETECT_MIN_COUNT_KEY, 3);
        this.slowDataTtl = conf.getLong(WAL_SLOW_DETECT_DATA_TTL_KEY, 600000L);
        this.slowPacketAckMs = conf.getLong(DATANODE_SLOW_PACKET_PROCESS_TIME_KEY, 6000L);
        this.minLengthForSpeedCheck = conf.getLong(DATANODE_PACKET_FLUSH_CHECK_SPEED_MIN_DATA_LENGTH_KEY, 65536L);
        this.minPacketFlushSpeedKBs = conf.getDouble(DATANODE_SLOW_PACKET_FLUSH_MIN_SPEED_KEY, 20.0);
    }

    public ExcludeDatanodeManager getExcludeDatanodeManager() {
        return this.excludeDatanodeManager;
    }

    private static class PacketAckData {
        private final long dataLength;
        private final long processTime;
        private final long timestamp;

        public PacketAckData(long dataLength, long processTime) {
            this.dataLength = dataLength;
            this.processTime = processTime;
            this.timestamp = EnvironmentEdgeManager.currentTime();
        }

        public long getDataLength() {
            return this.dataLength;
        }

        public long getProcessTime() {
            return this.processTime;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

