/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.webapp.BadRequestException;

public class DeSelectFields {
    private static final Log LOG = LogFactory.getLog((String)DeSelectFields.class.getName());
    private final Set<DeSelectType> types = new HashSet<DeSelectType>();

    public void initFields(Set<String> unselectedFields) {
        if (unselectedFields == null) {
            return;
        }
        for (String field : unselectedFields) {
            String[] literalsArray;
            if (field.trim().isEmpty()) continue;
            for (String literals : literalsArray = field.split(",")) {
                if (literals == null || literals.trim().isEmpty()) continue;
                DeSelectType type = DeSelectType.obtainType(literals);
                if (type == null) {
                    LOG.warn((Object)("Invalid deSelects string " + literals.trim()));
                    DeSelectType[] typeArray = DeSelectType.values();
                    String allSuppportLiterals = Arrays.toString((Object[])typeArray);
                    throw new BadRequestException("Invalid deSelects string " + literals.trim() + " specified. It should be one of " + allSuppportLiterals);
                }
                this.types.add(type);
            }
        }
    }

    public boolean contains(DeSelectType type) {
        return this.types.contains((Object)type);
    }

    public static enum DeSelectType {
        RESOURCE_REQUESTS("resourceRequests"),
        TIMEOUTS("timeouts"),
        APP_NODE_LABEL_EXPRESSION("appNodeLabelExpression"),
        AM_NODE_LABEL_EXPRESSION("amNodeLabelExpression"),
        RESOURCE_INFO("resourceInfo");

        private final String literals;

        private DeSelectType(String literals) {
            this.literals = literals;
        }

        public String toString() {
            return this.literals;
        }

        public static DeSelectType obtainType(String literals) {
            for (DeSelectType type : DeSelectType.values()) {
                if (!type.literals.equalsIgnoreCase(literals)) continue;
                return type;
            }
            return null;
        }
    }
}

