/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.GracefulShutdownRequest;
import org.apache.directory.api.ldap.extras.extended.GracefulShutdownResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdown;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownDecoder;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownRequestDecorator
extends ExtendedRequestDecorator<GracefulShutdownRequest, GracefulShutdownResponse>
implements GracefulShutdownRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownRequestDecorator.class);

    public GracefulShutdownRequestDecorator(LdapApiService codec, GracefulShutdownRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
    }

    public void setRequestValue(byte[] requestValue) {
        GracefulShutdownDecoder decoder = new GracefulShutdownDecoder();
        try {
            GracefulShutdown gs = (GracefulShutdown)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
            this.setTimeOffline(gs.getTimeOffline());
            this.setDelay(gs.getDelay());
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                GracefulShutdown gs = new GracefulShutdown();
                gs.setDelay(((GracefulShutdownRequest)this.getDecorated()).getDelay());
                gs.setTimeOffline(((GracefulShutdownRequest)this.getDecorated()).getTimeOffline());
                this.requestValue = gs.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04164, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public int getDelay() {
        return ((GracefulShutdownRequest)this.getDecorated()).getDelay();
    }

    public void setDelay(int delay) {
        ((GracefulShutdownRequest)this.getDecorated()).setDelay(delay);
    }

    public int getTimeOffline() {
        return ((GracefulShutdownRequest)this.getDecorated()).getTimeOffline();
    }

    public void setTimeOffline(int timeOffline) {
        ((GracefulShutdownRequest)this.getDecorated()).setTimeOffline(timeOffline);
    }
}

