/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConnectionCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public abstract class HBaseServiceHandler {
    public static final String CLEANUP_INTERVAL = "hbase.thrift.connection.cleanup-interval";
    public static final String MAX_IDLETIME = "hbase.thrift.connection.max-idletime";
    protected Configuration conf;
    protected final ConnectionCache connectionCache;
    protected ThriftMetrics metrics = null;

    public HBaseServiceHandler(Configuration c, UserProvider userProvider) throws IOException {
        this.conf = c;
        int cleanInterval = this.conf.getInt(CLEANUP_INTERVAL, 10000);
        int maxIdleTime = this.conf.getInt(MAX_IDLETIME, 600000);
        this.connectionCache = new ConnectionCache(this.conf, userProvider, cleanInterval, maxIdleTime);
    }

    public void initMetrics(ThriftMetrics metrics) {
        this.metrics = metrics;
    }

    public void setEffectiveUser(String effectiveUser) {
        this.connectionCache.setEffectiveUser(effectiveUser);
    }

    protected Admin getAdmin() throws IOException {
        return this.connectionCache.getAdmin();
    }

    protected Table getTable(byte[] tableName) throws IOException {
        String table = Bytes.toString((byte[])tableName);
        return this.connectionCache.getTable(table);
    }

    protected Table getTable(ByteBuffer tableName) throws IOException {
        return this.getTable(Bytes.getBytes((ByteBuffer)tableName));
    }
}

