/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.LocalityBasedCandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class LocalityBasedCostFunction
extends CostFunction {
    private final BalancerClusterState.LocalityType type;
    private double bestLocality;
    private double locality;

    LocalityBasedCostFunction(Configuration conf, BalancerClusterState.LocalityType type, String localityCostKey, float defaultLocalityCost) {
        this.type = type;
        this.setMultiplier(conf.getFloat(localityCostKey, defaultLocalityCost));
        this.locality = 0.0;
        this.bestLocality = 0.0;
    }

    abstract int regionIndexToEntityIndex(int var1);

    @Override
    void prepare(BalancerClusterState cluster) {
        super.prepare(cluster);
        this.locality = 0.0;
        this.bestLocality = 0.0;
        for (int region = 0; region < cluster.numRegions; ++region) {
            this.locality += this.getWeightedLocality(region, this.regionIndexToEntityIndex(region));
            this.bestLocality += this.getWeightedLocality(region, this.getMostLocalEntityForRegion(region));
        }
        this.locality = this.bestLocality == 0.0 ? 1.0 : this.locality / this.bestLocality;
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        int oldEntity = this.type == BalancerClusterState.LocalityType.SERVER ? oldServer : this.cluster.serverIndexToRackIndex[oldServer];
        int newEntity = this.type == BalancerClusterState.LocalityType.SERVER ? newServer : this.cluster.serverIndexToRackIndex[newServer];
        double localityDelta = this.getWeightedLocality(region, newEntity) - this.getWeightedLocality(region, oldEntity);
        double normalizedDelta = this.bestLocality == 0.0 ? 0.0 : localityDelta / this.bestLocality;
        this.locality += normalizedDelta;
    }

    @Override
    protected final double cost() {
        return 1.0 - this.locality;
    }

    private int getMostLocalEntityForRegion(int region) {
        return this.cluster.getOrComputeRegionsToMostLocalEntities(this.type)[region];
    }

    private double getWeightedLocality(int region, int entity) {
        return this.cluster.getOrComputeWeightedLocality(region, entity, this.type);
    }

    @Override
    public final void updateWeight(Map<Class<? extends CandidateGenerator>, Double> weights) {
        weights.merge(LocalityBasedCandidateGenerator.class, this.cost(), Double::sum);
    }
}

