/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.event;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.event.Evaluator;
import org.apache.directory.server.i18n.I18n;

public class ScopeEvaluator
implements Evaluator {
    @Override
    public boolean evaluate(ExprNode node, Dn dn, Entry record) throws LdapException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case OBJECT: {
                return dn.equals((Object)snode.getBaseDn());
            }
            case ONELEVEL: {
                if (dn.isDescendantOf(snode.getBaseDn())) {
                    return snode.getBaseDn().size() + 1 == dn.size();
                }
            }
            case SUBTREE: {
                return dn.isDescendantOf(snode.getBaseDn());
            }
        }
        throw new LdapInvalidSearchFilterException(I18n.err((I18n)I18n.ERR_247, (Object[])new Object[0]));
    }
}

