/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestColumnSeeking {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnSeeking.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final Logger LOG = LoggerFactory.getLogger(TestColumnSeeking.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateVersions() throws IOException {
        String family = "Family";
        byte[] familyBytes = Bytes.toBytes((String)"Family");
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        HColumnDescriptor hcd = new HColumnDescriptor(familyBytes).setMaxVersions(1000);
        hcd.setMaxVersions(3);
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(table, null, null, false);
        HRegion region = TEST_UTIL.createLocalHRegion((RegionInfo)info, (TableDescriptor)htd);
        try {
            List<String> rows = this.generateRandomWords(10, "row");
            List<String> allColumns = this.generateRandomWords(10, "column");
            List<String> values = this.generateRandomWords(100, "value");
            long maxTimestamp = 2L;
            double selectPercent = 0.5;
            int numberOfTests = 5;
            double flushPercentage = 0.2;
            double minorPercentage = 0.2;
            double majorPercentage = 0.2;
            double putPercentage = 0.2;
            HashMap<String, KeyValue> allKVMap = new HashMap<String, KeyValue>();
            HashMap[] kvMaps = new HashMap[numberOfTests];
            ArrayList[] columnLists = new ArrayList[numberOfTests];
            for (int i = 0; i < numberOfTests; ++i) {
                kvMaps[i] = new HashMap();
                columnLists[i] = new ArrayList();
                for (String string : allColumns) {
                    if (!(Math.random() < selectPercent)) continue;
                    columnLists[i].add(string);
                }
            }
            for (String value : values) {
                for (String string : rows) {
                    Put p = new Put(Bytes.toBytes((String)string));
                    p.setDurability(Durability.SKIP_WAL);
                    for (String column : allColumns) {
                        for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                            KeyValue kv = KeyValueTestUtil.create((String)string, (String)family, (String)column, (long)timestamp, (String)value);
                            if (!(Math.random() < putPercentage)) continue;
                            p.add((Cell)kv);
                            allKVMap.put(kv.getKeyString(), kv);
                            for (int i = 0; i < numberOfTests; ++i) {
                                if (!columnLists[i].contains(column)) continue;
                                kvMaps[i].put(kv.getKeyString(), kv);
                            }
                        }
                    }
                    region.put(p);
                    if (Math.random() < flushPercentage) {
                        LOG.info("Flushing... ");
                        region.flush(true);
                    }
                    if (Math.random() < minorPercentage) {
                        LOG.info("Minor compacting... ");
                        region.compact(false);
                    }
                    if (!(Math.random() < majorPercentage)) continue;
                    LOG.info("Major compacting... ");
                    region.compact(true);
                }
            }
            for (int i = 0; i < numberOfTests + 1; ++i) {
                Collection kvSet;
                Scan scan = new Scan();
                scan.setMaxVersions();
                if (i < numberOfTests) {
                    if (columnLists[i].isEmpty()) continue;
                    kvSet = kvMaps[i].values();
                    for (String column : columnLists[i]) {
                        scan.addColumn(familyBytes, Bytes.toBytes((String)column));
                    }
                    LOG.info("ExplicitColumns scanner");
                    LOG.info("Columns: " + columnLists[i].size() + "  Keys: " + kvSet.size());
                } else {
                    kvSet = allKVMap.values();
                    LOG.info("Wildcard scanner");
                    LOG.info("Columns: " + allColumns.size() + "  Keys: " + kvSet.size());
                }
                RegionScannerImpl regionScannerImpl = region.getScanner(scan);
                ArrayList results = new ArrayList();
                while (regionScannerImpl.next(results)) {
                }
                Assert.assertEquals((long)kvSet.size(), (long)results.size());
                Assert.assertTrue((boolean)KeyValueTestUtil.containsIgnoreMvccVersion(results, kvSet));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testReseeking() throws IOException {
        String family = "Family";
        byte[] familyBytes = Bytes.toBytes((String)"Family");
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(table);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMaxVersions(3);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(table, null, null, false);
        HRegion region = TEST_UTIL.createLocalHRegion((RegionInfo)info, (TableDescriptor)htd);
        List<String> rows = this.generateRandomWords(10, "row");
        List<String> allColumns = this.generateRandomWords(100, "column");
        long maxTimestamp = 2L;
        double selectPercent = 0.5;
        int numberOfTests = 5;
        double flushPercentage = 0.2;
        double minorPercentage = 0.2;
        double majorPercentage = 0.2;
        double putPercentage = 0.2;
        HashMap<String, KeyValue> allKVMap = new HashMap<String, KeyValue>();
        HashMap[] kvMaps = new HashMap[numberOfTests];
        ArrayList[] columnLists = new ArrayList[numberOfTests];
        String valueString = "Value";
        for (int i = 0; i < numberOfTests; ++i) {
            kvMaps[i] = new HashMap();
            columnLists[i] = new ArrayList();
            for (String column : allColumns) {
                if (!(Math.random() < selectPercent)) continue;
                columnLists[i].add(column);
            }
        }
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : allColumns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                    if (!(Math.random() < putPercentage)) continue;
                    p.add((Cell)kv);
                    allKVMap.put(kv.getKeyString(), kv);
                    for (int i = 0; i < numberOfTests; ++i) {
                        if (!columnLists[i].contains(column)) continue;
                        kvMaps[i].put(kv.getKeyString(), kv);
                    }
                }
            }
            region.put(p);
            if (Math.random() < flushPercentage) {
                LOG.info("Flushing... ");
                region.flush(true);
            }
            if (Math.random() < minorPercentage) {
                LOG.info("Minor compacting... ");
                region.compact(false);
            }
            if (!(Math.random() < majorPercentage)) continue;
            LOG.info("Major compacting... ");
            region.compact(true);
        }
        for (int i = 0; i < numberOfTests + 1; ++i) {
            Collection kvSet;
            Scan scan = new Scan();
            scan.setMaxVersions();
            if (i < numberOfTests) {
                if (columnLists[i].isEmpty()) continue;
                kvSet = kvMaps[i].values();
                for (String column : columnLists[i]) {
                    scan.addColumn(familyBytes, Bytes.toBytes((String)column));
                }
                LOG.info("ExplicitColumns scanner");
                LOG.info("Columns: " + columnLists[i].size() + "  Keys: " + kvSet.size());
            } else {
                kvSet = allKVMap.values();
                LOG.info("Wildcard scanner");
                LOG.info("Columns: " + allColumns.size() + "  Keys: " + kvSet.size());
            }
            RegionScannerImpl scanner = region.getScanner(scan);
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)kvSet.size(), (long)results.size());
            Assert.assertTrue((boolean)KeyValueTestUtil.containsIgnoreMvccVersion(results, kvSet));
        }
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 5.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

