/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.OldWALsDirSizeChore;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestOldWALsDirSizeChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOldWALsDirSizeChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestOldWALsDirSizeChore.class);
    private MockMasterServices master;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();

    @Before
    public void setUp() throws Exception {
        this.master = new MockMasterServices(HTU.getConfiguration());
        this.master.start(10, null);
    }

    @After
    public void tearDown() throws Exception {
        this.master.stop("tearDown");
    }

    @Test
    public void testOldWALsDirSizeChore() throws IOException {
        long currentOldWALsDirSize = this.master.getMasterWalManager().getOldWALsDirSize();
        Assert.assertEquals((String)"Initial OldWALs directory size should be zero before running the chore", (long)0L, (long)currentOldWALsDirSize);
        int dummyFileSize = 0x3200000;
        byte[] dummyData = new byte[dummyFileSize];
        Path dummyFileInOldWALsDir = new Path(this.master.getMasterWalManager().getOldLogDir(), "dummy.txt");
        try (FSDataOutputStream outputStream = this.master.getMasterWalManager().getFileSystem().create(dummyFileInOldWALsDir);){
            outputStream.write(dummyData);
        }
        OldWALsDirSizeChore oldWALsDirSizeChore = new OldWALsDirSizeChore((MasterServices)this.master);
        oldWALsDirSizeChore.chore();
        Assert.assertEquals((String)"OldWALs directory size after chore should be as expected", (long)dummyFileSize, (long)this.master.getMasterWalManager().getOldWALsDirSize());
    }
}

