/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.RpcConnectionRegistry;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.trace.OpenTelemetryClassRule;
import org.apache.hadoop.hbase.trace.OpenTelemetryTestRule;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Enclosed.class)
public class TestAsyncMetaRegionLocator {
    private static final Logger logger = LoggerFactory.getLogger(TestAsyncMetaRegionLocator.class);

    @Category(value={MediumTests.class, ClientTests.class})
    public static class TestRpcConnectionRegistry
    extends AbstractBase {
        @ClassRule
        public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcConnectionRegistry.class);

        @Override
        protected Class<? extends ConnectionRegistry> getConnectionRegistryClass() {
            return RpcConnectionRegistry.class;
        }

        @Override
        @Test
        public void test() throws Exception {
            super.test();
            SpanData registry_getMetaRegionLocationsSpan = this.spans.stream().filter(arg_0 -> ((Matcher)this.registryGetMetaRegionLocationsMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
            Matcher clientGetMetaRegionLocationsMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.endsWith((String)"ClientMetaService/GetMetaRegionLocations")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)registry_getMetaRegionLocationsSpan), (Matcher)SpanDataMatchers.hasKind((SpanKind)SpanKind.CLIENT), (Matcher)SpanDataMatchers.hasEnded());
            MatcherAssert.assertThat((Object)this.spans, (Matcher)Matchers.hasItem((Matcher)clientGetMetaRegionLocationsMatcher));
        }
    }

    @Category(value={MediumTests.class, ClientTests.class})
    public static class TestZKConnectionRegistry
    extends AbstractBase {
        @ClassRule
        public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKConnectionRegistry.class);

        @Override
        protected Class<? extends ConnectionRegistry> getConnectionRegistryClass() {
            return ZKConnectionRegistry.class;
        }
    }

    public static abstract class AbstractBase {
        private final OpenTelemetryClassRule otelClassRule = OpenTelemetryClassRule.create();
        private final MiniClusterRule miniClusterRule;
        private final Setup setup;
        protected Matcher<SpanData> parentSpanMatcher;
        protected List<SpanData> spans;
        protected Matcher<SpanData> registryGetMetaRegionLocationsMatcher;
        @Rule
        public final TestRule classRule;
        @Rule
        public final OpenTelemetryTestRule otelTestRule = new OpenTelemetryTestRule(this.otelClassRule);
        @Rule
        public TestName testName = new TestName();

        public AbstractBase() {
            this.miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(StartMiniClusterOption.builder().numWorkers(3).build()).setConfiguration(() -> {
                Configuration conf = HBaseConfiguration.create();
                conf.setClass("hbase.client.registry.impl", this.getConnectionRegistryClass(), ConnectionRegistry.class);
                return conf;
            }).build();
            ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(this.miniClusterRule::createAsyncConnection);
            this.setup = new Setup(connectionRule, this.miniClusterRule);
            this.classRule = RuleChain.outerRule((TestRule)this.otelClassRule).around((TestRule)this.miniClusterRule).around((TestRule)connectionRule).around((TestRule)this.setup);
        }

        protected abstract Class<? extends ConnectionRegistry> getConnectionRegistryClass();

        @Test
        public void test() throws Exception {
            final AsyncMetaRegionLocator locator = this.setup.getLocator();
            HBaseTestingUtility testUtil = this.setup.getTestingUtility();
            TraceUtil.trace(() -> {
                try {
                    RegionReplicaTestHelper.testLocator(this.miniClusterRule.getTestingUtility(), TableName.META_TABLE_NAME, new RegionReplicaTestHelper.Locator(){

                        @Override
                        public void updateCachedLocationOnError(HRegionLocation loc, Throwable error) {
                            locator.updateCachedLocationOnError(loc, error);
                        }

                        @Override
                        public RegionLocations getRegionLocations(TableName tableName, int replicaId, boolean reload) throws Exception {
                            return (RegionLocations)locator.getRegionLocations(replicaId, reload).get();
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, (String)this.testName.getMethodName());
            Configuration conf = testUtil.getConfiguration();
            this.parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded());
            Waiter.waitFor((Configuration)conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate(this.otelClassRule::getSpans, Matchers.hasItem(this.parentSpanMatcher)));
            this.spans = this.otelClassRule.getSpans();
            if (logger.isDebugEnabled()) {
                StringTraceRenderer renderer = new StringTraceRenderer(this.spans);
                renderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
            }
            MatcherAssert.assertThat(this.spans, (Matcher)Matchers.hasItem(this.parentSpanMatcher));
            SpanData parentSpan = this.spans.stream().filter(arg_0 -> this.parentSpanMatcher.matches(arg_0)).findAny().orElseThrow(AssertionError::new);
            this.registryGetMetaRegionLocationsMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.endsWith((String)"ConnectionRegistry.getMetaRegionLocations")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)parentSpan), (Matcher)SpanDataMatchers.hasKind((SpanKind)SpanKind.INTERNAL), (Matcher)SpanDataMatchers.hasEnded());
            MatcherAssert.assertThat(this.spans, (Matcher)Matchers.hasItem(this.registryGetMetaRegionLocationsMatcher));
        }
    }

    private static final class Setup
    extends ExternalResource {
        private final MiniClusterRule miniClusterRule;
        private final ConnectionRule connectionRule;
        private boolean initialized = false;
        private HBaseTestingUtility testUtil;
        private AsyncMetaRegionLocator locator;
        private ConnectionRegistry registry;

        public Setup(ConnectionRule connectionRule, MiniClusterRule miniClusterRule) {
            this.connectionRule = connectionRule;
            this.miniClusterRule = miniClusterRule;
        }

        public HBaseTestingUtility getTestingUtility() {
            this.assertInitialized();
            return this.testUtil;
        }

        public AsyncMetaRegionLocator getLocator() {
            this.assertInitialized();
            return this.locator;
        }

        private void assertInitialized() {
            if (!this.initialized) {
                throw new IllegalStateException("before method has not been called.");
            }
        }

        protected void before() throws Throwable {
            AsyncAdmin admin = this.connectionRule.getAsyncConnection().getAdmin();
            this.testUtil = this.miniClusterRule.getTestingUtility();
            HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 3);
            this.testUtil.waitUntilNoRegionsInTransition();
            this.registry = ConnectionRegistryFactory.getRegistry((Configuration)this.testUtil.getConfiguration(), (User)User.getCurrent());
            RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(this.testUtil, this.registry);
            admin.balancerSwitch(false).get();
            this.locator = new AsyncMetaRegionLocator(this.registry);
            this.initialized = true;
        }

        protected void after() {
            this.registry.close();
        }
    }
}

