/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinationManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogRollMasterProcedureManager
extends MasterProcedureManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogRollMasterProcedureManager.class);
    public static final String ROLLLOG_PROCEDURE_SIGNATURE = "rolllog-proc";
    public static final String ROLLLOG_PROCEDURE_NAME = "rolllog";
    public static final String BACKUP_WAKE_MILLIS_KEY = "hbase.backup.logroll.wake.millis";
    public static final String BACKUP_TIMEOUT_MILLIS_KEY = "hbase.backup.logroll.timeout.millis";
    public static final String BACKUP_POOL_THREAD_NUMBER_KEY = "hbase.backup.logroll.pool.thread.number";
    public static final int BACKUP_WAKE_MILLIS_DEFAULT = 500;
    public static final int BACKUP_TIMEOUT_MILLIS_DEFAULT = 180000;
    public static final int BACKUP_POOL_THREAD_NUMBER_DEFAULT = 8;
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean done;

    public void stop(String why) {
        LOG.info("stop: " + why);
    }

    public boolean isStopped() {
        return false;
    }

    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws IOException, UnsupportedOperationException {
        this.master = master;
        this.done = false;
        String name = master.getServerName().toString();
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(BACKUP_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = conf.getLong(BACKUP_TIMEOUT_MILLIS_KEY, 180000L);
        int opThreads = conf.getInt(BACKUP_POOL_THREAD_NUMBER_KEY, 8);
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool((String)name, (int)opThreads);
        ZKProcedureCoordinationManager coordManager = new ZKProcedureCoordinationManager((Server)master);
        ProcedureCoordinatorRpcs comms = coordManager.getProcedureCoordinatorRpcs(this.getProcedureSignature(), name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
    }

    public String getProcedureSignature() {
        return ROLLLOG_PROCEDURE_SIGNATURE;
    }

    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        Procedure proc;
        if (!this.isBackupEnabled()) {
            LOG.warn("Backup is not enabled. Check your hbase.backup.enable setting");
            return;
        }
        this.done = false;
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getInstance());
        List serverNames = this.master.getServerManager().getOnlineServersList();
        ArrayList<String> servers = new ArrayList<String>();
        for (ServerName sn : serverNames) {
            servers.add(sn.toString());
        }
        List conf = desc.getConfigurationList();
        byte[] data = new byte[]{};
        if (conf.size() > 0) {
            data = Bytes.toBytes((String)((HBaseProtos.NameStringPair)conf.get(0)).getValue());
        }
        if ((proc = this.coordinator.startProcedure(monitor, desc.getInstance(), data, servers)) == null) {
            String msg = "Failed to submit distributed procedure for '" + desc.getInstance() + "'";
            LOG.error(msg);
            throw new IOException(msg);
        }
        try {
            proc.waitForCompleted();
            LOG.info("Done waiting - exec procedure for " + desc.getInstance());
            LOG.info("Distributed roll log procedure is successful!");
            this.done = true;
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for roll log procdure to finish", (Throwable)e);
            monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            ForeignException ee = new ForeignException("Exception while waiting for roll log procdure to finish", (Throwable)e);
            monitor.receive(ee);
        }
        monitor.rethrowException();
    }

    public void checkPermissions(HBaseProtos.ProcedureDescription desc, AccessChecker accessChecker, User user) throws IOException {
    }

    private boolean isBackupEnabled() {
        return BackupManager.isBackupEnabled(this.master.getConfiguration());
    }

    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) {
        return this.done;
    }
}

