/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AggregateImplementation<T, S, P extends Message, Q extends Message, R extends Message>
extends AggregateProtos.AggregateService
implements RegionCoprocessor {
    protected static final Logger log = LoggerFactory.getLogger(AggregateImplementation.class);
    private RegionCoprocessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMax(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                RegionScanner scanner = null;
                response = null;
                partialResultContext = null;
                Object max = null;
                boolean hasMoreRows = true;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            max = max == null || temp != null && ci.compare(temp, max) > 0 ? temp : max;
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                        break;
                    }
                    response = this.singlePartResponse(request, hasMoreRows, partialResultContext, max, arg_0 -> ci.getProtoForCellType(arg_0));
                    if (log.isDebugEnabled()) {
                        log.debug("Maximum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), max, hasMoreRows, RpcServer.getRequestUser()});
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMin(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = null;
                Object min = null;
                boolean hasMoreRows = true;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            min = min == null || temp != null && ci.compare(temp, min) < 0 ? temp : min;
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                        break;
                    }
                    response = this.singlePartResponse(request, hasMoreRows, partialResultContext, min, arg_0 -> ci.getProtoForCellType(arg_0));
                    if (log.isDebugEnabled()) {
                        log.debug("Minimum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), min, hasMoreRows, RpcServer.getRequestUser()});
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = null;
                long sum = 0L;
                boolean hasMoreRows = true;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            if (temp == null) continue;
                            sumVal = ci.add(sumVal, ci.castToReturnType(temp));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                        break;
                    }
                    response = this.singlePartResponse(request, hasMoreRows, partialResultContext, sumVal, arg_0 -> ci.getProtoForPromotedType(arg_0));
                    if (log.isDebugEnabled()) {
                        log.debug("Sum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), sum, hasMoreRows, RpcServer.getRequestUser()});
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRowNum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        PartialResultContext partialResultContext;
        AggregateProtos.AggregateResponse response;
        block10: {
            response = null;
            long counter = 0L;
            ArrayList<Cell> results = new ArrayList<Cell>();
            RegionScanner scanner = null;
            partialResultContext = null;
            boolean hasMoreRows = true;
            try {
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                partialResultContext = this.newPartialResultContext(scan);
                byte[][] colFamilies = scan.getFamilies();
                byte[] colFamily = colFamilies != null ? colFamilies[0] : null;
                NavigableSet qualifiers = colFamilies != null ? (NavigableSet)scan.getFamilyMap().get(colFamily) : null;
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                if (scan.getFilter() == null && qualifier == null) {
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                }
                scanner = this.env.getRegion().getScanner(scan);
                while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                    hasMoreRows = scanner.next(results);
                    if (!results.isEmpty()) {
                        ++counter;
                    }
                    this.postScanPartialResultUpdate(results, partialResultContext);
                    results.clear();
                    if (hasMoreRows) continue;
                }
                ByteBuffer bb = ByteBuffer.allocate(8).putLong(counter);
                bb.rewind();
                response = this.responseBuilder(request, hasMoreRows, partialResultContext).addFirstPart(ByteString.copyFrom((ByteBuffer)bb)).build();
                if (log.isDebugEnabled()) {
                    log.debug("Row counter from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), counter, hasMoreRows, RpcServer.getRequestUser()});
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                block11: {
                    try {
                        CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                        if (scanner == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (scanner != null) {
                            IOUtils.closeQuietly(scanner);
                        }
                        this.closeQuota(partialResultContext);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(scanner);
                }
                this.closeQuota(partialResultContext);
            }
            IOUtils.closeQuietly((Closeable)scanner);
        }
        this.closeQuota(partialResultContext);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAvg(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block14: {
            PartialResultContext partialResultContext;
            block13: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = null;
                try {
                    ByteBuffer bb;
                    ByteString first;
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Long rowCountVal = 0L;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = true;
                    do {
                        results.clear();
                        if (this.shouldBreakForThrottling(request, scan, partialResultContext)) break;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            sumVal = ci.add(sumVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                        }
                        Long i = rowCountVal;
                        Long l = rowCountVal = Long.valueOf(rowCountVal + 1L);
                        this.postScanPartialResultUpdate(results, partialResultContext);
                    } while (hasMoreRows);
                    if (sumVal != null && !request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                        first = ci.getProtoForPromotedType(sumVal).toByteString();
                        pair.addFirstPart(first);
                        bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                        bb.rewind();
                        pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        response = pair.build();
                    } else if (request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = this.responseBuilder(request, hasMoreRows, partialResultContext);
                        if (sumVal != null) {
                            first = ci.getProtoForPromotedType(sumVal).toByteString();
                            pair.addFirstPart(first);
                            bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                            bb.rewind();
                            pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        }
                        response = pair.build();
                    }
                    if (scanner == null) break block13;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block14;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStd(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block14: {
            PartialResultContext partialResultContext;
            block13: {
                RegionScanner scanner = null;
                response = null;
                partialResultContext = null;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Object sumSqVal = null;
                    Object tempVal = null;
                    long rowCountVal = 0L;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = true;
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        tempVal = null;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        sumVal = ci.add(sumVal, tempVal);
                        sumSqVal = ci.add(sumSqVal, ci.multiply(tempVal, tempVal));
                        ++rowCountVal;
                        if (hasMoreRows) continue;
                    }
                    if (sumVal != null && !request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                        ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                        ByteString first_sumSqVal = ci.getProtoForPromotedType(sumSqVal).toByteString();
                        pair.addFirstPart(first_sumVal);
                        pair.addFirstPart(first_sumSqVal);
                        ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                        bb.rewind();
                        pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        response = pair.build();
                    } else if (request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = this.responseBuilder(request, hasMoreRows, partialResultContext);
                        if (sumVal != null) {
                            ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                            ByteString first_sumSqVal = ci.getProtoForPromotedType(sumSqVal).toByteString();
                            pair.addFirstPart(first_sumVal);
                            pair.addFirstPart(first_sumSqVal);
                            ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                            bb.rewind();
                            pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        }
                        response = pair.build();
                    }
                    if (scanner == null) break block13;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block14;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMedian(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block14: {
            PartialResultContext partialResultContext;
            block13: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = null;
                try {
                    Object s;
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Object sumWeights = null;
                    Object tempVal = null;
                    Object tempWeight = null;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    partialResultContext = this.newPartialResultContext(scan);
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] valQualifier = null;
                    byte[] weightQualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        valQualifier = (byte[])qualifiers.pollFirst();
                        weightQualifier = (byte[])qualifiers.pollLast();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = true;
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        tempVal = null;
                        tempWeight = null;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Cell kv = (Cell)results.get(i);
                            tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, valQualifier, kv)));
                            if (weightQualifier == null) continue;
                            tempWeight = ci.add(tempWeight, ci.castToReturnType(ci.getValue(colFamily, weightQualifier, kv)));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        sumVal = ci.add(sumVal, tempVal);
                        sumWeights = ci.add(sumWeights, tempWeight);
                        if (hasMoreRows) continue;
                    }
                    if (sumVal != null && !request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                        ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                        s = sumWeights == null ? ci.castToReturnType(ci.getMinValue()) : sumWeights;
                        ByteString first_sumWeights = ci.getProtoForPromotedType(s).toByteString();
                        pair.addFirstPart(first_sumVal);
                        pair.addFirstPart(first_sumWeights);
                        response = pair.build();
                    } else if (request.getClientSupportsPartialResult()) {
                        AggregateProtos.AggregateResponse.Builder pair = this.responseBuilder(request, hasMoreRows, partialResultContext);
                        if (sumVal != null) {
                            ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                            s = sumWeights == null ? ci.castToReturnType(ci.getMinValue()) : sumWeights;
                            ByteString first_sumWeights = ci.getProtoForPromotedType(s).toByteString();
                            pair.addFirstPart(first_sumVal);
                            pair.addFirstPart(first_sumWeights);
                        }
                        response = pair.build();
                    }
                    if (scanner == null) break block13;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block14;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    private PartialResultContext newPartialResultContext(Scan scan) {
        if (scan.getCaching() > 0) {
            return new PartialResultContext(scan.getCaching());
        }
        return new PartialResultContext(this.env.getConfiguration().getInt("hbase.client.scanner.caching", 1000));
    }

    private boolean shouldBreakForThrottling(AggregateProtos.AggregateRequest request, Scan scan, PartialResultContext context) throws IOException {
        if (request.getClientSupportsPartialResult() && context.rowsRead % (long)context.quotaCheckInterval == 0L) {
            long maxBlockBytesScanned = context.quota == null ? Long.MAX_VALUE : context.quota.getMaxResultSize();
            try {
                context.quota = this.env.checkScanQuota(scan, maxBlockBytesScanned, context.previousReadConsumedDifference);
            }
            catch (RpcThrottlingException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Ending early for throttling for region {}", (Object)this.env.getRegion().getRegionInfo().getRegionNameAsString());
                }
                context.waitIntervalMs = e.getWaitInterval();
                return true;
            }
        }
        return false;
    }

    private void postScanPartialResultUpdate(List<Cell> results, PartialResultContext context) {
        PartialResultContext partialResultContext = context;
        partialResultContext.rowsRead = partialResultContext.rowsRead + 1L;
        if (context.quota != null) {
            context.quota.addScanResultCells(results);
        }
        if (!results.isEmpty()) {
            Cell result = results.get(results.size() - 1);
            context.lastRowSuccessfullyProcessed = result;
        }
    }

    @Nullable
    private <ACC, RES extends Message> AggregateProtos.AggregateResponse singlePartResponse(AggregateProtos.AggregateRequest request, boolean hasMoreRows, PartialResultContext partialResultContext, ACC acc, Function<ACC, RES> toRes) {
        AggregateProtos.AggregateResponse response = null;
        if (acc != null && !request.getClientSupportsPartialResult()) {
            ByteString first = ((Message)toRes.apply(acc)).toByteString();
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(first).build();
        } else if (request.getClientSupportsPartialResult()) {
            AggregateProtos.AggregateResponse.Builder responseBuilder = this.responseBuilder(request, hasMoreRows, partialResultContext);
            if (acc != null) {
                responseBuilder.addFirstPart(((Message)toRes.apply(acc)).toByteString());
            }
            response = responseBuilder.build();
        }
        return response;
    }

    private AggregateProtos.AggregateResponse.Builder responseBuilder(AggregateProtos.AggregateRequest request, boolean hasMoreRows, PartialResultContext context) {
        AggregateProtos.AggregateResponse.Builder builder = AggregateProtos.AggregateResponse.newBuilder();
        if (request.getClientSupportsPartialResult() && hasMoreRows) {
            if (context.lastRowSuccessfullyProcessed != null) {
                byte[] lastRowSuccessfullyProcessed = CellUtil.cloneRow((Cell)context.lastRowSuccessfullyProcessed);
                builder.setNextChunkStartRow(ByteString.copyFrom((byte[])ClientUtil.calculateTheClosestNextRowKeyForPrefix((byte[])lastRowSuccessfullyProcessed)));
            } else {
                builder.setNextChunkStartRow(request.getScan().getStartRow());
            }
            builder.setWaitIntervalMs(context.waitIntervalMs);
        }
        return builder;
    }

    ColumnInterpreter<T, S, P, Q, R> constructColumnInterpreterFromRequest(AggregateProtos.AggregateRequest request) throws IOException {
        String className = request.getInterpreterClassName();
        try {
            Class<?> cls = Class.forName(className);
            ColumnInterpreter ci = (ColumnInterpreter)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (request.hasInterpreterSpecificBytes()) {
                ByteString b = request.getInterpreterSpecificBytes();
                Object initMsg = AggregationHelper.getParsedGenericInstance(ci.getClass(), 2, b);
                ci.initialize(initMsg);
            }
            return ci;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private void closeQuota(PartialResultContext context) {
        if (context != null && context.quota != null) {
            context.quota.close();
            long readConsumed = context.quota.getReadConsumed();
            context.previousReadConsumedDifference = readConsumed - context.previousReadConsumed;
            context.previousReadConsumed = readConsumed;
        }
    }

    private static final class PartialResultContext {
        private long rowsRead = 0L;
        private final int quotaCheckInterval;
        private OperationQuota quota = null;
        private long waitIntervalMs = 0L;
        private Cell lastRowSuccessfullyProcessed = null;
        private long previousReadConsumed = 0L;
        private long previousReadConsumedDifference = 0L;

        private PartialResultContext(int quotaCheckInterval) {
            this.quotaCheckInterval = quotaCheckInterval;
        }
    }
}

