/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StripeStoreFileManager
implements StoreFileManager,
StripeCompactionPolicy.StripeInformationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StripeStoreFileManager.class);
    public static final byte[] STRIPE_START_KEY = Bytes.toBytes("STRIPE_START_KEY");
    public static final byte[] STRIPE_END_KEY = Bytes.toBytes("STRIPE_END_KEY");
    private static final Bytes.RowEndKeyComparator MAP_COMPARATOR = new Bytes.RowEndKeyComparator();
    public static final byte[] OPEN_KEY = HConstants.EMPTY_BYTE_ARRAY;
    static final byte[] INVALID_KEY = null;
    private State state = null;
    private HashMap<HStoreFile, byte[]> fileStarts = new HashMap();
    private HashMap<HStoreFile, byte[]> fileEnds = new HashMap();
    private static final byte[] INVALID_KEY_IN_MAP = new byte[0];
    private final CellComparator cellComparator;
    private StripeStoreConfig config;
    private final int blockingFileCount;

    public StripeStoreFileManager(CellComparator kvComparator, Configuration conf, StripeStoreConfig config) {
        this.cellComparator = kvComparator;
        this.config = config;
        this.blockingFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 16);
    }

    @Override
    public void loadFiles(List<HStoreFile> storeFiles) {
        this.loadUnclassifiedStoreFiles(storeFiles);
    }

    @Override
    public Collection<HStoreFile> getStoreFiles() {
        return this.state.allFilesCached;
    }

    @Override
    public Collection<HStoreFile> getCompactedfiles() {
        return this.state.allCompactedFilesCached;
    }

    @Override
    public int getCompactedFilesCount() {
        return this.state.allCompactedFilesCached.size();
    }

    @Override
    public void insertNewFiles(Collection<HStoreFile> sfs) {
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(true);
        cmc.mergeResults(Collections.emptyList(), sfs);
        this.debugDumpState("Added new files");
    }

    @Override
    public ImmutableCollection<HStoreFile> clearFiles() {
        ImmutableList<HStoreFile> result = this.state.allFilesCached;
        this.state = new State();
        this.fileStarts.clear();
        this.fileEnds.clear();
        return result;
    }

    public ImmutableCollection<HStoreFile> clearCompactedFiles() {
        ImmutableList result = this.state.allCompactedFilesCached;
        this.state = new State();
        return result;
    }

    @Override
    public int getStorefileCount() {
        return this.state.allFilesCached.size();
    }

    @Override
    public Iterator<HStoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        KeyBeforeConcatenatedLists result = new KeyBeforeConcatenatedLists();
        result.addSublist(this.state.level0Files);
        if (!this.state.stripeFiles.isEmpty()) {
            int lastStripeIndex;
            for (int stripeIndex = lastStripeIndex = this.findStripeForRow(CellUtil.cloneRow(targetKey), false); stripeIndex >= 0; --stripeIndex) {
                result.addSublist((List)this.state.stripeFiles.get(stripeIndex));
            }
        }
        return result.iterator();
    }

    @Override
    public Iterator<HStoreFile> updateCandidateFilesForRowKeyBefore(Iterator<HStoreFile> candidateFiles, KeyValue targetKey, Cell candidate) {
        KeyBeforeConcatenatedLists.Iterator original = (KeyBeforeConcatenatedLists.Iterator)candidateFiles;
        assert (original != null);
        ArrayList<List<HStoreFile>> components = original.getComponents();
        for (int firstIrrelevant = 0; firstIrrelevant < components.size(); ++firstIrrelevant) {
            HStoreFile sf = components.get(firstIrrelevant).get(0);
            byte[] endKey = this.endOf(sf);
            if (StripeStoreFileManager.isInvalid(endKey) || StripeStoreFileManager.isOpen(endKey) || this.nonOpenRowCompare(targetKey, endKey) < 0) continue;
            original.removeComponents(firstIrrelevant);
            break;
        }
        return original;
    }

    @Override
    public Optional<byte[]> getSplitPoint() throws IOException {
        double newRatio;
        if (this.getStorefileCount() == 0) {
            return Optional.empty();
        }
        if (this.state.stripeFiles.size() <= 1) {
            return this.getSplitPointFromAllFiles();
        }
        int leftIndex = -1;
        int rightIndex = this.state.stripeFiles.size();
        long leftSize = 0L;
        long rightSize = 0L;
        long lastLeftSize = 0L;
        long lastRightSize = 0L;
        while (rightIndex - 1 != leftIndex) {
            if (leftSize >= rightSize) {
                lastRightSize = this.getStripeFilesSize(--rightIndex);
                rightSize += lastRightSize;
                continue;
            }
            lastLeftSize = this.getStripeFilesSize(++leftIndex);
            leftSize += lastLeftSize;
        }
        if (leftSize == 0L || rightSize == 0L) {
            String errMsg = String.format("Cannot split on a boundary - left index %d size %d, right index %d size %d", leftIndex, leftSize, rightIndex, rightSize);
            this.debugDumpState(errMsg);
            LOG.warn(errMsg);
            return this.getSplitPointFromAllFiles();
        }
        double ratio = (double)rightSize / (double)leftSize;
        if (ratio < 1.0) {
            ratio = 1.0 / ratio;
        }
        if ((double)this.config.getMaxSplitImbalance() > ratio) {
            return Optional.of(this.state.stripeEndRows[leftIndex]);
        }
        boolean isRightLarger = rightSize >= leftSize;
        double d = newRatio = isRightLarger ? this.getMidStripeSplitRatio(leftSize, rightSize, lastRightSize) : this.getMidStripeSplitRatio(rightSize, leftSize, lastLeftSize);
        if (newRatio < 1.0) {
            newRatio = 1.0 / newRatio;
        }
        if (newRatio >= ratio) {
            return Optional.of(this.state.stripeEndRows[leftIndex]);
        }
        LOG.debug("Splitting the stripe - ratio w/o split " + ratio + ", ratio with split " + newRatio + " configured ratio " + this.config.getMaxSplitImbalance());
        return StoreUtils.getSplitPoint((Collection<HStoreFile>)this.state.stripeFiles.get(isRightLarger ? rightIndex : leftIndex), this.cellComparator);
    }

    private Optional<byte[]> getSplitPointFromAllFiles() throws IOException {
        ConcatenatedLists<HStoreFile> sfs = new ConcatenatedLists<HStoreFile>();
        sfs.addSublist(this.state.level0Files);
        sfs.addAllSublists(this.state.stripeFiles);
        return StoreUtils.getSplitPoint(sfs, this.cellComparator);
    }

    private double getMidStripeSplitRatio(long smallerSize, long largerSize, long lastLargerSize) {
        return (double)((float)largerSize - (float)lastLargerSize / 2.0f) / (double)((float)smallerSize + (float)lastLargerSize / 2.0f);
    }

    @Override
    public Collection<HStoreFile> getFilesForScan(byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, boolean onlyLatestVersion) {
        if (this.state.stripeFiles.isEmpty()) {
            return this.state.level0Files;
        }
        int firstStripe = this.findStripeForRow(startRow, true);
        int lastStripe = this.findStripeForRow(stopRow, false);
        assert (firstStripe <= lastStripe);
        if (firstStripe == lastStripe && this.state.level0Files.isEmpty()) {
            return this.state.stripeFiles.get(firstStripe);
        }
        if (firstStripe == 0 && lastStripe == this.state.stripeFiles.size() - 1) {
            return this.state.allFilesCached;
        }
        ConcatenatedLists<HStoreFile> result = new ConcatenatedLists<HStoreFile>();
        result.addAllSublists(this.state.stripeFiles.subList(firstStripe, lastStripe + 1));
        result.addSublist(this.state.level0Files);
        return result;
    }

    @Override
    public void addCompactionResults(Collection<HStoreFile> compactedFiles, Collection<HStoreFile> results) {
        LOG.debug("Attempting to merge compaction results: " + compactedFiles.size() + " files replaced by " + results.size());
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(false);
        cmc.mergeResults(compactedFiles, results);
        this.markCompactedAway(compactedFiles);
        this.debugDumpState("Merged compaction results");
    }

    private void markCompactedAway(Collection<HStoreFile> compactedFiles) {
        for (HStoreFile file : compactedFiles) {
            file.markCompactedAway();
        }
    }

    @Override
    public void removeCompactedFiles(Collection<HStoreFile> compactedFiles) {
        LOG.debug("Attempting to delete compaction results: " + compactedFiles.size());
        CompactionOrFlushMergeCopy cmc = new CompactionOrFlushMergeCopy(false);
        cmc.deleteResults(compactedFiles);
        this.debugDumpState("Deleted compaction results");
    }

    @Override
    public int getStoreCompactionPriority() {
        int sc;
        int fc = this.getStorefileCount();
        if (this.state.stripeFiles.isEmpty() || this.blockingFileCount <= fc) {
            return this.blockingFileCount - fc;
        }
        int l0 = this.state.level0Files.size();
        int priority = (int)Math.ceil((double)(this.blockingFileCount - fc + l0) / (double)(sc = this.state.stripeFiles.size()) - (double)l0);
        return priority <= 1 ? 2 : priority;
    }

    private long getStripeFilesSize(int stripeIndex) {
        long result = 0L;
        for (HStoreFile sf : this.state.stripeFiles.get(stripeIndex)) {
            result += sf.getReader().length();
        }
        return result;
    }

    private void loadUnclassifiedStoreFiles(List<HStoreFile> storeFiles) {
        Object endRow;
        Object startRow;
        LOG.debug("Attempting to load " + storeFiles.size() + " store files.");
        TreeMap candidateStripes = new TreeMap((Comparator<byte[]>)((Object)MAP_COMPARATOR));
        ArrayList<HStoreFile> level0Files = new ArrayList<HStoreFile>();
        for (HStoreFile sf : storeFiles) {
            byte[] startRow2 = this.startOf(sf);
            byte[] endRow2 = this.endOf(sf);
            if (StripeStoreFileManager.isInvalid(startRow2) || StripeStoreFileManager.isInvalid(endRow2)) {
                StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                this.ensureLevel0Metadata(sf);
                continue;
            }
            if (!StripeStoreFileManager.isOpen(startRow2) && !StripeStoreFileManager.isOpen(endRow2) && this.nonOpenRowCompare(startRow2, endRow2) >= 0) {
                LOG.error("Unexpected metadata - start row [" + Bytes.toString(startRow2) + "], end row [" + Bytes.toString(endRow2) + "] in file [" + sf.getPath() + "], pushing to L0");
                StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                this.ensureLevel0Metadata(sf);
                continue;
            }
            ArrayList stripe = (ArrayList)candidateStripes.get(endRow2);
            if (stripe == null) {
                stripe = new ArrayList();
                candidateStripes.put(endRow2, stripe);
            }
            StripeStoreFileManager.insertFileIntoStripe(stripe, sf);
        }
        boolean hasOverlaps = false;
        byte[] expectedStartRow = null;
        Iterator entryIter = candidateStripes.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            ArrayList files = (ArrayList)entry.getValue();
            for (int i = 0; i < files.size(); ++i) {
                HStoreFile sf = (HStoreFile)files.get(i);
                startRow = this.startOf(sf);
                if (expectedStartRow == null) {
                    expectedStartRow = startRow;
                    continue;
                }
                if (this.rowEquals(expectedStartRow, (byte[])startRow)) continue;
                hasOverlaps = true;
                LOG.warn("Store file doesn't fit into the tentative stripes - expected to start at [" + Bytes.toString(expectedStartRow) + "], but starts at [" + Bytes.toString((byte[])startRow) + "], to L0 it goes");
                HStoreFile badSf = (HStoreFile)files.remove(i);
                StripeStoreFileManager.insertFileIntoStripe(level0Files, badSf);
                this.ensureLevel0Metadata(badSf);
                --i;
            }
            endRow = (byte[])entry.getKey();
            if (!files.isEmpty()) {
                expectedStartRow = endRow;
                continue;
            }
            entryIter.remove();
        }
        if (!candidateStripes.isEmpty()) {
            boolean isOpen;
            HStoreFile firstFile = (HStoreFile)((ArrayList)candidateStripes.firstEntry().getValue()).get(0);
            boolean bl = isOpen = StripeStoreFileManager.isOpen(this.startOf(firstFile)) && StripeStoreFileManager.isOpen((byte[])candidateStripes.lastKey());
            if (!isOpen) {
                LOG.warn("The range of the loaded files does not cover full key space: from [" + Bytes.toString(this.startOf(firstFile)) + "], to [" + Bytes.toString((byte[])candidateStripes.lastKey()) + "]");
                if (!hasOverlaps) {
                    this.ensureEdgeStripeMetadata((ArrayList)candidateStripes.firstEntry().getValue(), true);
                    this.ensureEdgeStripeMetadata((ArrayList)candidateStripes.lastEntry().getValue(), false);
                } else {
                    LOG.warn("Inconsistent files, everything goes to L0.");
                    endRow = candidateStripes.values().iterator();
                    while (endRow.hasNext()) {
                        ArrayList files = (ArrayList)endRow.next();
                        startRow = files.iterator();
                        while (startRow.hasNext()) {
                            HStoreFile sf = (HStoreFile)startRow.next();
                            StripeStoreFileManager.insertFileIntoStripe(level0Files, sf);
                            this.ensureLevel0Metadata(sf);
                        }
                    }
                    candidateStripes.clear();
                }
            }
        }
        State state = new State();
        state.level0Files = ImmutableList.copyOf(level0Files);
        state.stripeFiles = new ArrayList(candidateStripes.size());
        state.stripeEndRows = new byte[Math.max(0, candidateStripes.size() - 1)][];
        ArrayList<HStoreFile> newAllFiles = new ArrayList<HStoreFile>(level0Files);
        int i = candidateStripes.size() - 1;
        for (Map.Entry entry : candidateStripes.entrySet()) {
            state.stripeFiles.add(ImmutableList.copyOf((Collection)entry.getValue()));
            newAllFiles.addAll((Collection)entry.getValue());
            if (i > 0) {
                state.stripeEndRows[state.stripeFiles.size() - 1] = (byte[])entry.getKey();
            }
            --i;
        }
        state.allFilesCached = ImmutableList.copyOf(newAllFiles);
        this.state = state;
        this.debugDumpState("Files loaded");
    }

    private void ensureEdgeStripeMetadata(ArrayList<HStoreFile> stripe, boolean isFirst) {
        HashMap<HStoreFile, byte[]> targetMap = isFirst ? this.fileStarts : this.fileEnds;
        for (HStoreFile sf : stripe) {
            targetMap.put(sf, OPEN_KEY);
        }
    }

    private void ensureLevel0Metadata(HStoreFile sf) {
        if (!StripeStoreFileManager.isInvalid(this.startOf(sf))) {
            this.fileStarts.put(sf, INVALID_KEY_IN_MAP);
        }
        if (!StripeStoreFileManager.isInvalid(this.endOf(sf))) {
            this.fileEnds.put(sf, INVALID_KEY_IN_MAP);
        }
    }

    private void debugDumpState(String string) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + string + "; current stripe state is as such:");
        sb.append("\n level 0 with ").append(this.state.level0Files.size()).append(" files: " + StringUtils.TraditionalBinaryPrefix.long2String((long)StripeCompactionPolicy.getTotalFileSize(this.state.level0Files), (String)"", (int)1) + ";");
        for (int i = 0; i < this.state.stripeFiles.size(); ++i) {
            String endRow = i == this.state.stripeEndRows.length ? "(end)" : "[" + Bytes.toString(this.state.stripeEndRows[i]) + "]";
            sb.append("\n stripe ending in ").append(endRow).append(" with ").append(this.state.stripeFiles.get(i).size()).append(" files: " + StringUtils.TraditionalBinaryPrefix.long2String((long)StripeCompactionPolicy.getTotalFileSize((Collection<HStoreFile>)this.state.stripeFiles.get(i)), (String)"", (int)1) + ";");
        }
        sb.append("\n").append(this.state.stripeFiles.size()).append(" stripes total.");
        sb.append("\n").append(this.getStorefileCount()).append(" files total.");
        LOG.debug(sb.toString());
    }

    private static final boolean isOpen(byte[] key) {
        return key != null && key.length == 0;
    }

    private static final boolean isOpen(Cell key) {
        return key != null && key.getRowLength() == 0;
    }

    private static final boolean isInvalid(byte[] key) {
        return key == INVALID_KEY;
    }

    private final boolean rowEquals(byte[] k1, byte[] k2) {
        return Bytes.equals(k1, 0, k1.length, k2, 0, k2.length);
    }

    private final int nonOpenRowCompare(byte[] k1, byte[] k2) {
        assert (!StripeStoreFileManager.isOpen(k1) && !StripeStoreFileManager.isOpen(k2));
        return Bytes.compareTo(k1, k2);
    }

    private final int nonOpenRowCompare(Cell k1, byte[] k2) {
        assert (!StripeStoreFileManager.isOpen(k1) && !StripeStoreFileManager.isOpen(k2));
        return this.cellComparator.compareRows(k1, k2, 0, k2.length);
    }

    private final int findStripeIndexByEndRow(byte[] endRow) {
        assert (!StripeStoreFileManager.isInvalid(endRow));
        if (StripeStoreFileManager.isOpen(endRow)) {
            return this.state.stripeEndRows.length;
        }
        return Arrays.binarySearch(this.state.stripeEndRows, endRow, Bytes.BYTES_COMPARATOR);
    }

    private final int findStripeForRow(byte[] row, boolean isStart) {
        if (isStart && Arrays.equals(row, HConstants.EMPTY_START_ROW)) {
            return 0;
        }
        if (!isStart && Arrays.equals(row, HConstants.EMPTY_END_ROW)) {
            return this.state.stripeFiles.size() - 1;
        }
        return Math.abs(Arrays.binarySearch(this.state.stripeEndRows, row, Bytes.BYTES_COMPARATOR) + 1);
    }

    @Override
    public final byte[] getStartRow(int stripeIndex) {
        return stripeIndex == 0 ? OPEN_KEY : this.state.stripeEndRows[stripeIndex - 1];
    }

    @Override
    public final byte[] getEndRow(int stripeIndex) {
        return stripeIndex == this.state.stripeEndRows.length ? OPEN_KEY : this.state.stripeEndRows[stripeIndex];
    }

    private byte[] startOf(HStoreFile sf) {
        byte[] result = this.fileStarts.get(sf);
        return result == null ? sf.getMetadataValue(STRIPE_START_KEY) : (result == INVALID_KEY_IN_MAP ? INVALID_KEY : result);
    }

    private byte[] endOf(HStoreFile sf) {
        byte[] result = this.fileEnds.get(sf);
        return result == null ? sf.getMetadataValue(STRIPE_END_KEY) : (result == INVALID_KEY_IN_MAP ? INVALID_KEY : result);
    }

    private static void insertFileIntoStripe(ArrayList<HStoreFile> stripe, HStoreFile sf) {
        int insertBefore = 0;
        while (true) {
            if (insertBefore == stripe.size() || StoreFileComparators.SEQ_ID.compare(sf, stripe.get(insertBefore)) >= 0) break;
            ++insertBefore;
        }
        stripe.add(insertBefore, sf);
    }

    @Override
    public List<HStoreFile> getLevel0Files() {
        return this.state.level0Files;
    }

    @Override
    public List<byte[]> getStripeBoundaries() {
        if (this.state.stripeFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(this.state.stripeEndRows.length + 2);
        result.add(OPEN_KEY);
        Collections.addAll(result, this.state.stripeEndRows);
        result.add(OPEN_KEY);
        return result;
    }

    @Override
    public ArrayList<ImmutableList<HStoreFile>> getStripes() {
        return this.state.stripeFiles;
    }

    @Override
    public int getStripeCount() {
        return this.state.stripeFiles.size();
    }

    @Override
    public Collection<HStoreFile> getUnneededFiles(long maxTs, List<HStoreFile> filesCompacting) {
        State state = this.state;
        Collection<HStoreFile> expiredStoreFiles = null;
        for (ImmutableList<HStoreFile> stripe : state.stripeFiles) {
            expiredStoreFiles = this.findExpiredFiles(stripe, maxTs, filesCompacting, expiredStoreFiles);
        }
        return this.findExpiredFiles(state.level0Files, maxTs, filesCompacting, expiredStoreFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<HStoreFile> findExpiredFiles(ImmutableList<HStoreFile> stripe, long maxTs, List<HStoreFile> filesCompacting, Collection<HStoreFile> expiredStoreFiles) {
        for (int i = 1; i < stripe.size(); ++i) {
            HStoreFile sf;
            HStoreFile hStoreFile = sf = (HStoreFile)stripe.get(i);
            synchronized (hStoreFile) {
                long fileTs = sf.getReader().getMaxTimestamp();
                if (fileTs < maxTs && !filesCompacting.contains(sf)) {
                    LOG.info("Found an expired store file: " + sf.getPath() + " whose maxTimestamp is " + fileTs + ", which is below " + maxTs);
                    if (expiredStoreFiles == null) {
                        expiredStoreFiles = new ArrayList<HStoreFile>();
                    }
                    expiredStoreFiles.add(sf);
                }
                continue;
            }
        }
        return expiredStoreFiles;
    }

    @Override
    public double getCompactionPressure() {
        State stateLocal = this.state;
        if (stateLocal.allFilesCached.size() > this.blockingFileCount) {
            return 2.0;
        }
        if (stateLocal.stripeFiles.isEmpty()) {
            return 0.0;
        }
        int blockingFilePerStripe = this.blockingFileCount / stateLocal.stripeFiles.size();
        int delta = stateLocal.level0Files.isEmpty() ? 0 : 1;
        double max = 0.0;
        for (ImmutableList<HStoreFile> stripeFile : stateLocal.stripeFiles) {
            int stripeFileCount = stripeFile.size();
            double normCount = (double)(stripeFileCount + delta - this.config.getStripeCompactMinFiles()) / (double)(blockingFilePerStripe - this.config.getStripeCompactMinFiles());
            if (normCount >= 1.0) {
                return 1.0;
            }
            if (!(normCount > max)) continue;
            max = normCount;
        }
        return max;
    }

    @Override
    public Comparator<HStoreFile> getStoreFileComparator() {
        return StoreFileComparators.SEQ_ID;
    }

    private class CompactionOrFlushMergeCopy {
        private ArrayList<List<HStoreFile>> stripeFiles = null;
        private ArrayList<HStoreFile> level0Files = null;
        private ArrayList<byte[]> stripeEndRows = null;
        private Collection<HStoreFile> compactedFiles = null;
        private Collection<HStoreFile> results = null;
        private List<HStoreFile> l0Results = new ArrayList<HStoreFile>();
        private final boolean isFlush;

        public CompactionOrFlushMergeCopy(boolean isFlush) {
            this.stripeFiles = new ArrayList<ImmutableList<HStoreFile>>(((StripeStoreFileManager)StripeStoreFileManager.this).state.stripeFiles);
            this.isFlush = isFlush;
        }

        private void mergeResults(Collection<HStoreFile> compactedFiles, Collection<HStoreFile> results) {
            TreeMap<byte[], HStoreFile> newStripes;
            assert (this.compactedFiles == null && this.results == null);
            this.compactedFiles = compactedFiles;
            this.results = results;
            if (!this.isFlush) {
                this.removeCompactedFiles();
            }
            if ((newStripes = this.processResults()) != null) {
                this.processNewCandidateStripes(newStripes);
            }
            State state = this.createNewState(false);
            StripeStoreFileManager.this.state = state;
            this.updateMetadataMaps();
        }

        private void deleteResults(Collection<HStoreFile> compactedFiles) {
            this.compactedFiles = compactedFiles;
            State state = this.createNewState(true);
            StripeStoreFileManager.this.state = state;
            this.updateMetadataMaps();
        }

        private State createNewState(boolean delCompactedFiles) {
            State oldState = StripeStoreFileManager.this.state;
            assert (oldState.stripeFiles.size() == this.stripeFiles.size() || this.stripeEndRows != null);
            State newState = new State();
            newState.level0Files = this.level0Files == null ? oldState.level0Files : ImmutableList.copyOf(this.level0Files);
            newState.stripeEndRows = this.stripeEndRows == null ? oldState.stripeEndRows : (byte[][])this.stripeEndRows.toArray((T[])new byte[this.stripeEndRows.size()][]);
            newState.stripeFiles = new ArrayList(this.stripeFiles.size());
            for (List<HStoreFile> newStripe : this.stripeFiles) {
                newState.stripeFiles.add(newStripe instanceof ImmutableList ? (ImmutableList<HStoreFile>)newStripe : ImmutableList.copyOf(newStripe));
            }
            ArrayList<HStoreFile> newAllFiles = new ArrayList<HStoreFile>(oldState.allFilesCached);
            ArrayList<HStoreFile> newAllCompactedFiles = new ArrayList<HStoreFile>(oldState.allCompactedFilesCached);
            if (!this.isFlush) {
                newAllFiles.removeAll(this.compactedFiles);
                if (delCompactedFiles) {
                    newAllCompactedFiles.removeAll(this.compactedFiles);
                } else {
                    newAllCompactedFiles.addAll(this.compactedFiles);
                }
            }
            if (this.results != null) {
                newAllFiles.addAll(this.results);
            }
            newState.allFilesCached = ImmutableList.copyOf(newAllFiles);
            newState.allCompactedFilesCached = ImmutableList.copyOf(newAllCompactedFiles);
            return newState;
        }

        private void updateMetadataMaps() {
            StripeStoreFileManager parent = StripeStoreFileManager.this;
            if (!this.isFlush) {
                for (HStoreFile sf : this.compactedFiles) {
                    parent.fileStarts.remove(sf);
                    parent.fileEnds.remove(sf);
                }
            }
            if (this.l0Results != null) {
                for (HStoreFile sf : this.l0Results) {
                    parent.ensureLevel0Metadata(sf);
                }
            }
        }

        private final ArrayList<HStoreFile> getStripeCopy(int index) {
            List<HStoreFile> stripeCopy = this.stripeFiles.get(index);
            ArrayList<HStoreFile> result = null;
            if (stripeCopy instanceof ImmutableList) {
                result = new ArrayList<HStoreFile>(stripeCopy);
                this.stripeFiles.set(index, result);
            } else {
                result = (ArrayList<HStoreFile>)stripeCopy;
            }
            return result;
        }

        private final ArrayList<HStoreFile> getLevel0Copy() {
            if (this.level0Files == null) {
                this.level0Files = new ArrayList<HStoreFile>(((StripeStoreFileManager)StripeStoreFileManager.this).state.level0Files);
            }
            return this.level0Files;
        }

        private TreeMap<byte[], HStoreFile> processResults() {
            TreeMap<byte[], HStoreFile> newStripes = null;
            for (HStoreFile sf : this.results) {
                HStoreFile oldSf;
                int stripeIndex;
                byte[] startRow = StripeStoreFileManager.this.startOf(sf);
                byte[] endRow = StripeStoreFileManager.this.endOf(sf);
                if (StripeStoreFileManager.isInvalid(endRow) || StripeStoreFileManager.isInvalid(startRow)) {
                    if (!this.isFlush) {
                        LOG.warn("The newly compacted file doesn't have stripes set: " + sf.getPath());
                    }
                    StripeStoreFileManager.insertFileIntoStripe(this.getLevel0Copy(), sf);
                    this.l0Results.add(sf);
                    continue;
                }
                if (!this.stripeFiles.isEmpty() && (stripeIndex = StripeStoreFileManager.this.findStripeIndexByEndRow(endRow)) >= 0 && StripeStoreFileManager.this.rowEquals(StripeStoreFileManager.this.getStartRow(stripeIndex), startRow)) {
                    StripeStoreFileManager.insertFileIntoStripe(this.getStripeCopy(stripeIndex), sf);
                    continue;
                }
                if (newStripes == null) {
                    newStripes = new TreeMap<byte[], HStoreFile>((Comparator<byte[]>)((Object)MAP_COMPARATOR));
                }
                if ((oldSf = newStripes.put(endRow, sf)) == null) continue;
                throw new IllegalStateException("Compactor has produced multiple files for the stripe ending in [" + Bytes.toString(endRow) + "], found " + sf.getPath() + " and " + oldSf.getPath());
            }
            return newStripes;
        }

        private void removeCompactedFiles() {
            for (HStoreFile oldFile : this.compactedFiles) {
                byte[] oldEndRow = StripeStoreFileManager.this.endOf(oldFile);
                ArrayList<HStoreFile> source = null;
                if (StripeStoreFileManager.isInvalid(oldEndRow)) {
                    source = this.getLevel0Copy();
                } else {
                    int stripeIndex = StripeStoreFileManager.this.findStripeIndexByEndRow(oldEndRow);
                    if (stripeIndex < 0) {
                        throw new IllegalStateException("An allegedly compacted file [" + oldFile + "] does not belong to a known stripe (end row - [" + Bytes.toString(oldEndRow) + "])");
                    }
                    source = this.getStripeCopy(stripeIndex);
                }
                if (source.remove(oldFile)) continue;
                LOG.warn("An allegedly compacted file [{}] was not found", (Object)oldFile);
            }
        }

        private void processNewCandidateStripes(TreeMap<byte[], HStoreFile> newStripes) {
            boolean hasStripes = !this.stripeFiles.isEmpty();
            this.stripeEndRows = new ArrayList(Arrays.asList(((StripeStoreFileManager)StripeStoreFileManager.this).state.stripeEndRows));
            int removeFrom = 0;
            byte[] firstStartRow = StripeStoreFileManager.this.startOf(newStripes.firstEntry().getValue());
            byte[] lastEndRow = newStripes.lastKey();
            if (!(hasStripes || StripeStoreFileManager.isOpen(firstStartRow) && StripeStoreFileManager.isOpen(lastEndRow))) {
                throw new IllegalStateException("Newly created stripes do not cover the entire key space.");
            }
            boolean canAddNewStripes = true;
            Collection<HStoreFile> filesForL0 = null;
            if (hasStripes) {
                if (StripeStoreFileManager.isOpen(firstStartRow)) {
                    removeFrom = 0;
                } else {
                    removeFrom = StripeStoreFileManager.this.findStripeIndexByEndRow(firstStartRow);
                    if (removeFrom < 0) {
                        throw new IllegalStateException("Compaction is trying to add a bad range.");
                    }
                    ++removeFrom;
                }
                int removeTo = StripeStoreFileManager.this.findStripeIndexByEndRow(lastEndRow);
                if (removeTo < 0) {
                    throw new IllegalStateException("Compaction is trying to add a bad range.");
                }
                ArrayList<HStoreFile> conflictingFiles = new ArrayList<HStoreFile>();
                for (int removeIndex = removeTo; removeIndex >= removeFrom; --removeIndex) {
                    conflictingFiles.addAll((Collection)this.stripeFiles.get(removeIndex));
                }
                if (!conflictingFiles.isEmpty()) {
                    if (this.isFlush) {
                        long newSize = StripeCompactionPolicy.getTotalFileSize(newStripes.values());
                        LOG.warn("Stripes were created by a flush, but results of size " + newSize + " cannot be added because the stripes have changed");
                        canAddNewStripes = false;
                        filesForL0 = newStripes.values();
                    } else {
                        long oldSize = StripeCompactionPolicy.getTotalFileSize(conflictingFiles);
                        LOG.info(conflictingFiles.size() + " conflicting files (likely created by a flush)  of size " + oldSize + " are moved to L0 due to concurrent stripe change");
                        filesForL0 = conflictingFiles;
                    }
                    if (filesForL0 != null) {
                        for (HStoreFile sf : filesForL0) {
                            StripeStoreFileManager.insertFileIntoStripe(this.getLevel0Copy(), sf);
                        }
                        this.l0Results.addAll(filesForL0);
                    }
                }
                if (canAddNewStripes) {
                    int originalCount = this.stripeFiles.size();
                    for (int removeIndex = removeTo; removeIndex >= removeFrom; --removeIndex) {
                        if (removeIndex != originalCount - 1) {
                            this.stripeEndRows.remove(removeIndex);
                        }
                        this.stripeFiles.remove(removeIndex);
                    }
                }
            }
            if (!canAddNewStripes) {
                return;
            }
            byte[] previousEndRow = null;
            int insertAt = removeFrom;
            for (Map.Entry<byte[], HStoreFile> newStripe : newStripes.entrySet()) {
                if (previousEndRow != null) {
                    assert (!StripeStoreFileManager.isOpen(previousEndRow));
                    byte[] startRow = StripeStoreFileManager.this.startOf(newStripe.getValue());
                    if (!StripeStoreFileManager.this.rowEquals(previousEndRow, startRow)) {
                        throw new IllegalStateException("The new stripes produced by " + (this.isFlush ? "flush" : "compaction") + " are not contiguous");
                    }
                }
                ArrayList<HStoreFile> tmp = new ArrayList<HStoreFile>();
                tmp.add(newStripe.getValue());
                this.stripeFiles.add(insertAt, tmp);
                previousEndRow = newStripe.getKey();
                if (!StripeStoreFileManager.isOpen(previousEndRow)) {
                    this.stripeEndRows.add(insertAt, previousEndRow);
                }
                ++insertAt;
            }
        }
    }

    private static class KeyBeforeConcatenatedLists
    extends ConcatenatedLists<HStoreFile> {
        private KeyBeforeConcatenatedLists() {
        }

        @Override
        public java.util.Iterator<HStoreFile> iterator() {
            return new Iterator();
        }

        static /* synthetic */ int access$800(KeyBeforeConcatenatedLists x0) {
            return x0.size;
        }

        public class Iterator
        extends ConcatenatedLists.Iterator {
            public ArrayList<List<HStoreFile>> getComponents() {
                return KeyBeforeConcatenatedLists.this.components;
            }

            public void removeComponents(int startIndex) {
                List subList = KeyBeforeConcatenatedLists.this.components.subList(startIndex, KeyBeforeConcatenatedLists.this.components.size());
                for (List entry : subList) {
                    KeyBeforeConcatenatedLists.this.size = KeyBeforeConcatenatedLists.this.size - entry.size();
                }
                assert (KeyBeforeConcatenatedLists.this.size >= 0);
                subList.clear();
            }

            @Override
            public void remove() {
                if (!this.nextWasCalled) {
                    throw new IllegalStateException("No element to remove");
                }
                this.nextWasCalled = false;
                ArrayList src = (ArrayList)KeyBeforeConcatenatedLists.this.components.get(this.currentComponent);
                if (src instanceof ImmutableList) {
                    src = new ArrayList(src);
                    KeyBeforeConcatenatedLists.this.components.set(this.currentComponent, src);
                }
                src.remove(this.indexWithinComponent);
                --KeyBeforeConcatenatedLists.this.size;
                --this.indexWithinComponent;
                if (src.isEmpty()) {
                    KeyBeforeConcatenatedLists.this.components.remove(this.currentComponent);
                }
            }
        }
    }

    private static class State {
        public byte[][] stripeEndRows = new byte[0][];
        public ArrayList<ImmutableList<HStoreFile>> stripeFiles = new ArrayList();
        public ImmutableList<HStoreFile> level0Files = ImmutableList.of();
        public ImmutableList<HStoreFile> allFilesCached = ImmutableList.of();
        private ImmutableList<HStoreFile> allCompactedFilesCached = ImmutableList.of();

        private State() {
        }
    }
}

