/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class HFileLinkCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(HFileLinkCleaner.class);
    private FileSystem fs = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        this.lock.readLock().lock();
        try {
            FileStatus[] fileStatuses;
            if (this.fs == null) {
                boolean bl = false;
                return bl;
            }
            Path filePath = fStat.getPath();
            if (HFileLink.isHFileLink(filePath)) {
                boolean bl = true;
                return bl;
            }
            Path parentDir = filePath.getParent();
            if (HFileLink.isBackReferencesDir(parentDir)) {
                Path hfilePath;
                block24: {
                    hfilePath = null;
                    try {
                        hfilePath = HFileLink.getHFileFromBackReference(new Path(CommonFSUtils.getRootDir((Configuration)this.getConf()), ".tmp"), filePath);
                        if (!this.fs.exists(hfilePath)) break block24;
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Couldn't verify if the referenced file still exists, keep it just in case: " + hfilePath);
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                hfilePath = HFileLink.getHFileFromBackReference(MobUtils.getMobHome(this.getConf()), filePath);
                if (this.fs.exists(hfilePath)) {
                    boolean bl = false;
                    return bl;
                }
                hfilePath = HFileLink.getHFileFromBackReference(CommonFSUtils.getRootDir((Configuration)this.getConf()), filePath);
                boolean bl = !this.fs.exists(hfilePath);
                return bl;
            }
            Path backRefDir = HFileLink.getBackReferencesDir(parentDir, filePath.getName());
            try {
                fileStatuses = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)backRefDir);
                if (fileStatuses == null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Couldn't get the references, not deleting file, just in case. filePath=" + filePath + ", backRefDir=" + backRefDir);
                }
                boolean bl = false;
                return bl;
            }
            for (FileStatus fileStatus : fileStatuses) {
                if (this.isFileDeletable(fileStatus)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.lock.writeLock().lock();
        try {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't instantiate the file system, not deleting file, just in case. fs.defaultFS=" + this.getConf().get("fs.defaultFS", "file:///"));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

