/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.JitterScheduledThreadPoolExecutorImpl;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChoreService {
    private static final Logger LOG = LoggerFactory.getLogger(ChoreService.class);
    @InterfaceAudience.Private
    public static final int MIN_CORE_POOL_SIZE = 1;
    public static final String CHORE_SERVICE_INITIAL_POOL_SIZE = "hbase.choreservice.initial.pool.size";
    public static final int DEFAULT_CHORE_SERVICE_INITIAL_POOL_SIZE = 1;
    private final ScheduledThreadPoolExecutor scheduler;
    private final HashMap<ScheduledChore, ScheduledFuture<?>> scheduledChores;
    private final HashMap<ScheduledChore, Boolean> choresMissingStartTime;
    private final String coreThreadPoolPrefix;

    @InterfaceAudience.Private
    public ChoreService(String coreThreadPoolPrefix) {
        this(coreThreadPoolPrefix, 1, false);
    }

    public ChoreService(String coreThreadPoolPrefix, boolean jitter) {
        this(coreThreadPoolPrefix, 1, jitter);
    }

    public ChoreService(String coreThreadPoolPrefix, int corePoolSize, boolean jitter) {
        this.coreThreadPoolPrefix = coreThreadPoolPrefix;
        if (corePoolSize < 1) {
            corePoolSize = 1;
        }
        ChoreServiceThreadFactory threadFactory = new ChoreServiceThreadFactory(coreThreadPoolPrefix);
        this.scheduler = jitter ? new JitterScheduledThreadPoolExecutorImpl(corePoolSize, (ThreadFactory)threadFactory, 0.1) : new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduledChores = new HashMap();
        this.choresMissingStartTime = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleChore(ScheduledChore chore) {
        if (chore == null) {
            return false;
        }
        ScheduledChore scheduledChore = chore;
        synchronized (scheduledChore) {
            ChoreService choreService = this;
            synchronized (choreService) {
                try {
                    if (chore.getChoreService() == this) {
                        LOG.warn("Chore {} has already been scheduled with us", (Object)chore);
                        return false;
                    }
                    if (chore.getPeriod() <= 0) {
                        LOG.info("Chore {} is disabled because its period is not positive.", (Object)chore);
                        return false;
                    }
                    LOG.info("Chore {} is enabled.", (Object)chore);
                    if (chore.getChoreService() != null) {
                        LOG.info("Cancel chore {} from its previous service", (Object)chore);
                        chore.getChoreService().cancelChore(chore);
                    }
                    chore.setChoreService(this);
                    ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(TraceUtil.tracedRunnable((Runnable)chore, chore.getName()), chore.getInitialDelay(), chore.getPeriod(), chore.getTimeUnit());
                    this.scheduledChores.put(chore, future);
                    return true;
                }
                catch (Exception e) {
                    LOG.error("Could not successfully schedule chore: {}", (Object)chore.getName(), (Object)e);
                    return false;
                }
            }
        }
    }

    private void rescheduleChore(ScheduledChore chore) {
        ScheduledFuture<?> future;
        if (this.scheduledChores.containsKey(chore)) {
            future = this.scheduledChores.get(chore);
            future.cancel(false);
        }
        future = this.scheduler.scheduleAtFixedRate(chore, chore.getInitialDelay(), chore.getPeriod(), chore.getTimeUnit());
        this.scheduledChores.put(chore, future);
    }

    @RestrictedApi(explanation="Should only be called in ScheduledChore", link="", allowedOnPath=".*/org/apache/hadoop/hbase/(ScheduledChore|ChoreService).java")
    synchronized void cancelChore(ScheduledChore chore) {
        this.cancelChore(chore, true);
    }

    @RestrictedApi(explanation="Should only be called in ScheduledChore", link="", allowedOnPath=".*/org/apache/hadoop/hbase/(ScheduledChore|ChoreService).java")
    synchronized void cancelChore(ScheduledChore chore, boolean mayInterruptIfRunning) {
        if (this.scheduledChores.containsKey(chore)) {
            ScheduledFuture<?> future = this.scheduledChores.get(chore);
            future.cancel(mayInterruptIfRunning);
            this.scheduledChores.remove(chore);
            if (this.choresMissingStartTime.containsKey(chore)) {
                this.choresMissingStartTime.remove(chore);
                this.requestCorePoolDecrease();
            }
        }
    }

    @InterfaceAudience.Private
    public synchronized boolean isChoreScheduled(ScheduledChore chore) {
        return chore != null && this.scheduledChores.containsKey(chore) && !this.scheduledChores.get(chore).isDone();
    }

    @RestrictedApi(explanation="Should only be called in ScheduledChore", link="", allowedOnPath=".*/org/apache/hadoop/hbase/ScheduledChore.java")
    synchronized void triggerNow(ScheduledChore chore) {
        assert (chore.getChoreService() == this);
        this.rescheduleChore(chore);
    }

    int getNumberOfScheduledChores() {
        return this.scheduledChores.size();
    }

    int getNumberOfChoresMissingStartTime() {
        return this.choresMissingStartTime.size();
    }

    int getCorePoolSize() {
        return this.scheduler.getCorePoolSize();
    }

    private synchronized boolean requestCorePoolIncrease() {
        if (this.scheduler.getCorePoolSize() < this.scheduledChores.size()) {
            this.scheduler.setCorePoolSize(this.scheduler.getCorePoolSize() + 1);
            this.printChoreServiceDetails("requestCorePoolIncrease");
            return true;
        }
        return false;
    }

    private synchronized void requestCorePoolDecrease() {
        if (this.scheduler.getCorePoolSize() > 1) {
            this.scheduler.setCorePoolSize(this.scheduler.getCorePoolSize() - 1);
            this.printChoreServiceDetails("requestCorePoolDecrease");
        }
    }

    @RestrictedApi(explanation="Should only be called in ScheduledChore", link="", allowedOnPath=".*/org/apache/hadoop/hbase/ScheduledChore.java")
    synchronized void onChoreMissedStartTime(ScheduledChore chore) {
        if (!this.scheduledChores.containsKey(chore)) {
            return;
        }
        if (!this.choresMissingStartTime.containsKey(chore) || !this.choresMissingStartTime.get(chore).booleanValue()) {
            this.choresMissingStartTime.put(chore, this.requestCorePoolIncrease());
        }
        this.rescheduleChore(chore);
        this.printChoreDetails("onChoreMissedStartTime", chore);
    }

    public synchronized void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        this.scheduler.shutdownNow();
        LOG.info("Chore service for: {} had {} on shutdown", (Object)this.coreThreadPoolPrefix, this.scheduledChores.keySet());
        this.cancelAllChores(true);
        this.scheduledChores.clear();
        this.choresMissingStartTime.clear();
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public boolean isTerminated() {
        return this.scheduler.isTerminated();
    }

    private void cancelAllChores(boolean mayInterruptIfRunning) {
        ArrayList<ScheduledChore> choresToCancel = new ArrayList<ScheduledChore>(this.scheduledChores.keySet());
        for (ScheduledChore chore : choresToCancel) {
            this.cancelChore(chore, mayInterruptIfRunning);
        }
    }

    private void printChoreDetails(String header, ScheduledChore chore) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put(header, "");
        output.put("Chore name: ", chore.getName());
        output.put("Chore period: ", Integer.toString(chore.getPeriod()));
        output.put("Chore timeBetweenRuns: ", Long.toString(chore.getTimeBetweenRuns()));
        for (Map.Entry entry : output.entrySet()) {
            LOG.trace((String)entry.getKey() + (String)entry.getValue());
        }
    }

    private void printChoreServiceDetails(String header) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put(header, "");
        output.put("ChoreService corePoolSize: ", Integer.toString(this.getCorePoolSize()));
        output.put("ChoreService scheduledChores: ", Integer.toString(this.getNumberOfScheduledChores()));
        output.put("ChoreService missingStartTimeCount: ", Integer.toString(this.getNumberOfChoresMissingStartTime()));
        for (Map.Entry entry : output.entrySet()) {
            LOG.trace((String)entry.getKey() + (String)entry.getValue());
        }
    }

    static class ChoreServiceThreadFactory
    implements ThreadFactory {
        private final String threadPrefix;
        private static final String THREAD_NAME_SUFFIX = ".Chore.";
        private AtomicInteger threadNumber = new AtomicInteger(1);

        public ChoreServiceThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadPrefix + THREAD_NAME_SUFFIX + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

