/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractResourceUsage;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ResourceUsage
extends AbstractResourceUsage {
    private static final String NL = "";

    public Resource getUsed() {
        return this.getUsed(NL);
    }

    public Resource getUsed(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.USED);
    }

    public void incUsed(String label, Resource res) {
        this._inc(label, AbstractResourceUsage.ResourceType.USED, res);
    }

    public void incUsed(Resource res) {
        this.incUsed(NL, res);
    }

    public void decUsed(Resource res) {
        this.decUsed(NL, res);
    }

    public void decUsed(String label, Resource res) {
        this._dec(label, AbstractResourceUsage.ResourceType.USED, res);
    }

    public void setUsed(Resource res) {
        this.setUsed(NL, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAllUsed(AbstractResourceUsage other) {
        this.writeLock.lock();
        try {
            for (Map.Entry<String, AbstractResourceUsage.UsageByLabel> entry : other.usages.entrySet()) {
                this.setUsed(entry.getKey(), Resources.clone((Resource)entry.getValue().getUsed()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setUsed(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.USED, res);
    }

    public Resource getPending() {
        return this.getPending(NL);
    }

    public Resource getPending(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.PENDING);
    }

    public void incPending(String label, Resource res) {
        this._inc(label, AbstractResourceUsage.ResourceType.PENDING, res);
    }

    public void incPending(Resource res) {
        this.incPending(NL, res);
    }

    public void decPending(Resource res) {
        this.decPending(NL, res);
    }

    public void decPending(String label, Resource res) {
        this._dec(label, AbstractResourceUsage.ResourceType.PENDING, res);
    }

    public void setPending(Resource res) {
        this.setPending(NL, res);
    }

    public void setPending(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.PENDING, res);
    }

    public Resource getReserved() {
        return this.getReserved(NL);
    }

    public Resource getReserved(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.RESERVED);
    }

    public void incReserved(String label, Resource res) {
        this._inc(label, AbstractResourceUsage.ResourceType.RESERVED, res);
    }

    public void incReserved(Resource res) {
        this.incReserved(NL, res);
    }

    public void decReserved(Resource res) {
        this.decReserved(NL, res);
    }

    public void decReserved(String label, Resource res) {
        this._dec(label, AbstractResourceUsage.ResourceType.RESERVED, res);
    }

    public void setReserved(Resource res) {
        this.setReserved(NL, res);
    }

    public void setReserved(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.RESERVED, res);
    }

    public Resource getAMUsed() {
        return this.getAMUsed(NL);
    }

    public Resource getAMUsed(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.AMUSED);
    }

    public void incAMUsed(String label, Resource res) {
        this._inc(label, AbstractResourceUsage.ResourceType.AMUSED, res);
    }

    public void incAMUsed(Resource res) {
        this.incAMUsed(NL, res);
    }

    public void decAMUsed(Resource res) {
        this.decAMUsed(NL, res);
    }

    public void decAMUsed(String label, Resource res) {
        this._dec(label, AbstractResourceUsage.ResourceType.AMUSED, res);
    }

    public void setAMUsed(Resource res) {
        this.setAMUsed(NL, res);
    }

    public void setAMUsed(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.AMUSED, res);
    }

    public Resource getAllPending() {
        return this._getAll(AbstractResourceUsage.ResourceType.PENDING);
    }

    public Resource getAllUsed() {
        return this._getAll(AbstractResourceUsage.ResourceType.USED);
    }

    public Resource getAllReserved() {
        return this._getAll(AbstractResourceUsage.ResourceType.RESERVED);
    }

    public Resource getCachedUsed() {
        return this._get(NL, AbstractResourceUsage.ResourceType.CACHED_USED);
    }

    public Resource getCachedUsed(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.CACHED_USED);
    }

    public Resource getCachedPending() {
        return this._get(NL, AbstractResourceUsage.ResourceType.CACHED_PENDING);
    }

    public Resource getCachedPending(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.CACHED_PENDING);
    }

    public void setCachedUsed(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.CACHED_USED, res);
    }

    public void setCachedUsed(Resource res) {
        this._set(NL, AbstractResourceUsage.ResourceType.CACHED_USED, res);
    }

    public void setCachedPending(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.CACHED_PENDING, res);
    }

    public void setCachedPending(Resource res) {
        this._set(NL, AbstractResourceUsage.ResourceType.CACHED_PENDING, res);
    }

    public Resource getAMLimit() {
        return this.getAMLimit(NL);
    }

    public Resource getAMLimit(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.AMLIMIT);
    }

    public void incAMLimit(String label, Resource res) {
        this._inc(label, AbstractResourceUsage.ResourceType.AMLIMIT, res);
    }

    public void incAMLimit(Resource res) {
        this.incAMLimit(NL, res);
    }

    public void decAMLimit(Resource res) {
        this.decAMLimit(NL, res);
    }

    public void decAMLimit(String label, Resource res) {
        this._dec(label, AbstractResourceUsage.ResourceType.AMLIMIT, res);
    }

    public void setAMLimit(Resource res) {
        this.setAMLimit(NL, res);
    }

    public void setAMLimit(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.AMLIMIT, res);
    }

    public Resource getUserAMLimit() {
        return this.getAMLimit(NL);
    }

    public Resource getUserAMLimit(String label) {
        return this._get(label, AbstractResourceUsage.ResourceType.USERAMLIMIT);
    }

    public void setUserAMLimit(Resource res) {
        this.setAMLimit(NL, res);
    }

    public void setUserAMLimit(String label, Resource res) {
        this._set(label, AbstractResourceUsage.ResourceType.USERAMLIMIT, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getCachedDemand(String label) {
        this.readLock.lock();
        try {
            Resource demand = Resources.createResource((int)0);
            Resources.addTo((Resource)demand, (Resource)this.getCachedUsed(label));
            Resources.addTo((Resource)demand, (Resource)this.getCachedPending(label));
            Resource resource = demand;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

