/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, LargeTests.class})
public class TestSecureBulkloadListener {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureBulkloadListener.class);
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    private Configuration conf;
    private MiniDFSCluster cluster;
    private HBaseTestingUtility htu;
    private DistributedFileSystem dfs;
    private final Random random = new Random();
    private final byte[] randomBytes = new byte[100];
    private static final String host1 = "host1";
    private static final String host2 = "host2";
    private static final String host3 = "host3";
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final String STAGING_DIR = "staging";
    private static final String CUSTOM_STAGING_DIR = "customStaging";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.random.nextBytes(this.randomBytes);
        this.htu = new HBaseTestingUtility();
        this.htu.getConfiguration().setInt("dfs.blocksize", 1024);
        this.htu.getConfiguration().setInt("dfs.replication", 3);
        this.htu.startMiniDFSCluster(3, new String[]{"/r1", "/r2", "/r3"}, new String[]{host1, host2, host3});
        this.conf = this.htu.getConfiguration();
        this.cluster = this.htu.getDFSCluster();
        this.dfs = (DistributedFileSystem)FileSystem.get((Configuration)this.conf);
    }

    @After
    public void tearDownAfterClass() throws Exception {
        this.htu.shutdownMiniCluster();
    }

    @Test
    public void testMovingStagedFile() throws Exception {
        Path stagingDirPath = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), STAGING_DIR));
        if (!this.dfs.exists(stagingDirPath)) {
            this.dfs.mkdirs(stagingDirPath);
        }
        SecureBulkLoadManager.SecureBulkLoadListener listener = new SecureBulkLoadManager.SecureBulkLoadListener((FileSystem)this.dfs, stagingDirPath.toString(), this.conf);
        String srcFile = this.createHFileForFamilies(FAMILY);
        Path srcPath = new Path(srcFile);
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
        Path stagedFamily = new Path(stagingDirPath, new Path(Bytes.toString((byte[])FAMILY)));
        if (!this.dfs.exists(stagedFamily)) {
            this.dfs.mkdirs(stagedFamily);
        }
        String stagedFile = listener.prepareBulkLoad(FAMILY, srcFile, false, null);
        Path stagedPath = new Path(stagedFile);
        Assert.assertTrue((boolean)this.dfs.exists(stagedPath));
        Assert.assertFalse((boolean)this.dfs.exists(srcPath));
        listener.failedBulkLoad(FAMILY, stagedFile);
        Assert.assertFalse((boolean)this.dfs.exists(stagedPath));
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
    }

    @Test
    public void testMovingStagedFileWithCustomStageDir() throws Exception {
        Path customStagingDirPath;
        Path customStagedFamily;
        Path stagingDirPath = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), STAGING_DIR));
        if (!this.dfs.exists(stagingDirPath)) {
            this.dfs.mkdirs(stagingDirPath);
        }
        SecureBulkLoadManager.SecureBulkLoadListener listener = new SecureBulkLoadManager.SecureBulkLoadListener((FileSystem)this.dfs, stagingDirPath.toString(), this.conf);
        String srcFile = this.createHFileForFamilies(FAMILY);
        Path srcPath = new Path(srcFile);
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
        Path stagedFamily = new Path(stagingDirPath, new Path(Bytes.toString((byte[])FAMILY)));
        if (!this.dfs.exists(stagedFamily)) {
            this.dfs.mkdirs(stagedFamily);
        }
        if (!this.dfs.exists(customStagedFamily = new Path(customStagingDirPath = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), CUSTOM_STAGING_DIR)), new Path(Bytes.toString((byte[])FAMILY))))) {
            this.dfs.mkdirs(customStagedFamily);
        }
        String stagedFile = listener.prepareBulkLoad(FAMILY, srcFile, false, customStagingDirPath.toString());
        Path stagedPath = new Path(stagedFile);
        Assert.assertTrue((boolean)this.dfs.exists(stagedPath));
        Assert.assertFalse((boolean)this.dfs.exists(srcPath));
        listener.failedBulkLoad(FAMILY, stagedFile);
        Assert.assertFalse((boolean)this.dfs.exists(stagedPath));
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
    }

    @Test
    public void testCopiedStagedFile() throws Exception {
        Path stagingDirPath = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), STAGING_DIR));
        if (!this.dfs.exists(stagingDirPath)) {
            this.dfs.mkdirs(stagingDirPath);
        }
        SecureBulkLoadManager.SecureBulkLoadListener listener = new SecureBulkLoadManager.SecureBulkLoadListener((FileSystem)this.dfs, stagingDirPath.toString(), this.conf);
        String srcFile = this.createHFileForFamilies(FAMILY);
        Path srcPath = new Path(srcFile);
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
        Path stagedFamily = new Path(stagingDirPath, new Path(Bytes.toString((byte[])FAMILY)));
        if (!this.dfs.exists(stagedFamily)) {
            this.dfs.mkdirs(stagedFamily);
        }
        String stagedFile = listener.prepareBulkLoad(FAMILY, srcFile, true, null);
        Path stagedPath = new Path(stagedFile);
        Assert.assertTrue((boolean)this.dfs.exists(stagedPath));
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
        listener.failedBulkLoad(FAMILY, stagedFile);
        Assert.assertTrue((boolean)this.dfs.exists(stagedPath));
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
    }

    @Test(expected=IOException.class)
    public void testDeletedStagedFile() throws Exception {
        Path stagingDirPath = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), STAGING_DIR));
        if (!this.dfs.exists(stagingDirPath)) {
            this.dfs.mkdirs(stagingDirPath);
        }
        SecureBulkLoadManager.SecureBulkLoadListener listener = new SecureBulkLoadManager.SecureBulkLoadListener((FileSystem)this.dfs, stagingDirPath.toString(), this.conf);
        String srcFile = this.createHFileForFamilies(FAMILY);
        Path srcPath = new Path(srcFile);
        Assert.assertTrue((boolean)this.dfs.exists(srcPath));
        Path stagedFamily = new Path(stagingDirPath, new Path(Bytes.toString((byte[])FAMILY)));
        if (!this.dfs.exists(stagedFamily)) {
            this.dfs.mkdirs(stagedFamily);
        }
        String stagedFile = listener.prepareBulkLoad(FAMILY, srcFile, false, null);
        Path stagedPath = new Path(stagedFile);
        Assert.assertTrue((boolean)this.dfs.exists(stagedPath));
        Assert.assertFalse((boolean)this.dfs.exists(srcPath));
        this.dfs.delete(stagedPath, false);
        listener.failedBulkLoad(FAMILY, stagedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] family) throws IOException {
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)this.conf);
        Path testDir = new Path(this.dfs.getWorkingDirectory(), new Path(this.name.getMethodName(), Bytes.toString((byte[])family)));
        if (!this.dfs.exists(testDir)) {
            this.dfs.mkdirs(testDir);
        }
        Path hfilePath = new Path(testDir, TestSecureBulkloadListener.generateUniqueName(null));
        try (FSDataOutputStream out = this.dfs.createFile(hfilePath).build();){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContextBuilder().build());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue((Cell)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.randomBytes).setFamily(family).setQualifier(this.randomBytes).setTimestamp(0L).setType(KeyValue.Type.Put.getCode()).setValue(this.randomBytes).build()));
            }
        }
        return hfilePath.toString();
    }

    private static String generateUniqueName(String suffix) {
        String name = UUID.randomUUID().toString().replaceAll("-", "");
        if (suffix != null) {
            name = name + suffix;
        }
        return name;
    }
}

