/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.CloseExcessRegionReplicasProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReduceExcessRegionReplicasBlockedByRIT {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReduceExcessRegionReplicasBlockedByRIT.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static AsyncConnection CONN;
    private static TableDescriptor TD;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().createTable(TD);
        UTIL.waitTableAvailable(TD.getTableName());
        UTIL.waitUntilNoRegionsInTransition();
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRIT() throws Exception {
        RegionStateNode rsn = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getTableRegionStateNodes(TD.getTableName()).stream().filter(rn -> rn.getRegionInfo().getReplicaId() > 1).findAny().get();
        TransitRegionStateProcedure trsp = new TransitRegionStateProcedure();
        rsn.setProcedure(trsp);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)TD).setRegionReplication(2).build();
        CompletableFuture future = CONN.getAdmin().modifyTable(newTd);
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(5000L, () -> procExec.getProcedures().stream().anyMatch(p -> p instanceof CloseExcessRegionReplicasProcedure && !p.isFinished()));
        CloseExcessRegionReplicasProcedure proc = procExec.getProcedures().stream().filter(p -> p instanceof CloseExcessRegionReplicasProcedure).map(p -> (CloseExcessRegionReplicasProcedure)p).findFirst().get();
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(3000L);
            Assert.assertFalse((boolean)proc.isFinished());
        }
        Assert.assertTrue((boolean)rsn.isInState(new RegionState.State[]{RegionState.State.OPEN}));
        rsn.unsetProcedure(trsp);
        UTIL.waitFor(60000L, () -> proc.isFinished());
        future.get();
        Assert.assertTrue((boolean)rsn.isInState(new RegionState.State[]{RegionState.State.CLOSED}));
        Assert.assertEquals((long)2L, (long)UTIL.getMiniHBaseCluster().getRegions(TD.getTableName()).size());
    }

    static {
        TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"CloseExcessRegionReplicas")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).setRegionReplication(4).build();
    }
}

