/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.aircompressor;

import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopCompressor;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZstdCodec
implements Configurable,
CompressionCodec {
    public static final String ZSTD_BUFFER_SIZE_KEY = "hbase.io.compress.zstd.buffersize";
    public static final int ZSTD_BUFFER_SIZE_DEFAULT = 262144;
    private Configuration conf = new Configuration();
    private int bufferSize = ZstdCodec.getBufferSize(this.conf);

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = ZstdCodec.getBufferSize(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Compressor createCompressor() {
        return new HadoopZstdCompressor();
    }

    public Decompressor createDecompressor() {
        return new HadoopZstdDecompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopZstdCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopZstdDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".zst";
    }

    static int getBufferSize(Configuration conf) {
        int size = conf.getInt(ZSTD_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.zstd.buffersize", 0));
        return size > 0 ? size : 262144;
    }

    @InterfaceAudience.Private
    public class HadoopZstdDecompressor
    extends HadoopDecompressor<ZstdDecompressor> {
        HadoopZstdDecompressor(ZstdDecompressor decompressor) {
            super(decompressor, ZstdCodec.getBufferSize(ZstdCodec.this.conf));
        }

        HadoopZstdDecompressor() {
            this(new ZstdDecompressor());
        }
    }

    @InterfaceAudience.Private
    public class HadoopZstdCompressor
    extends HadoopCompressor<ZstdCompressor> {
        HadoopZstdCompressor(ZstdCompressor compressor) {
            super(compressor, ZstdCodec.getBufferSize(ZstdCodec.this.conf));
        }

        HadoopZstdCompressor() {
            this(new ZstdCompressor());
        }

        @Override
        int getLevel(Configuration conf) {
            return 0;
        }

        @Override
        int getBufferSize(Configuration conf) {
            return ZstdCodec.getBufferSize(conf);
        }
    }
}

