/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerFailureTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerFailureTracker.class);
    private Map<String, Integer> failureCountPerNode = new HashMap<String, Integer>();
    private Set<String> blackListedNodes = new HashSet<String>();
    private ServiceContext context;
    private int maxFailurePerNode;
    private Component component;

    public ContainerFailureTracker(ServiceContext context, Component component) {
        this.context = context;
        this.component = component;
        this.maxFailurePerNode = YarnServiceConf.getInt("yarn.service.node-blacklist.threshold", 3, component.getComponentSpec().getConfiguration(), context.scheduler.getConfig());
    }

    public synchronized void incNodeFailure(String host) {
        int num = 0;
        if (this.failureCountPerNode.containsKey(host)) {
            num = this.failureCountPerNode.get(host);
        }
        this.failureCountPerNode.put(host, ++num);
        if (num > this.maxFailurePerNode && !this.blackListedNodes.contains(host)) {
            ArrayList<String> blacklists = new ArrayList<String>();
            blacklists.add(host);
            this.blackListedNodes.add(host);
            this.context.scheduler.getAmRMClient().updateBlacklist(blacklists, null);
            LOG.info("[COMPONENT {}]: Failed {} times on this host, blacklisted {}. Current list of blacklisted nodes: {}", new Object[]{this.component.getName(), num, host, this.blackListedNodes});
        }
    }

    public synchronized void resetContainerFailures() {
        this.failureCountPerNode.clear();
        this.context.scheduler.getAmRMClient().updateBlacklist(null, new ArrayList<String>(this.blackListedNodes));
        LOG.info("[COMPONENT {}]: Clearing blacklisted nodes {} ", (Object)this.component.getName(), this.blackListedNodes);
        this.blackListedNodes.clear();
    }
}

