/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineExistsFilter
extends TimelineFilter {
    private TimelineCompareOp compareOp;
    private String value;

    public TimelineExistsFilter() {
    }

    public TimelineExistsFilter(TimelineCompareOp op, String value) {
        this.value = value;
        if (op != TimelineCompareOp.EQUAL && op != TimelineCompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("CompareOp for exists filter should be EQUAL or NOT_EQUAL");
        }
        this.compareOp = op;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compareOp == null ? 0 : this.compareOp.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineExistsFilter other = (TimelineExistsFilter)obj;
        if (this.compareOp != other.compareOp) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public TimelineFilter.TimelineFilterType getFilterType() {
        return TimelineFilter.TimelineFilterType.EXISTS;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getValue() {
        return this.value;
    }

    public void setCompareOp(TimelineCompareOp op) {
        this.compareOp = op;
    }

    public TimelineCompareOp getCompareOp() {
        return this.compareOp;
    }

    @Override
    public String toString() {
        return String.format("%s (%s %s)", this.getClass().getSimpleName(), this.compareOp.name(), this.value);
    }
}

