/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.type.TypeUtils;

public class BigPolynomial
extends AbstractPolynomial<BigDecimal> {
    public BigPolynomial(int aDegree) {
        super(Array1D.BIG.makeZero(aDegree + 1));
    }

    BigPolynomial(Array1D<BigDecimal> someCoefficients) {
        super(someCoefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        int tmpRowDim = (int)Math.min(x.count(), y.count());
        int tmpColDim = this.size();
        PhysicalStore tmpBody = (PhysicalStore)BigDenseStore.FACTORY.makeZero(tmpRowDim, tmpColDim);
        PhysicalStore tmpRHS = (PhysicalStore)BigDenseStore.FACTORY.makeZero(tmpRowDim, 1L);
        for (int i = 0; i < tmpRowDim; ++i) {
            BigDecimal tmpX = BigMath.ONE;
            BigDecimal tmpXfactor = TypeUtils.toBigDecimal(x.get(i));
            BigDecimal tmpY = TypeUtils.toBigDecimal(y.get(i));
            for (int j = 0; j < tmpColDim; ++j) {
                tmpBody.set((long)i, (long)j, tmpX);
                tmpX = tmpX.multiply(tmpXfactor);
            }
            tmpRHS.set((long)i, 0L, tmpY);
        }
        QR tmpQR = (QR)QR.BIG.make();
        tmpQR.decompose(tmpBody);
        this.set(tmpQR.getSolution(tmpRHS));
    }

    @Override
    public BigDecimal integrate(BigDecimal fromPoint, BigDecimal toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        BigDecimal tmpFromVal = tmpPrim.invoke(fromPoint);
        BigDecimal tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public BigDecimal invoke(BigDecimal arg) {
        int tmpPower = this.degree();
        BigDecimal retVal = (BigDecimal)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((BigDecimal)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> someCoefficient) {
        int tmpLimit = (int)Math.min(this.count(), someCoefficient.count());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, TypeUtils.toBigDecimal(someCoefficient.get(p)));
        }
    }

    @Override
    protected BigDecimal getDerivativeFactor(int aPower) {
        int tmpNextIndex = aPower + 1;
        return ((BigDecimal)this.get(tmpNextIndex)).multiply(new BigDecimal(tmpNextIndex));
    }

    @Override
    protected BigDecimal getPrimitiveFactor(int aPower) {
        if (aPower <= 0) {
            return BigMath.ZERO;
        }
        return ((BigDecimal)this.get(aPower - 1)).divide(new BigDecimal(aPower));
    }

    @Override
    protected AbstractPolynomial<BigDecimal> makeInstance(int aSize) {
        return new BigPolynomial((Array1D<BigDecimal>)Array1D.BIG.makeZero(aSize));
    }
}

