/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.util.Preconditions;

public final class VectoredIOContext {
    private int minSeekForVectorReads;
    private int maxReadSizeForVectorReads;
    private int vectoredActiveRangeReads;
    private boolean immutable = false;

    public VectoredIOContext build() {
        this.immutable = true;
        return this;
    }

    private void checkMutable() {
        Preconditions.checkState((!this.immutable ? 1 : 0) != 0, (Object)"Instance is immutable");
    }

    public VectoredIOContext setMinSeekForVectoredReads(int minSeek) {
        this.checkMutable();
        Preconditions.checkState((minSeek >= 0 ? 1 : 0) != 0);
        this.minSeekForVectorReads = minSeek;
        return this;
    }

    public int getMinSeekForVectorReads() {
        return this.minSeekForVectorReads;
    }

    public VectoredIOContext setMaxReadSizeForVectoredReads(int maxSize) {
        this.checkMutable();
        Preconditions.checkState((maxSize >= 0 ? 1 : 0) != 0);
        this.maxReadSizeForVectorReads = maxSize;
        return this;
    }

    public int getMaxReadSizeForVectorReads() {
        return this.maxReadSizeForVectorReads;
    }

    public int getVectoredActiveRangeReads() {
        return this.vectoredActiveRangeReads;
    }

    public VectoredIOContext setVectoredActiveRangeReads(int activeReads) {
        this.checkMutable();
        Preconditions.checkState((activeReads >= 0 ? 1 : 0) != 0);
        this.vectoredActiveRangeReads = activeReads;
        return this;
    }

    public String toString() {
        return "VectoredIOContext{minSeekForVectorReads=" + this.minSeekForVectorReads + ", maxReadSizeForVectorReads=" + this.maxReadSizeForVectorReads + ", vectoredActiveRangeReads=" + this.vectoredActiveRangeReads + '}';
    }
}

