/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.junit.Assert;
import org.junit.Test;

public class TestProcessingDetails {
    @Test
    public void testTimeConversion() {
        ProcessingDetails details = new ProcessingDetails(TimeUnit.MICROSECONDS);
        details.set(ProcessingDetails.Timing.ENQUEUE, 10L);
        Assert.assertEquals((long)10L, (long)details.get(ProcessingDetails.Timing.ENQUEUE));
        Assert.assertEquals((long)10000L, (long)details.get(ProcessingDetails.Timing.ENQUEUE, TimeUnit.NANOSECONDS));
        details.set(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MILLISECONDS);
        details.add(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MICROSECONDS);
        Assert.assertEquals((long)20020L, (long)details.get(ProcessingDetails.Timing.QUEUE));
        Assert.assertEquals((long)0L, (long)details.get(ProcessingDetails.Timing.QUEUE, TimeUnit.SECONDS));
    }

    @Test
    public void testToString() {
        ProcessingDetails details = new ProcessingDetails(TimeUnit.MICROSECONDS);
        details.set(ProcessingDetails.Timing.ENQUEUE, 10L);
        details.set(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"enqueueTime=10 queueTime=20000 handlerTime=0 processingTime=0 lockfreeTime=0 lockwaitTime=0 locksharedTime=0 lockexclusiveTime=0 responseTime=0", (Object)details.toString());
    }
}

