/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTFileUnsortedByteArrays {
    private static String ROOT = GenericTestUtils.getTestDir().getAbsolutePath();
    private static final int BLOCK_SIZE = 512;
    private static final int BUF_SIZE = 64;
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private FSDataOutputStream out;
    private TFile.Writer writer;
    private String compression = Compression.Algorithm.GZ.getName();
    private String outputFile = "TFileTestUnsorted";
    private int records1stBlock = 4314;
    private int records2ndBlock = 4108;

    public void init(String compression, String outputFile, int numRecords1stBlock, int numRecords2ndBlock) {
        this.compression = compression;
        this.outputFile = outputFile;
        this.records1stBlock = numRecords1stBlock;
        this.records2ndBlock = numRecords2ndBlock;
    }

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        this.out = this.fs.create(this.path);
        this.writer = new TFile.Writer(this.out, 512, this.compression, null, this.conf);
        this.writer.append("keyZ".getBytes(), "valueZ".getBytes());
        this.writer.append("keyM".getBytes(), "valueM".getBytes());
        this.writer.append("keyN".getBytes(), "valueN".getBytes());
        this.writer.append("keyA".getBytes(), "valueA".getBytes());
        this.closeOutput();
    }

    @After
    public void tearDown() throws IOException {
        this.fs.delete(this.path, true);
    }

    @Test
    public void testFailureScannerWithKeys() throws IOException {
        try (TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);){
            Assertions.assertThat((boolean)reader.isSorted()).isFalse();
            Assertions.assertThat((long)reader.getEntryCount()).isEqualTo(4L);
            try {
                reader.createScannerByKey("aaa".getBytes(), "zzz".getBytes());
                Assert.fail((String)"Failed to catch creating scanner with keys on unsorted file.");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testScan() throws IOException {
        try (TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);){
            Assertions.assertThat((boolean)reader.isSorted()).isFalse();
            Assertions.assertThat((long)reader.getEntryCount()).isEqualTo(4L);
            try (TFile.Reader.Scanner scanner = reader.createScanner();){
                byte[] kbuf = new byte[64];
                int klen = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf);
                Assertions.assertThat((String)new String(kbuf, 0, klen)).isEqualTo((Object)"keyZ");
                byte[] vbuf = new byte[64];
                int vlen = scanner.entry().getValueLength();
                scanner.entry().getValue(vbuf);
                Assertions.assertThat((String)new String(vbuf, 0, vlen)).isEqualTo((Object)"valueZ");
                scanner.advance();
                vbuf = new byte[64];
                vlen = scanner.entry().getValueLength();
                scanner.entry().getValue(vbuf);
                Assertions.assertThat((String)new String(vbuf, 0, vlen)).isEqualTo((Object)"valueM");
                kbuf = new byte[64];
                klen = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf);
                Assertions.assertThat((String)new String(kbuf, 0, klen)).isEqualTo((Object)"keyM");
            }
        }
    }

    @Test
    public void testScanRange() throws IOException {
        try (TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);){
            Assertions.assertThat((boolean)reader.isSorted()).isFalse();
            Assertions.assertThat((long)reader.getEntryCount()).isEqualTo(4L);
            try (TFile.Reader.Scanner scanner = reader.createScanner();){
                byte[] kbuf = new byte[64];
                int klen = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf);
                Assertions.assertThat((String)new String(kbuf, 0, klen)).isEqualTo((Object)"keyZ");
                byte[] vbuf = new byte[64];
                int vlen = scanner.entry().getValueLength();
                scanner.entry().getValue(vbuf);
                Assertions.assertThat((String)new String(vbuf, 0, vlen)).isEqualTo((Object)"valueZ");
                scanner.advance();
                vbuf = new byte[64];
                vlen = scanner.entry().getValueLength();
                scanner.entry().getValue(vbuf);
                Assertions.assertThat((String)new String(vbuf, 0, vlen)).isEqualTo((Object)"valueM");
                kbuf = new byte[64];
                klen = scanner.entry().getKeyLength();
                scanner.entry().getKey(kbuf);
                Assertions.assertThat((String)new String(kbuf, 0, klen)).isEqualTo((Object)"keyM");
            }
        }
    }

    @Test
    public void testFailureSeek() throws IOException {
        try (TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
             TFile.Reader.Scanner scanner = reader.createScanner();){
            try {
                scanner.lowerBound("keyN".getBytes());
                Assert.fail((String)"Cannot search in a unsorted TFile!");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                scanner.upperBound("keyA".getBytes());
                Assert.fail((String)"Cannot search higher in a unsorted TFile!");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                scanner.seekTo("keyM".getBytes());
                Assert.fail((String)"Cannot search a unsorted TFile!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.out.close();
            this.out = null;
        }
    }
}

