/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto;

import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.enc.AbstractEncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.enc.Aes128CtsHmacSha1Enc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Aes256CtsHmacSha1Enc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Camellia128CtsCmacEnc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Camellia256CtsCmacEnc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Des3CbcSha1Enc;
import org.apache.kerby.kerberos.kerb.crypto.enc.DesCbcCrcEnc;
import org.apache.kerby.kerberos.kerb.crypto.enc.DesCbcMd4Enc;
import org.apache.kerby.kerberos.kerb.crypto.enc.DesCbcMd5Enc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Rc4HmacEnc;
import org.apache.kerby.kerberos.kerb.crypto.enc.Rc4HmacExpEnc;
import org.apache.kerby.kerberos.kerb.crypto.util.Random;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class EncryptionHandler {
    public static EncryptionType getEncryptionType(String eType) throws KrbException {
        return EncryptionType.fromName((String)eType);
    }

    public static EncTypeHandler getEncHandler(String eType) throws KrbException {
        EncryptionType result = EncryptionType.fromName((String)eType);
        return EncryptionHandler.getEncHandler(result);
    }

    public static EncTypeHandler getEncHandler(int eType) throws KrbException {
        EncryptionType eTypeEnum = EncryptionType.fromValue((Integer)eType);
        return EncryptionHandler.getEncHandler(eTypeEnum);
    }

    public static EncTypeHandler getEncHandler(EncryptionType eType) throws KrbException {
        return EncryptionHandler.getEncHandler(eType, false);
    }

    private static EncTypeHandler getEncHandler(EncryptionType eType, boolean check) throws KrbException {
        AbstractEncTypeHandler encHandler = null;
        switch (eType) {
            case DES_CBC_CRC: {
                encHandler = new DesCbcCrcEnc();
                break;
            }
            case DES_CBC_MD5: 
            case DES: {
                encHandler = new DesCbcMd5Enc();
                break;
            }
            case DES_CBC_MD4: {
                encHandler = new DesCbcMd4Enc();
                break;
            }
            case DES3_CBC_SHA1: 
            case DES3_CBC_SHA1_KD: 
            case DES3_HMAC_SHA1: {
                encHandler = new Des3CbcSha1Enc();
                break;
            }
            case AES128_CTS_HMAC_SHA1_96: 
            case AES128_CTS: {
                encHandler = new Aes128CtsHmacSha1Enc();
                break;
            }
            case AES256_CTS_HMAC_SHA1_96: 
            case AES256_CTS: {
                encHandler = new Aes256CtsHmacSha1Enc();
                break;
            }
            case CAMELLIA128_CTS_CMAC: 
            case CAMELLIA128_CTS: {
                encHandler = new Camellia128CtsCmacEnc();
                break;
            }
            case CAMELLIA256_CTS_CMAC: 
            case CAMELLIA256_CTS: {
                encHandler = new Camellia256CtsCmacEnc();
                break;
            }
            case RC4_HMAC: 
            case ARCFOUR_HMAC: 
            case ARCFOUR_HMAC_MD5: {
                encHandler = new Rc4HmacEnc();
                break;
            }
            case RC4_HMAC_EXP: 
            case ARCFOUR_HMAC_EXP: 
            case ARCFOUR_HMAC_MD5_EXP: {
                encHandler = new Rc4HmacExpEnc();
                break;
            }
        }
        if (encHandler == null && !check) {
            String message = "Unsupported encryption type: " + eType.name();
            throw new KrbException(KrbErrorCode.KDC_ERR_ETYPE_NOSUPP, message);
        }
        return encHandler;
    }

    public static EncryptedData encrypt(byte[] plainText, EncryptionKey key, KeyUsage usage) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(key.getKeyType());
        byte[] cipher = handler.encrypt(plainText, key.getKeyData(), usage.getValue());
        EncryptedData ed = new EncryptedData();
        ed.setCipher(cipher);
        ed.setEType(key.getKeyType());
        if (key.getKvno() > 0) {
            ed.setKvno(key.getKvno());
        }
        return ed;
    }

    public static byte[] decrypt(byte[] data, EncryptionKey key, KeyUsage usage) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(key.getKeyType());
        return handler.decrypt(data, key.getKeyData(), usage.getValue());
    }

    public static byte[] decrypt(EncryptedData data, EncryptionKey key, KeyUsage usage) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(key.getKeyType());
        return handler.decrypt(data.getCipher(), key.getKeyData(), usage.getValue());
    }

    public static boolean isImplemented(EncryptionType eType) {
        EncTypeHandler handler = null;
        try {
            handler = EncryptionHandler.getEncHandler(eType, true);
        }
        catch (KrbException e) {
            return false;
        }
        return handler != null;
    }

    public static EncryptionKey string2Key(String principalName, String passPhrase, EncryptionType eType) throws KrbException {
        PrincipalName principal = new PrincipalName(principalName);
        return EncryptionHandler.string2Key(passPhrase, PrincipalName.makeSalt((PrincipalName)principal), null, eType);
    }

    public static EncryptionKey string2Key(String string, String salt, byte[] s2kparams, EncryptionType eType) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(eType);
        byte[] keyBytes = handler.str2key(string, salt, s2kparams);
        return new EncryptionKey(eType, keyBytes);
    }

    public static EncryptionKey random2Key(EncryptionType eType) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(eType);
        byte[] randomBytes = Random.makeBytes(handler.keyInputSize());
        byte[] keyBytes = handler.random2Key(randomBytes);
        return new EncryptionKey(eType, keyBytes);
    }

    public static EncryptionKey random2Key(EncryptionType eType, byte[] randomBytes) throws KrbException {
        EncTypeHandler handler = EncryptionHandler.getEncHandler(eType);
        byte[] randomBytes1 = randomBytes;
        byte[] keyBytes = handler.random2Key(randomBytes1);
        return new EncryptionKey(eType, keyBytes);
    }

    public static EncryptionKey makeSubkey(EncryptionKey encKey) {
        return encKey;
    }
}

