/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class MultiplyBoth
extends MatrixOperation {
    public static final MultiplyBoth SETUP = new MultiplyBoth();
    public static int THRESHOLD = 16;
    static final BigDenseStore.BigMultiplyBoth BIG = (product, left, complexity, right) -> MultiplyBoth.invokeBig(product, 0, (int)left.count() / complexity, left, complexity, right);
    static final BigDenseStore.BigMultiplyBoth BIG_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyBoth.invokeBig(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)left.count() / complexity, THRESHOLD);
    };
    static final ComplexDenseStore.ComplexMultiplyBoth COMPLEX = (product, left, complexity, right) -> MultiplyBoth.invokeComplex(product, 0, (int)left.count() / complexity, left, complexity, right);
    static final ComplexDenseStore.ComplexMultiplyBoth COMPLEX_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyBoth.invokeComplex(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)left.count() / complexity, THRESHOLD);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE = (product, left, complexity, right) -> MultiplyBoth.invokePrimitive(product, 0, (int)left.count() / complexity, left, complexity, right);
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_0XN = (product, left, complexity, right) -> {
        left.count();
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            double tmp9J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp9J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
            product.set(8L, (long)j, tmp8J);
            product.set(9L, (long)j, tmp9J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_1X1 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            tmp00 += left.doubleValue(c) * right.doubleValue(c);
        }
        product.set(0L, 0L, tmp00);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_1XN = (product, left, complexity, right) -> {
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                tmp0J += left.doubleValue(tmpIndex++) * right.doubleValue(c + j * complexity);
            }
            product.set(0L, (long)j, tmp0J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_2X2 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 2L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_3X3 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 3L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_4X4 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 4L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(3L, 0L, tmp30);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(3L, 1L, tmp31);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
        product.set(3L, 2L, tmp32);
        product.set(0L, 3L, tmp03);
        product.set(1L, 3L, tmp13);
        product.set(2L, 3L, tmp23);
        product.set(3L, 3L, tmp33);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_5X5 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp40 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp41 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp42 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        double tmp43 = PrimitiveMath.ZERO;
        double tmp04 = PrimitiveMath.ZERO;
        double tmp14 = PrimitiveMath.ZERO;
        double tmp24 = PrimitiveMath.ZERO;
        double tmp34 = PrimitiveMath.ZERO;
        double tmp44 = PrimitiveMath.ZERO;
        for (long c = 0L; c < (long)complexity; ++c) {
            long tmpIndex = c * 5L;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            double tmpLeft4 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += (long)complexity);
            double tmpRight4 = right.doubleValue(tmpIndex += (long)complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp40 += tmpLeft4 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp41 += tmpLeft4 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp42 += tmpLeft4 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
            tmp43 += tmpLeft4 * tmpRight3;
            tmp04 += tmpLeft0 * tmpRight4;
            tmp14 += tmpLeft1 * tmpRight4;
            tmp24 += tmpLeft2 * tmpRight4;
            tmp34 += tmpLeft3 * tmpRight4;
            tmp44 += tmpLeft4 * tmpRight4;
        }
        product.set(0L, 0L, tmp00);
        product.set(1L, 0L, tmp10);
        product.set(2L, 0L, tmp20);
        product.set(3L, 0L, tmp30);
        product.set(4L, 0L, tmp40);
        product.set(0L, 1L, tmp01);
        product.set(1L, 1L, tmp11);
        product.set(2L, 1L, tmp21);
        product.set(3L, 1L, tmp31);
        product.set(4L, 1L, tmp41);
        product.set(0L, 2L, tmp02);
        product.set(1L, 2L, tmp12);
        product.set(2L, 2L, tmp22);
        product.set(3L, 2L, tmp32);
        product.set(4L, 2L, tmp42);
        product.set(0L, 3L, tmp03);
        product.set(1L, 3L, tmp13);
        product.set(2L, 3L, tmp23);
        product.set(3L, 3L, tmp33);
        product.set(4L, 3L, tmp43);
        product.set(0L, 4L, tmp04);
        product.set(1L, 4L, tmp14);
        product.set(2L, 4L, tmp24);
        product.set(3L, 4L, tmp34);
        product.set(4L, 4L, tmp44);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_6XN = (product, left, complexity, right) -> {
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_7XN = (product, left, complexity, right) -> {
        left.count();
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_8XN = (product, left, complexity, right) -> {
        left.count();
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_9XN = (product, left, complexity, right) -> {
        left.count();
        int tmpColDim = (int)(right.count() / (long)complexity);
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            product.set(0L, (long)j, tmp0J);
            product.set(1L, (long)j, tmp1J);
            product.set(2L, (long)j, tmp2J);
            product.set(3L, (long)j, tmp3J);
            product.set(4L, (long)j, tmp4J);
            product.set(5L, (long)j, tmp5J);
            product.set(6L, (long)j, tmp6J);
            product.set(7L, (long)j, tmp7J);
            product.set(8L, (long)j, tmp8J);
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyBoth PRIMITIVE_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyBoth.invokePrimitive(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)left.count() / complexity, THRESHOLD);
    };

    public static BigDenseStore.BigMultiplyBoth getBig(long rows, long columns) {
        if (rows > (long)THRESHOLD) {
            return BIG_MT;
        }
        return BIG;
    }

    public static ComplexDenseStore.ComplexMultiplyBoth getComplex(long rows, long columns) {
        if (rows > (long)THRESHOLD) {
            return COMPLEX_MT;
        }
        return COMPLEX;
    }

    public static PrimitiveDenseStore.PrimitiveMultiplyBoth getPrimitive(long rows, long columns) {
        if (rows > (long)THRESHOLD) {
            return PRIMITIVE_MT;
        }
        if (rows == 10L) {
            return PRIMITIVE_0XN;
        }
        if (rows == 9L) {
            return PRIMITIVE_9XN;
        }
        if (rows == 8L) {
            return PRIMITIVE_8XN;
        }
        if (rows == 7L) {
            return PRIMITIVE_7XN;
        }
        if (rows == 6L) {
            return PRIMITIVE_6XN;
        }
        if (rows == 5L && columns == 5L) {
            return PRIMITIVE_5X5;
        }
        if (rows == 4L && columns == 4L) {
            return PRIMITIVE_4X4;
        }
        if (rows == 3L && columns == 3L) {
            return PRIMITIVE_3X3;
        }
        if (rows == 2L && columns == 2L) {
            return PRIMITIVE_2X2;
        }
        if (rows == 1L) {
            return PRIMITIVE_1XN;
        }
        return PRIMITIVE;
    }

    static void invokeBig(ElementsConsumer<BigDecimal> product, int firstRow, int rowLimit, Access1D<BigDecimal> left, int complexity, Access1D<BigDecimal> right) {
        int tmpRowDim = (int)(left.count() / (long)complexity);
        int tmpColDim = (int)(right.count() / (long)complexity);
        BigDecimal[] tmpLeftRow = new BigDecimal[complexity];
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = MatrixUtils.firstInRow(left, i, 0);
            int tmpLimitOfRow = MatrixUtils.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.get(i + c * tmpRowDim);
            }
            for (int j = 0; j < tmpColDim; ++j) {
                int tmpColBase = j * complexity;
                tmpFirst = MatrixUtils.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = MatrixUtils.limitOfColumn(right, j, tmpLimitOfRow);
                BigDecimal tmpVal = BigMath.ZERO;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal = BigFunction.ADD.invoke(tmpVal, BigFunction.MULTIPLY.invoke(tmpLeftRow[c], right.get(c + tmpColBase)));
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    static void invokeComplex(ElementsConsumer<ComplexNumber> product, int firstRow, int rowLimit, Access1D<ComplexNumber> left, int complexity, Access1D<ComplexNumber> right) {
        int tmpRowDim = (int)(left.count() / (long)complexity);
        int tmpColDim = (int)(right.count() / (long)complexity);
        ComplexNumber[] tmpLeftRow = new ComplexNumber[complexity];
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = MatrixUtils.firstInRow(left, i, 0);
            int tmpLimitOfRow = MatrixUtils.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.get(i + c * tmpRowDim);
            }
            for (int j = 0; j < tmpColDim; ++j) {
                int tmpColBase = j * complexity;
                tmpFirst = MatrixUtils.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = MatrixUtils.limitOfColumn(right, j, tmpLimitOfRow);
                ComplexNumber tmpVal = ComplexNumber.ZERO;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal = tmpVal.add(tmpLeftRow[c].multiply(right.get(c + tmpColBase)));
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    static void invokePrimitive(ElementsConsumer<Double> product, int firstRow, int rowLimit, Access1D<Double> left, int complexity, Access1D<Double> right) {
        int tmpRowDim = (int)product.countRows();
        int tmpColDim = (int)product.countColumns();
        double[] tmpLeftRow = new double[complexity];
        int tmpFirst = 0;
        int tmpLimit = complexity;
        for (int i = firstRow; i < rowLimit; ++i) {
            int tmpFirstInRow = MatrixUtils.firstInRow(left, i, 0);
            int tmpLimitOfRow = MatrixUtils.limitOfRow(left, i, complexity);
            for (int c = tmpFirstInRow; c < tmpLimitOfRow; ++c) {
                tmpLeftRow[c] = left.doubleValue(i + c * tmpRowDim);
            }
            for (int j = 0; j < tmpColDim; ++j) {
                int tmpColBase = j * complexity;
                tmpFirst = MatrixUtils.firstInColumn(right, j, tmpFirstInRow);
                tmpLimit = MatrixUtils.limitOfColumn(right, j, tmpLimitOfRow);
                double tmpVal = PrimitiveMath.ZERO;
                for (int c = tmpFirst; c < tmpLimit; ++c) {
                    tmpVal += tmpLeftRow[c] * right.doubleValue(c + tmpColBase);
                }
                product.set((long)i, (long)j, tmpVal);
            }
        }
    }

    private MultiplyBoth() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

