/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ban.status;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AuthenticationFailureStatus {
    private long lastFailure = System.nanoTime();
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private final int maxAttempts;
    private final long duration;

    public AuthenticationFailureStatus(int maxAttempts, int duration) {
        this.maxAttempts = maxAttempts;
        this.duration = TimeUnit.SECONDS.toNanos(duration);
    }

    public void notifyFailed() {
        this.lastFailure = System.nanoTime();
        this.failureCount.incrementAndGet();
    }

    public boolean isValid() {
        return System.nanoTime() - this.lastFailure <= this.duration;
    }

    public boolean isBlocked() {
        return this.isValid() && this.failureCount.get() >= this.maxAttempts;
    }

    public int getFailures() {
        return this.failureCount.get();
    }
}

