/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.shaded.io.netty.util.TimerTask;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class RpcConnection {
    private static final Log LOG = LogFactory.getLog(RpcConnection.class);
    protected final ConnectionId remoteId;
    protected final AuthMethod authMethod;
    protected final boolean useSasl;
    protected final Token<? extends TokenIdentifier> token;
    protected final String serverPrincipal;
    protected final int reloginMaxBackoff;
    protected final Codec codec;
    protected final CompressionCodec compressor;
    protected final HashedWheelTimer timeoutTimer;
    protected final Configuration conf;
    protected static String CRYPTO_AES_ENABLED_KEY = "hbase.rpc.crypto.encryption.aes.enabled";
    protected static boolean CRYPTO_AES_ENABLED_DEFAULT = false;
    protected long lastTouched;

    protected RpcConnection(Configuration conf, HashedWheelTimer timeoutTimer, ConnectionId remoteId, String clusterId, boolean isSecurityEnabled, Codec codec, CompressionCodec compressor) throws IOException {
        if (remoteId.getAddress().isUnresolved()) {
            throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
        }
        this.timeoutTimer = timeoutTimer;
        this.codec = codec;
        this.compressor = compressor;
        this.conf = conf;
        UserGroupInformation ticket = remoteId.getTicket().getUGI();
        SecurityInfo securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
        this.useSasl = isSecurityEnabled;
        Token token = null;
        String serverPrincipal = null;
        if (this.useSasl && securityInfo != null) {
            String serverKey;
            AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
            if (tokenKind != null) {
                TokenSelector<? extends TokenIdentifier> tokenSelector = AbstractRpcClient.TOKEN_HANDLERS.get(tokenKind);
                if (tokenSelector != null) {
                    token = tokenSelector.selectToken(new Text(clusterId), ticket.getTokens());
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No token selector found for type " + tokenKind));
                }
            }
            if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
            }
            serverPrincipal = SecurityUtil.getServerPrincipal((String)conf.get(serverKey), (String)remoteId.address.getAddress().getCanonicalHostName().toLowerCase());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RPC Server Kerberos principal name for service=" + remoteId.getServiceName() + " is " + serverPrincipal));
            }
        }
        this.token = token;
        this.serverPrincipal = serverPrincipal;
        this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
        if (LOG.isDebugEnabled() && !this.authMethod.equals((Object)AuthMethod.SIMPLE) || LOG.isTraceEnabled()) {
            LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for service " + remoteId.serviceName + ", sasl=" + this.useSasl));
        }
        this.reloginMaxBackoff = conf.getInt("hbase.security.relogin.maxbackoff", 5000);
        this.remoteId = remoteId;
    }

    private RPCProtos.UserInformation getUserInfo(UserGroupInformation ugi) {
        if (ugi == null || this.authMethod == AuthMethod.DIGEST) {
            return null;
        }
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        if (this.authMethod == AuthMethod.KERBEROS) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
        } else if (this.authMethod == AuthMethod.SIMPLE) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
            if (ugi.getRealUser() != null) {
                userInfoPB.setRealUser(ugi.getRealUser().getUserName());
            }
        }
        return userInfoPB.build();
    }

    protected UserGroupInformation getUGI() {
        UserGroupInformation ticket = this.remoteId.getTicket().getUGI();
        if (this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
            ticket = ticket.getRealUser();
        }
        return ticket;
    }

    protected boolean shouldAuthenticateOverKrb() throws IOException {
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = currentUser.getRealUser();
        return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
    }

    protected void relogin() throws IOException {
        if (UserGroupInformation.isLoginKeytabBased()) {
            UserGroupInformation.getLoginUser().reloginFromKeytab();
        } else {
            UserGroupInformation.getLoginUser().reloginFromTicketCache();
        }
    }

    protected void scheduleTimeoutTask(final Call call) {
        if (call.timeout > 0) {
            call.timeoutTask = this.timeoutTimer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    call.setTimeout((IOException)((Object)new CallTimeoutException("Call id=" + call.id + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + ", rpcTimeout=" + call.timeout)));
                    RpcConnection.this.callTimeout(call);
                }
            }, (long)call.timeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getConnectionHeaderPreamble() {
        int rpcHeaderLen = HConstants.RPC_HEADER.length;
        byte[] preamble = new byte[rpcHeaderLen + 2];
        System.arraycopy(HConstants.RPC_HEADER, 0, preamble, 0, rpcHeaderLen);
        preamble[rpcHeaderLen] = 0;
        RpcConnection rpcConnection = this;
        synchronized (rpcConnection) {
            preamble[rpcHeaderLen + 1] = this.authMethod.code;
        }
        return preamble;
    }

    protected RPCProtos.ConnectionHeader getConnectionHeader() {
        RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
        builder.setServiceName(this.remoteId.getServiceName());
        RPCProtos.UserInformation userInfoPB = this.getUserInfo(this.remoteId.ticket.getUGI());
        if (userInfoPB != null) {
            builder.setUserInfo(userInfoPB);
        }
        if (this.codec != null) {
            builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
        }
        if (this.compressor != null) {
            builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
        }
        builder.setVersionInfo(ProtobufUtil.getVersionInfo());
        boolean isCryptoAESEnable = this.conf.getBoolean(CRYPTO_AES_ENABLED_KEY, CRYPTO_AES_ENABLED_DEFAULT);
        if (isCryptoAESEnable) {
            builder.setRpcCryptoCipherTransformation(this.conf.get("hbase.rpc.crypto.encryption.aes.cipher.transform", "AES/CTR/NoPadding"));
        }
        return builder.build();
    }

    protected abstract void callTimeout(Call var1);

    public ConnectionId remoteId() {
        return this.remoteId;
    }

    public long getLastTouched() {
        return this.lastTouched;
    }

    public void setLastTouched(long lastTouched) {
        this.lastTouched = lastTouched;
    }

    public abstract boolean isActive();

    public abstract void shutdown();

    public abstract void sendRequest(Call var1, HBaseRpcController var2) throws IOException;

    public abstract void cleanupConnection();
}

