/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncClientScanner;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.AsyncTableBase;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.RegionCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RawAsyncTableImpl
implements RawAsyncTable {
    private final AsyncConnectionImpl conn;
    private final TableName tableName;
    private final int defaultScannerCaching;
    private final long defaultScannerMaxResultSize;
    private final long rpcTimeoutNs;
    private final long readRpcTimeoutNs;
    private final long writeRpcTimeoutNs;
    private final long operationTimeoutNs;
    private final long scanTimeoutNs;
    private final long pauseNs;
    private final int maxAttempts;
    private final int startLogErrorsCnt;

    RawAsyncTableImpl(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder) {
        this.conn = conn;
        this.tableName = builder.tableName;
        this.rpcTimeoutNs = builder.rpcTimeoutNs;
        this.readRpcTimeoutNs = builder.readRpcTimeoutNs;
        this.writeRpcTimeoutNs = builder.writeRpcTimeoutNs;
        this.operationTimeoutNs = builder.operationTimeoutNs;
        this.scanTimeoutNs = builder.scanTimeoutNs;
        this.pauseNs = builder.pauseNs;
        this.maxAttempts = builder.maxAttempts;
        this.startLogErrorsCnt = builder.startLogErrorsCnt;
        this.defaultScannerCaching = this.tableName.isSystemTable() ? conn.connConf.getMetaScannerCaching() : conn.connConf.getScannerCaching();
        this.defaultScannerMaxResultSize = conn.connConf.getScannerMaxResultSize();
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    private static <REQ, PREQ, PRESP, RESP> CompletableFuture<RESP> call(final HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<PREQ, byte[], REQ> reqConvert, RpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, HBaseRpcController, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        try {
            rpcCall.call(stub, controller, reqConvert.convert(loc.getRegion().getRegionName(), req), new RpcCallback<PRESP>(){

                public void run(PRESP resp) {
                    if (controller.failed()) {
                        future.completeExceptionally(controller.getFailed());
                    } else {
                        try {
                            future.complete(respConverter.convert(controller, resp));
                        }
                        catch (IOException e) {
                            future.completeExceptionally(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static <REQ, RESP> CompletableFuture<RESP> mutate(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<ClientProtos.MutateRequest, byte[], REQ> reqConvert, Converter<RESP, HBaseRpcController, ClientProtos.MutateResponse> respConverter) {
        return RawAsyncTableImpl.call(controller, loc, stub, req, reqConvert, (s, c, r, done) -> s.mutate((RpcController)c, r, done), respConverter);
    }

    private static <REQ> CompletableFuture<Void> voidMutate(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, Converter<ClientProtos.MutateRequest, byte[], REQ> reqConvert) {
        return RawAsyncTableImpl.mutate(controller, loc, stub, req, reqConvert, (c, resp) -> null);
    }

    private static Result toResult(HBaseRpcController controller, ClientProtos.MutateResponse resp) throws IOException {
        if (!resp.hasResult()) {
            return null;
        }
        return ProtobufUtil.toResult(resp.getResult(), controller.cellScanner());
    }

    private <REQ, RESP> CompletableFuture<RESP> noncedMutate(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, REQ req, NoncedConverter<ClientProtos.MutateRequest, byte[], REQ> reqConvert, Converter<RESP, HBaseRpcController, ClientProtos.MutateResponse> respConverter) {
        long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
        long nonce = this.conn.getNonceGenerator().newNonce();
        return RawAsyncTableImpl.mutate(controller, loc, stub, req, (info, src) -> (ClientProtos.MutateRequest)reqConvert.convert((byte[])info, (Object)src, nonceGroup, nonce), respConverter);
    }

    private <T> AsyncRpcRetryingCallerFactory.SingleRequestCallerBuilder<T> newCaller(byte[] row, long rpcTimeoutNs) {
        return this.conn.callerFactory.single().table(this.tableName).row(row).rpcTimeout(rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <T> AsyncRpcRetryingCallerFactory.SingleRequestCallerBuilder<T> newCaller(Row row, long rpcTimeoutNs) {
        return this.newCaller(row.getRow(), rpcTimeoutNs);
    }

    @Override
    public CompletableFuture<Result> get(Get get) {
        return this.newCaller(get, this.readRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.call(controller, loc, stub, get, RequestConverter::buildGetRequest, (s, c, req, done) -> s.get((RpcController)c, req, done), (c, resp) -> ProtobufUtil.toResult(resp.getResult(), c.cellScanner()))).call();
    }

    @Override
    public CompletableFuture<Void> put(Put put) {
        return this.newCaller(put, this.writeRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.voidMutate(controller, loc, stub, put, RequestConverter::buildMutateRequest)).call();
    }

    @Override
    public CompletableFuture<Void> delete(Delete delete) {
        return this.newCaller(delete, this.writeRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.voidMutate(controller, loc, stub, delete, RequestConverter::buildMutateRequest)).call();
    }

    @Override
    public CompletableFuture<Result> append(Append append) {
        ConnectionUtils.checkHasFamilies(append);
        return this.newCaller(append, this.rpcTimeoutNs).action((controller, loc, stub) -> this.noncedMutate(controller, loc, stub, append, RequestConverter::buildMutateRequest, RawAsyncTableImpl::toResult)).call();
    }

    @Override
    public CompletableFuture<Result> increment(Increment increment) {
        ConnectionUtils.checkHasFamilies(increment);
        return this.newCaller(increment, this.rpcTimeoutNs).action((controller, loc, stub) -> this.noncedMutate(controller, loc, stub, increment, RequestConverter::buildMutateRequest, RawAsyncTableImpl::toResult)).call();
    }

    @Override
    public AsyncTableBase.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    private static <RESP> CompletableFuture<RESP> mutateRow(final HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub, final RowMutations mutation, Converter<ClientProtos.MultiRequest, byte[], RowMutations> reqConvert, final Function<Result, RESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        try {
            final byte[] regionName = loc.getRegion().getRegionName();
            final ClientProtos.MultiRequest req = reqConvert.convert(regionName, mutation);
            stub.multi((RpcController)controller, req, (RpcCallback)new RpcCallback<ClientProtos.MultiResponse>(){

                public void run(ClientProtos.MultiResponse resp) {
                    if (controller.failed()) {
                        future.completeExceptionally(controller.getFailed());
                    } else {
                        try {
                            MultiResponse multiResp = ResponseConverter.getResults(req, resp, controller.cellScanner());
                            Throwable ex = multiResp.getException(regionName);
                            if (ex != null) {
                                future.completeExceptionally(ex instanceof IOException ? ex : new IOException("Failed to mutate row: " + Bytes.toStringBinary((byte[])mutation.getRow()), ex));
                            } else {
                                future.complete(respConverter.apply((Result)multiResp.getResults().get((Object)regionName).result.get(0)));
                            }
                        }
                        catch (IOException e) {
                            future.completeExceptionally(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> mutateRow(RowMutations mutation) {
        return this.newCaller(mutation, this.writeRpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutateRow(controller, loc, stub, mutation, (rn, rm) -> {
            ClientProtos.RegionAction.Builder regionMutationBuilder = RequestConverter.buildRegionAction(rn, rm);
            regionMutationBuilder.setAtomic(true);
            return ClientProtos.MultiRequest.newBuilder().addRegionAction(regionMutationBuilder.build()).build();
        }, resp -> null)).call();
    }

    private Scan setDefaultScanConfig(Scan scan) {
        Scan newScan = (Scan)ReflectionUtils.newInstance(scan.getClass(), (Object[])new Object[]{scan});
        if (newScan.getCaching() <= 0) {
            newScan.setCaching(this.defaultScannerCaching);
        }
        if (newScan.getMaxResultSize() <= 0L) {
            newScan.setMaxResultSize(this.defaultScannerMaxResultSize);
        }
        return newScan;
    }

    @Override
    public CompletableFuture<List<Result>> scanAll(Scan scan) {
        final CompletableFuture<List<Result>> future = new CompletableFuture<List<Result>>();
        final ArrayList scanResults = new ArrayList();
        this.scan(scan, new RawScanResultConsumer(){

            @Override
            public void onNext(Result[] results, RawScanResultConsumer.ScanController controller) {
                scanResults.addAll(Arrays.asList(results));
            }

            @Override
            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            @Override
            public void onComplete() {
                future.complete(scanResults);
            }
        });
        return future;
    }

    @Override
    public void scan(Scan scan, RawScanResultConsumer consumer) {
        new AsyncClientScanner(this.setDefaultScanConfig(scan), consumer, this.tableName, this.conn, this.pauseNs, this.maxAttempts, this.scanTimeoutNs, this.readRpcTimeoutNs, this.startLogErrorsCnt).start();
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        return this.batch(gets, this.readRpcTimeoutNs);
    }

    @Override
    public List<CompletableFuture<Void>> put(List<Put> puts) {
        return this.voidMutate(puts);
    }

    @Override
    public List<CompletableFuture<Void>> delete(List<Delete> deletes) {
        return this.voidMutate(deletes);
    }

    @Override
    public <T> List<CompletableFuture<T>> batch(List<? extends Row> actions) {
        return this.batch(actions, this.rpcTimeoutNs);
    }

    private List<CompletableFuture<Void>> voidMutate(List<? extends Row> actions) {
        return this.batch(actions, this.writeRpcTimeoutNs).stream().map(f -> f.thenApply(r -> null)).collect(Collectors.toList());
    }

    private <T> List<CompletableFuture<T>> batch(List<? extends Row> actions, long rpcTimeoutNs) {
        return this.conn.callerFactory.batch().table(this.tableName).actions(actions).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).rpcTimeout(rpcTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).call();
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return unit.convert(this.rpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(this.readRpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(this.writeRpcTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeoutNs, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getScanTimeout(TimeUnit unit) {
        return unit.convert(this.scanTimeoutNs, TimeUnit.NANOSECONDS);
    }

    private <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, RegionInfo region, byte[] row) {
        RegionCoprocessorRpcChannelImpl channel = new RegionCoprocessorRpcChannelImpl(this.conn, this.tableName, region, row, this.rpcTimeoutNs, this.operationTimeoutNs);
        S stub = stubMaker.apply(channel);
        CompletableFuture future = new CompletableFuture();
        ClientCoprocessorRpcController controller = new ClientCoprocessorRpcController();
        callable.call(stub, controller, resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, byte[] row) {
        return this.coprocessorService(stubMaker, callable, null, row);
    }

    private boolean locateFinished(RegionInfo region, byte[] endKey, boolean endKeyInclusive) {
        if (ConnectionUtils.isEmptyStopRow(endKey)) {
            return ConnectionUtils.isEmptyStopRow(region.getEndKey());
        }
        if (ConnectionUtils.isEmptyStopRow(region.getEndKey())) {
            return true;
        }
        int c = Bytes.compareTo((byte[])endKey, (byte[])region.getEndKey());
        return c < 0 || c == 0 && !endKeyInclusive;
    }

    private <S, R> void onLocateComplete(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, RawAsyncTable.CoprocessorCallback<R> callback, List<HRegionLocation> locs, byte[] endKey, boolean endKeyInclusive, AtomicBoolean locateFinished, AtomicInteger unfinishedRequest, HRegionLocation loc, Throwable error) {
        if (error != null) {
            callback.onError(error);
            return;
        }
        unfinishedRequest.incrementAndGet();
        RegionInfo region = loc.getRegion();
        if (this.locateFinished(region, endKey, endKeyInclusive)) {
            locateFinished.set(true);
        } else {
            this.conn.getLocator().getRegionLocation(this.tableName, region.getEndKey(), RegionLocateType.CURRENT, this.operationTimeoutNs).whenComplete((l, e) -> this.onLocateComplete(stubMaker, callable, callback, locs, endKey, endKeyInclusive, locateFinished, unfinishedRequest, (HRegionLocation)l, (Throwable)e));
        }
        this.coprocessorService(stubMaker, callable, region, region.getStartKey()).whenComplete((r, e) -> {
            if (e != null) {
                callback.onRegionError(region, (Throwable)e);
            } else {
                callback.onRegionComplete(region, r);
            }
            if (unfinishedRequest.decrementAndGet() == 0 && locateFinished.get()) {
                callback.onComplete();
            }
        });
    }

    @Override
    public <S, R> void coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, byte[] startKey, boolean startKeyInclusive, byte[] endKey, boolean endKeyInclusive, RawAsyncTable.CoprocessorCallback<R> callback) {
        byte[] nonNullStartKey = Optional.ofNullable(startKey).orElse(HConstants.EMPTY_START_ROW);
        byte[] nonNullEndKey = Optional.ofNullable(endKey).orElse(HConstants.EMPTY_END_ROW);
        ArrayList locs = new ArrayList();
        this.conn.getLocator().getRegionLocation(this.tableName, nonNullStartKey, startKeyInclusive ? RegionLocateType.CURRENT : RegionLocateType.AFTER, this.operationTimeoutNs).whenComplete((loc, error) -> this.onLocateComplete(stubMaker, callable, callback, locs, nonNullEndKey, endKeyInclusive, new AtomicBoolean(false), new AtomicInteger(0), (HRegionLocation)loc, (Throwable)error));
    }

    private final class CheckAndMutateBuilderImpl
    implements AsyncTableBase.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareOperator op;
        private byte[] value;

        public CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
        }

        @Override
        public AsyncTableBase.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        @Override
        public AsyncTableBase.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        @Override
        public AsyncTableBase.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = (CompareOperator)((Object)Preconditions.checkNotNull((Object)((Object)compareOp), (Object)"compareOp is null"));
            this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return this;
        }

        private void preCheck() {
            Preconditions.checkNotNull((Object)((Object)this.op), (Object)"condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
        }

        @Override
        public CompletableFuture<Boolean> thenPut(Put put) {
            this.preCheck();
            return RawAsyncTableImpl.this.newCaller(this.row, RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, put, (rn, p) -> RequestConverter.buildMutateRequest(rn, this.row, this.family, this.qualifier, (ByteArrayComparable)new BinaryComparator(this.value), HBaseProtos.CompareType.valueOf((String)this.op.name()), p), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenDelete(Delete delete) {
            this.preCheck();
            return RawAsyncTableImpl.this.newCaller(this.row, RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutate(controller, loc, stub, delete, (rn, d) -> RequestConverter.buildMutateRequest(rn, this.row, this.family, this.qualifier, (ByteArrayComparable)new BinaryComparator(this.value), HBaseProtos.CompareType.valueOf((String)this.op.name()), d), (c, r) -> r.getProcessed())).call();
        }

        @Override
        public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
            this.preCheck();
            return RawAsyncTableImpl.this.newCaller(mutation, RawAsyncTableImpl.this.rpcTimeoutNs).action((controller, loc, stub) -> RawAsyncTableImpl.mutateRow(controller, loc, stub, mutation, (rn, rm) -> RequestConverter.buildMutateRequest(rn, this.row, this.family, this.qualifier, (ByteArrayComparable)new BinaryComparator(this.value), HBaseProtos.CompareType.valueOf((String)this.op.name()), rm), resp -> resp.getExists())).call();
        }
    }

    @FunctionalInterface
    private static interface NoncedConverter<D, I, S> {
        public D convert(I var1, S var2, long var3, long var5) throws IOException;
    }

    @FunctionalInterface
    private static interface RpcCall<RESP, REQ> {
        public void call(ClientProtos.ClientService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }

    @FunctionalInterface
    private static interface Converter<D, I, S> {
        public D convert(I var1, S var2) throws IOException;
    }
}

